/**
 * Copyright JohnBrookes ( http://wonderfl.net/user/JohnBrookes )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m5at
 */

// forked from darknet's flash on 2009-7-9
//aready done by John Lindquist :)
//http://pv3d.org/2008/11/25/mouse-follower/

package 
{
	import flash.events.Event;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.view.BasicView;
	
	public class Papervision3DPolygonPoint extends BasicView
	{
		public var plane:Plane = new Plane(null, 512, 512,4,4);
		public var cube:Cube;
		
		public function Papervision3DPolygonPoint() 
		{
			viewport.interactive = true;
			camera.z = -300;
			camera.y = 300;
			var center:DisplayObject3D = new DisplayObject3D();
			camera.lookAt(center);
			scenecube();
			buildterrain();
			startRendering();
		}
		
		public function scenecube():void {
			var mat:ColorMaterial = new ColorMaterial(0x999999);
			var matlib:MaterialsList = new MaterialsList( { all:mat } );
			cube = new Cube(matlib, 32, 32, 32);
			cube.y = 16;
			scene.addChild(cube);
		}
		
		public function buildterrain():void {
			var mat:ColorMaterial = new ColorMaterial(0x555500);
			mat.interactive = true;
			mat.smooth = true;
			plane.material = mat;
			plane.rotationX = 90;
			plane.rotationY = 0;
			plane.rotationZ = 0;
			//plane.culled = true;
			plane.autoCalcScreenCoords = true;
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, pointdown);
			plane.addEventListener(InteractiveScene3DEvent.OBJECT_MOVE, pointmove);
			scene.addChild(plane);
		}
		
		public function pointdown(event:InteractiveScene3DEvent):void {
			trace('[' + event.renderHitData.x+':'+event.renderHitData.y+':'+event.renderHitData.z+']');
		}
		public function pointmove(event:InteractiveScene3DEvent):void {
			//trace('[' + event.renderHitData.x+':'+event.renderHitData.y+':'+event.renderHitData.z+']');
			cube.x = event.renderHitData.x;
			//cube.y = event.renderHitData.y;
			cube.z = event.renderHitData.z;
		}
		
		override protected function onRenderTick(event:Event=null):void
		{
			super.onRenderTick(event);
		}
		
	}
	
}