/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m5Yw
 */

package {
    import flash.display.TriangleCulling
    import flash.utils.getTimer;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Matrix3D;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var solid:Object = new Object
            solid.verts = new Vector.<Number>
            solid.verts.push(0,1,0,1,0,0,0,0,1,-1,0,0,0,0,-1,0,-1,0)
            solid.indices = new Vector.<int>
            solid.indices.push(0,1,2,0,2,3,0,3,4,0,4,1,5,2,1,5,3,2,5,4,3,5,1,4)
            var arrowSolid:Object = new Object
            arrowSolid.verts = new Vector.<Number>
            arrowSolid.verts.push(0,-1,0,1,1,0,0,1,1,-1,1,0,0,1,-1)
            arrowSolid.indices = new Vector.<int>
            arrowSolid.indices.push(0,1,2,0,2,3,0,3,4,0,4,1,5,2,1)
            var drawSolid:Function = function(shape:Object,matrix:Matrix3D,color:uint):void {
                var uvtData:Vector.<Number> = new Vector.<Number>
                var persVerts:Vector.<Number> = new Vector.<Number>
                Utils3D.projectVectors(matrix, shape.verts, persVerts, uvtData)
                persVerts.map(function(item:Number, index:int, vector:Vector.<Number>):void {
                    vector[index] += (index%2==0) ? stage.stageWidth/2 : stage.stageHeight/2
                })
                graphics.lineStyle(0,color)
                graphics.drawTriangles(persVerts, shape.indices, uvtData, TriangleCulling.NEGATIVE)
            }
            var target:Vector3D = new Vector3D(0,0,4)
            var radius:int = 20  
            var arrows:Vector.<Vector3D> = new Vector.<Vector3D>
            for (var i:int=0;i<30;i++) {
                arrows.push(new Vector3D(
                    radius*(Math.random()-0.5),
                    radius*(Math.random()-0.5),
                    radius*(Math.random()-0.5)
                ))
            }            
            var pers:PerspectiveProjection = new PerspectiveProjection
            var persMatrix:Matrix3D = pers.toMatrix3D()
            var worldMatrix:Matrix3D = new Matrix3D
            var solidMatrix:Matrix3D = new Matrix3D  
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                graphics.clear()
                with (worldMatrix) {
                    identity()
                    appendRotation(getTimer()*0.05,new Vector3D(0,1,0.5))
                    appendTranslation(0,0,-30)
                    append(persMatrix)
                }
                var n:int = arrows.length
                while (n--) {
                    var face:Vector3D = Vector3D.Y_AXIS
                    var diff:Vector3D = arrows[n].subtract(target)
                    var axis:Vector3D = face.crossProduct(diff)
                    var theta:Number = Vector3D.angleBetween(face,diff)*180/Math.PI
                    with (solidMatrix) {
                        identity()
                        appendRotation(theta,axis)
                        appendTranslation(arrows[n].x,arrows[n].y,arrows[n].z)       
                        append(worldMatrix)
                    }
                    drawSolid(arrowSolid,solidMatrix,0x007000)
                }
                with (solidMatrix) {
                    identity()
                    appendTranslation(target.x,target.y,target.z)                            
                    append(worldMatrix)
                }
                drawSolid(solid,solidMatrix,0xa00000)                
            })                 
        }
    }
}
