/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m44V
 */

//
//	関節っぽいものが付いてるライン
//	Anyキーを押すと雀の涙程度にモードが切り替わります。
//	
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.text.TextField;
	
   [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")] 
 	
	/***********************************************************************
	 * メインクラス
	 * @author okoi
	 */
	public class Main extends Sprite 
	{
		private var pathList:Array = new Array();
		private var jointList:Array = new Array();		//	固定用
		private var jointList2:Array = new Array();		//	移動用
		
		private var mode:int = 0;
		
		private var text:TextField = new TextField();
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			
			addPath( 465/2-50, 465/2-50, pathList );
			addPath( 465/2-20, 465/2-20, pathList );
			addPath( 465/2-10, 465/2-10, pathList );
			addPath( 465/2, 465/2, pathList );
			
			//	固定用
			addJoint( 0, 1, 0, jointList, pathList );
			addJoint( 1, 2, 0.5, jointList, pathList );
			addJoint( 2, 3, 1, jointList, pathList );
			//	移動用
			addJoint( 0, 1, 0, jointList2, pathList );
			addJoint( 1, 2, 0, jointList2, pathList );
			addJoint( 2, 3, 0, jointList2, pathList );
			
			addEventListener( Event.ENTER_FRAME, EnterFrame );
			stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);

			text.textColor = 0xFFFFFF;
			SetText();
			addChild(text);
		}
		
		private function EnterFrame(event:Event) : void {
			
			var i:int = 0;
			var j:PathJoint;
			
			//	パスの先頭をマウスと合わせる
			pathList[0]._x = stage.mouseX;
			pathList[0]._y = stage.mouseY;
			
			if ( mode == 0 )
			{
				for ( i = 0; i < jointList.length; i++ )	jointList[i].Calc();
				for ( i = jointList.length - 1; i >= 0; i-- )	jointList[i].Calc();
			}else
			{
				for each( j in jointList2 ) j.Calc();
			}
			
			graphics.clear();
			for each( j in jointList ) j.DrawSprite( this );
			for each( var p:Path in pathList ) p.DrawSprite( this );
		}
		
		private function KeyDown(event:KeyboardEvent) : void {
		
				mode ^= 1;
				SetText();
			
		}
		
		private function SetText() : void {
			if ( mode == 0 )	text.text = "Anyキーでモード変更！ 現在のモード【固定】";
			else				text.text = "Anyキーでモード変更！ 現在のモード【移動】"; 	
			text.width = text.textWidth + 4;
			text.height = text.textHeight + 4;
		}
	}	
}
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
import flash.display.Sprite;

/**
 * パス追加処理
 * @param	_x
 * @param	_y
 * @param	list
 */
function addPath(_x:Number, _y:Number, list:Array):void 
{
	list.push( new Path( null, _x, _y ) );
}

/**
 * パスとパスの結合要素を追加
 * @param	start
 * @param	end
 * @param	ratio	startパスに掛かる力
 * @param	jList	結合要素リスト
 * @param	pList	パス要素リスト
 */
function addJoint(start:int, end:int, ratio:Number, jList:Array, pList:Array):void 
{
	jList.push( new PathJoint( null, pList[start], pList[end], ratio ) );
}


/***************************************************************************
 * パスクラス
 */
class Path {
	private var _parent:Sprite;
	public var _x:Number;
	public var _y:Number;
	
	public	function Path(_p:Sprite, __x:Number, __y:Number) {
		_parent = _parent;
		_x = __x;
		_y = __y;
	}
	
	public	function DrawSprite(_sp:Sprite=null):void 
	{
		if ( _sp == null )
		{
			if ( _parent == null ) return;
			_sp = _parent;
		}
		_sp.graphics.lineStyle(3, 0xFF0000);
		_sp.graphics.drawCircle(_x, _y, 5);
	}
}
/***************************************************************************
 * パスとパスを繋げるクラス
 */
class PathJoint {
	
	private var _parent:Sprite;
	private var _Start:Path;
	private var _End:Path;
	private var _defLength:Number;
	
	private var _ratio:Number;		//	_Startに掛かる力
	
	public function PathJoint (_p:Sprite, _sp:Path, _ep:Path, _r:Number = 0.5) {
		_parent = _p;
		_Start  = _sp;
		_End 	= _ep;
		_defLength = Math.sqrt( (_ep._x - _sp._x) * (_ep._x - _sp._x) + (_ep._y - _sp._y) * (_ep._y - _sp._y) );
		
		_ratio = _r;
	}
	
	/**
	 * パス間の距離が初期状態と変わっていたら、パスの座標にその差分を増減させて、パス間の距離を一定に保つ
	 */
	public function Calc() : void {
		
		var vecX:Number = _End._x - _Start._x;
		var vecY:Number = _End._y - _Start._y;
		var length:Number = Math.sqrt( vecX * vecX + vecY * vecY );
		//	パスの方向ベクトル（正規化)
		var nx:Number = vecX / length;
		var ny:Number = vecY / length;
		
		if ( _defLength == length )
		{
		}else
		{
			length = _defLength;
			
			nx *= length;
			ny *= length;
			
			//	距離の差分をパスの座標に反映させる
			_Start._x += (vecX - nx) * _ratio;
			_Start._y += (vecY - ny) * _ratio;
			_End._x -= (vecX - nx) * (1-_ratio);
			_End._y -= (vecY - ny) * (1-_ratio);		
		}
	}
	
	public	function DrawSprite(_sp:Sprite):void 
	{
		if ( _sp == null )
		{
			if ( _parent == null ) return;
			_sp = _parent;
		}
		_sp.graphics.lineStyle(3, 0xFF0000);
		_sp.graphics.moveTo(_Start._x, _Start._y);
		_sp.graphics.lineTo(_End._x, _End._y);
	}
	
}




