/**
 * Copyright ll_koba_ll ( http://wonderfl.net/user/ll_koba_ll )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m3EG
 */

/**
 * 詳解ActionScript3.0アニメーション 3章 等角投影 やってみる
 */
package 
{
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.geom.Point;
    
    [SWF(backgroundColor="#000000")]
    public class IsometricTest extends Sprite 
    {
        public function IsometricTest()
        {
            addEventListener(Event.ADDED_TO_STAGE, _init);
        }

        private function _init(e:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, _init);
            stage.align = "LT";
            stage.scaleMode = "noScale";

            var p0:Point3D = new Point3D(0,0,0);
            var p1:Point3D = new Point3D(100, 0, 0);
            var p2:Point3D = new Point3D(100, 0, 100);
            var p3:Point3D = new Point3D(0, 0, 100);

            var sp0:Point = IsoUtils.isoToScree(p0);
            var sp1:Point = IsoUtils.isoToScree(p1);
            var sp2:Point = IsoUtils.isoToScree(p2);
            var sp3:Point = IsoUtils.isoToScree(p3);

            var tile:Sprite = new Sprite();
            tile.x = 200;
            tile.y = 200;
            addChild(tile);

            var g:Graphics = tile.graphics;

            g.lineStyle(1, 0xFFFFFF);
            g.moveTo(sp0.x, sp0.y);
            g.lineTo(sp1.x, sp1.y);
            g.lineTo(sp2.x, sp2.y);
            g.lineTo(sp3.x, sp3.y);
            g.lineTo(sp0.x, sp0.y);

        }
    }
}


class Point3D 
{
    public var x:Number;
    public var y:Number;
    public var z:Number;

    public function Point3D(x:Number = 0, y:Number = 0, z:Number = 0)
    {
        this.x = x;
        this.y = y;
        this.z = z;
    }
}




import flash.geom.Point;

class IsoUtils
{
    public static const Y_CORRECT:Number = Math.cos(-Math.PI/6) * Math.SQRT2;

    public static function isoToScree(pos:Point3D):Point 
    {
        var screenX:Number = pos.x - pos.z;
        var screenY:Number = pos.y * Y_CORRECT + (pos.x + pos.z) * .5;
        return new Point(screenX, screenY);
    }

    public static function screenToIso(point:Point):Point3D 
    {
        var xpos:Number = point.y + point.x * .5;
        var ypos:Number = 0;
        var zpos:Number = point.y - point.x * .5;
        return new Point3D(xpos, ypos, zpos);
    }
}

