/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m2dQ
 */

package {
    import com.bit101.charts.LineChart;
    import flash.display.*;
    import flash.events.Event;

    public class YonatanGaussian extends Sprite {
        private var lineChart:LineChart;
        public function YonatanGaussian() {
            var uniformDist:Shape = visualize(uniformRnd, 20000);
            addChild(uniformDist);

            var gaussDist:Shape = visualize(gaussRnd, 20000);
            gaussDist.y = 220;
            addChild(gaussDist);
            
            lineChart = new LineChart(this, 10, 10);
            addEventListener(Event.ENTER_FRAME, once);
        }
        
        private function once(e:Event):void 
        {
            var number:Number;
            var g:Number;
            removeEventListener(Event.ENTER_FRAME, once);
            var xx:Number;
            lineChart.data = [];
            var d:Array = lineChart.data;
            var l:uint = 101;
            var l1:Number = 1 / l;
            for (var i:int = 0; i < l; i++) 
            {
                xx = i * l1;
                number = xx * 2 - 1;
                g = gauss(number);
                d[i] = g ;
                trace( ""+i+" : "+number.toFixed(2)+', ' + d[i] );
            }
            //lineChart.draw();
        }

        // Uniform random number between -1 and 1
        private function uniformRnd():Number { return Math.random()*2-1 }

        // Normal (gaussian) random number,
        // Box-Muller method, loosely based on code from Numerical Recipes - 
        // http://apps.nrbook.com/c/index.html - pages 289-290
        private function gaussRnd():Number {
            var stddev:Number = 0.5; // standard deviation
            var u:Number, v:Number, rsq:Number, fac:Number;

            // pick uniform random (u,v) inside the unit circle
            do {
                u = uniformRnd();
                v = uniformRnd();
                rsq = u*u + v*v;
            } while(rsq >= 1 || rsq == 0);

            return stddev * Math.sqrt(-2.0 * Math.log(rsq) / rsq) * u; // v can be swapped for u
        }
        private function gauss(u:Number):Number {
            var stddev:Number = 0.5; // standard deviation
            var v:Number=0; 
            var rsq:Number;

            rsq = u*u + v*v;

            return stddev * Math.sqrt(-2.0 * Math.log(rsq) / rsq) * u; // v can be swapped for u
        }

        private function visualize(rnd:Function, cnt:int):Shape {
            var canvas:Shape = new Shape;
            var bins:Vector.<Number> = new Vector.<Number>(200);
            
            while(cnt--) {
                var idx:int = rnd()*100+100;
                if(idx >= 0 && idx < 200) { // normal random can be out of bounds
                    bins[idx]++;
                }
            }

            canvas.graphics.clear();
            canvas.graphics.beginFill(0x808080);
            for(var i:int = 0; i < 200; i++) canvas.graphics.drawRect(i*2, 200-bins[i], 2, bins[i]);
            canvas.graphics.endFill();
            return canvas;
        }
    }
}