/**
 * Copyright gupon ( http://wonderfl.net/user/gupon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m0FH
 */

// forked from enok's Frocessingで3D
// Frocessingで3Dの曲線を試す。
// http://linkalink.jp/enok/?p=709

package {
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import frocessing.display.F5MovieClip3D;
	import com.flashdynamix.utils.SWFProfiler;
	import frocessing.display.F5MovieClip3DBmp;
	import frocessing.f3d.models.F3DSphere;
	import frocessing.math.FMath;
	
	[SWF(backgroundColor = "0x111111", frameRate = "24", width = "480", height = "480")] 
	
	public class Frocessing extends F5MovieClip3D{
		private var _w:Number = 0;
		private var _h:Number = 0;
		private var _ca:Number = 0;
		
		private var _sphere_segments:uint = 24;
		private var _sphere_point_list:Array;
		private var _line_head_point_list:Array = new Array();
		private var _line_point_list:Array = new Array();
		private var _line_point_num:uint = 40;
		private var _line_num:uint = 20;
		private var _line_aim:Array = new Array();
		private var _count:uint = 0;
		private var _start_flg:Boolean = false;
		private var _mouse_flg:Boolean = false;
		private var _camera_count:uint = 0;
		private var _camera_vec:int = 1;

		public function Frocessing():void {
			//SWFProfiler.init(stage, this);
			QHigh();
			
			_w = stage.stageWidth;
			_h = stage.stageHeight;
			size(_w, _h);
		}
		
		public function setup():void {
			//noLoop();
			sphereDetail(_sphere_segments);
			_sphere_point_list = getSphere(200);
			
			for (var i:uint = 0; i < _line_num;i++ ) {
				var point_head:ekPoint = new ekPoint(0, 0, 0);
				_line_head_point_list.push(point_head);
				_line_point_list[i] = new Array();
				_line_aim[i] = new Array();
				_line_aim[i][0] = false;
			}
			var timer:Timer = new Timer(50, 0); 
			timer.addEventListener(TimerEvent.TIMER, createLinePoint); 
			timer.start(); 
		}
		
		public function createLinePoint(e:TimerEvent):void {
			for (var j:uint = 0; j < _line_num;j++ ) {
				var point:ekPoint = new ekPoint(_line_head_point_list[j].x, _line_head_point_list[j].y, _line_head_point_list[j].z);

				_line_point_list[j].push(point);
				for (var i:uint = 0; i < _line_point_list[j].length; i++){
					if ( _line_point_list[j].length > _line_point_num ) {
						point = _line_point_list[j].shift();
						break;
					}
				}	
			}
		}
		
		public function draw():void {
			background(0x111111); 
			setCamera();
			moveSphere();
			if(_start_flg){
				moveLine();
			}
		}
		
		private function setCamera():void {
			camera( _w / 2 + 550.0 * cos(_ca), _h / 2, (550-_camera_count) * sin(_ca), _w / 2, _h / 2, 0.0, 0.0, 1.0, 0.0);
			_ca += 0.006;
			if (_camera_count >= 550 && _camera_vec == 1) {
				_camera_vec = -1;
			}else if (_camera_count <= 0 && _camera_vec == -1) {
				_camera_vec = 1;
			}
			_camera_count = _camera_count+_camera_vec;
		}
		
		private function moveLine():void {
			for (var j:uint = 0; j < _line_num; j++ ) {
				if (!_line_aim[j][0]) {
					var t:uint = random(0, _sphere_point_list.length);
					var tt:uint = random(0, _sphere_point_list[0].length);
					_line_aim[j][0] = true;
					_line_aim[j][1] = _sphere_point_list[t][tt][0];
					_line_aim[j][2] = _sphere_point_list[t][tt][1];
					_line_aim[j][3] = _sphere_point_list[t][tt][2];
				}else if (floor(_line_aim[j][1] - _line_head_point_list[j].x) < 0.01 && 
							floor(_line_aim[j][2] - _line_head_point_list[j].y) < 0.01 && 
							floor(_line_aim[j][3] - _line_head_point_list[j].z) < 0.01) {
					_line_aim[j][0] = false;
				}
				
				setPointHead(j, _line_aim[j][1], _line_aim[j][2], _line_aim[j][3]);
			}
			drawLine();
		}
		private function setPointHead(pi:uint, targetX:Number, targetY:Number, targetZ:Number):void {
			var vx:Number = ( targetX - _line_head_point_list[pi].x ) / 10;
			var vy:Number = ( targetY - _line_head_point_list[pi].y ) / 10;
			var vz:Number = ( targetZ - _line_head_point_list[pi].z ) / 10;
			_line_head_point_list[pi].x += vx;
			_line_head_point_list[pi].y += vy;
			_line_head_point_list[pi].z += vz;
		}
		
		private function drawLine():void {
			var i:int, j:int;
			colorMode( HSV, 1, 1, 1 );
			pushMatrix();
			translate(_w / 2, _h / 2, 0);
			for (j = 0; j < _line_num; j++ ) {
				if (_line_point_list[j].length >= 3) {
					var length_last:int = _line_point_list[j].length - 1;
					stroke(0, 0, 1, 0.4);
					//strokeWeight(2);
					beginShape();
					//translate(_w / 2, _h / 2, 0);
					for (i = length_last - 1; i >= 0; i-- ) {
						_line_point_list[j][i].x += _line_point_list[j][i].vx;
						_line_point_list[j][i].y += _line_point_list[j][i].vy;
						_line_point_list[j][i].z += _line_point_list[j][i].vz;
						curveVertex3d( _line_point_list[j][i].x, _line_point_list[j][i].y, _line_point_list[j][i].z );
					}
				}
			}
			popMatrix();
		}
		
		private function getSphere( radius:Number ):Array{
			// POINTS, LINES, TRIANGLES, TRIANGLE_FAN, TRIANGLE_STRIP, QUADS, QUAD_STRIP 
			var dh:Number = TWO_PI/_sphere_segments;
			var dv:Number = PI/_sphere_segments;
			var i:int, j:int, h:Number, h2:Number, r:Number, r2:Number, dr:Number;
			var xx:Number, yy:Number, zz:Number;
			
			var points_list:Array = new Array();
			for ( j = 1; j < _sphere_segments-1; j++ ){
				dr = dv * j;
				h  = -radius * Math.cos(dr);
				r  =  radius * Math.sin(dr);
				h2 = -radius * Math.cos(dr + dv );
				r2 =  radius * Math.sin(dr + dv );
				
				points_list[j - 1] = new Array();
				for ( i = 0; i <= _sphere_segments; i++ ){
					var c:Number = Math.cos( -dh * i );
					var s:Number = Math.sin( -dh * i );
					var rc:Number = r * c;
					var rs:Number = r * s;
					points_list[j - 1][i*2] = [rc ,  h,  rs];
					var r2c:Number = r2 * c;
					var r2s:Number = r2 * s;
					points_list[j - 1][i*2+1] = [r2c, h2, r2s];
				}
			}
			
			return points_list;
		}
		
		private function moveSphere():void {
			pushMatrix();
			translate(_w / 2, _h / 2, 0);
			
			var count:uint = 0;
			colorMode( HSV, 1, 1, 1 );
			strokeWeight(1);
			for (var j:uint = 1; j <= _sphere_segments * 2; j++ ) {
				if (j % 2 == 0) {
					beginShape();
					for ( var i:uint = 0; i < _sphere_point_list.length; i++ ) {
						stroke(0, 0, 1, 0.2);
						if(i%2==1){
							curveVertex3d( _sphere_point_list[i][j][0], _sphere_point_list[i][j][1], _sphere_point_list[i][j][2] );
							
						}else {
							curveVertex3d( _sphere_point_list[i][j - 1][0], 
										   _sphere_point_list[i][j - 1][1], 
										   _sphere_point_list[i][j - 1][2]);
						}
						
						if (count >= _count) {
							_count++;
							break;
						}else if(count >= _sphere_segments * 2*10) {
							_start_flg = true;
						}
						count++;
					}
				}
			}
			popMatrix();
		}
		
		public function mousePressed():void {
			if (_mouse_flg) {
				loop();
				_mouse_flg = false;
			}else {
				noLoop();
				_mouse_flg = true;
			}
		}
		
	}
}

class ekPoint {
	public var x:Number = 0;
	public var y:Number = 0;
	public var z:Number = 0;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var vz:Number = 0;
	
	public function ekPoint( p_x:Number, p_y:Number, p_z:Number ) {
		x = p_x;
		y = p_y;
		z = p_z;
	}
	
}