/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/m01o
 */

// forked from s8t1h12akj's flash on 2013-12-5
package 
{
    import flash.display.SimpleButton;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    /**
     * MP3 を鳴らすサンプル
     * @author Hikipuro
     */
    public class Main extends Sprite 
    {
        /**
         * ボタン
         */
        private var button1:SimpleButton;
    
        /**
         * ボタンのラベル
         */
        private var buttonText1:TextField;
        
        /**
         * サウンドのローダ
         */
        private var sound:Sound;
        
        /**
         * サウンド制御用サウンドチャネル
         */
        private var soundChannel:SoundChannel;
        
        /**
         * コンストラクタ
         */
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * 初期化イベント
         * @param    e
         */
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            // ボタンのラベルの作成
            buttonText1 = new TextField();
            buttonText1.autoSize = TextFieldAutoSize.CENTER;
            buttonText1.selectable = false;
            buttonText1.x = 160;
            buttonText1.y = 110;
            buttonText1.text = "再生";
            addChild(buttonText1);
            
            // ボタンの作成
            button1 = new SimpleButton();
            button1.upState = makeRoundRect(0xDDDDDD, 100, 20, 10);
            button1.overState = makeRoundRect(0xFFFFFF, 100, 20, 10);
            button1.downState = makeRoundRect(0xBBBBBB, 100, 20, 10);
            button1.hitTestState = button1.upState;
            button1.addEventListener(MouseEvent.MOUSE_DOWN, onButtonMouseDown);
            button1.x = 110;
            button1.y = 110;
            addChild(button1);
            
            // サウンドの URL を指定
            var urlRequest:URLRequest;
            urlRequest = new URLRequest("http://kouetu.sakura.ne.jp/Flash_Develop81/oo39_ys195.mp3");
            sound = new Sound(urlRequest);
        }

        /**
         * ボタンが押された時のイベント
         * @param    event
         */
        private function onButtonMouseDown(event:MouseEvent):void
        {
            if (buttonText1.text == "再生")
            {
                buttonText1.text = "停止";
                soundChannel = sound.play(0, 0);
            }
            else if (buttonText1.text == "停止")
            {
                buttonText1.text = "再生";
                soundChannel.stop();
            }
        }
        
        /**
         * 角丸の図形を描いたスプライトを作って返す
         * @param    color    色
         * @param    width    幅
         * @param    height    高さ
         * @param    round    角丸の大きさ
         * @return    スプライト
         */
        private function makeRoundRect(color:uint, width:int, height:int, round:int):Sprite
        {
            var s:Sprite = new Sprite();
            s.graphics.lineStyle(2);
            s.graphics.beginFill(color);
            s.graphics.drawRoundRect(0, 0, width, height, round);
            s.graphics.endFill();
            s.alpha = 0.3;
            return s;
        }
        
    }
    
}        