/**
 * Copyright hacker_tpeqa74y ( http://wonderfl.net/user/hacker_tpeqa74y )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lydY
 */

// forked from mash's できないよ ロードした画像のサンドボックス侵害回避
// forked from umhr's ロードした画像のサンドボックス侵害回避
/*
 * ロードした画像のサンドボックス侵害回避
 * 
 * 通常、外部ドメインの画像はdrowとかで加工できない。
 * ただし、バイナリーとして読み込み、
 * 改めて内部でロードしなおせば、この制限を回避できる。
 * 
 * この方法で、画像だけでなく音やswfの複製も可能になるらしい。
 * 
 * ここでは、Flickrから一度だけ読み込んだ画像をdrowして
 * 繰り返しのパターンを作った。
 * 
 * 参考
 * http://void.heteml.jp/blog/archives/2007/05/as3_duplicate.html
 * */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.Loader;
	import flash.geom.Matrix;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.net.URLLoaderDataFormat;
	import flash.filters.DropShadowFilter;
	import flash.utils.ByteArray; 
	/**
	 * ...
	 * @author umhr
	 */
	public class Main extends Sprite 
	{
		public function Main():void 
		{
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.dataFormat = URLLoaderDataFormat.BINARY;
			var url:URLRequest = new URLRequest("http://wonderfl.net/img/common/kayacproject.png");
			myURLLoader.load(url);
			myURLLoader.addEventListener (Event.COMPLETE,COMPLETE);
		}
 		private function COMPLETE(e:Event):void 
		{
			var myByteArray:ByteArray = e.currentTarget.data;
			
			var myLoader1:Loader = new Loader();
			myLoader1.loadBytes(myByteArray);
			myLoader1.filters = [new DropShadowFilter()];
			addChild(myLoader1);
			
			var myLoader2:Loader = new Loader();
			myLoader2.loadBytes(myByteArray);
			myLoader2.x = 220;
			myLoader2.filters = [new DropShadowFilter()];
			addChild(myLoader2);
			myLoader2.contentLoaderInfo.addEventListener(Event.COMPLETE, COMPLETE2);
			
		}
		private function COMPLETE2(e:Event):void {
			var bitmap:Bitmap = e.target.content;
			var myBitmapData:BitmapData = new BitmapData(bitmap.width / 3, bitmap.height / 2);
			myBitmapData.draw(bitmap);
			
			var sp:Sprite = new Sprite();
			sp.graphics.beginBitmapFill (myBitmapData);
			sp.graphics.drawRoundRect( 10, 220 , 445, 235, 50, 50);
			sp.filters = [new DropShadowFilter()];
			addChild(sp);
		}
	}
}
