/**
 * Copyright c80609a ( http://wonderfl.net/user/c80609a )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lyYc
 */

//////////////////////////////////////
//
//
// draggable shape with control panel, yo
// forked from c80609a's nostalgi
//
//
//////////////////////////////////////
package {
    
    import flash.events.MouseEvent;
    import com.bit101.components.*;
    
    import flash.display.DisplayObjectContainer;
    import flash.display.MovieClip;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.geom.Rectangle;
    
    import flash.events.Event;
    import flash.events.ProgressEvent;
    
    public class FlashTest extends Sprite {

        private var mShapes:MovieClip;        
        private var wnd:Window;
        private var btnPlay:PushButton;        
        
        private var _p_srot:Number;    // speed coef shape rotation
        private var p_rot:Number;    // mShapes rotaton
        private var p_roty:Number;    // mShapes y-rotaton
        
        private function _animShapes():void {            
            
            var arr:Array = [];
            var s:Shape;
            
            for (var i:uint = 0; i < 30; i++) {
                s = new Shape;
                s.graphics.beginFill(i * 03000,1);
                s.graphics.drawRoundRect(10 + i, 10 + i, i + 10, i * 10, 30);
                s.graphics.endFill();
                mShapes.addChild(s);
                arr.push(s);
            }
            
            mShapes.addEventListener(Event.ENTER_FRAME, function():void {
                if (!mShapes.enabled) return;
                var i:uint;
                for each (s in arr) {
                    s.rotation += p_srot * i++;                    
                }
                
                mShapes.rotation += p_rot;
                mShapes.rotationY += p_roty;
                
            });
            
            mShapes.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void { 
                if (mShapes.enabled) btnPlay.dispatchEvent(new MouseEvent(MouseEvent.CLICK));
                mShapes.startDrag();
                wnd.visible = false;
            } );
            
            mShapes.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void { 
                mShapes.stopDrag();
                wnd.visible = true;
            } );            
            
            mShapes.x = stage.stageWidth / 2 - mShapes.width / 2;
            //mShapes.y = stage.stageHeight / 2 - mShapes.height / 2;
        }

        private function _init(e:Event = null):void {            
            removeEventListener(Event.ADDED_TO_STAGE, _init);
            
            p_srot = 1;
            p_rot = .6;
            p_roty = .4;
            
            _setupStage();
            _animShapes();
            _setupControls();
        }        
        
        private function _setupControls():void {
            
            wnd = new Window(this, 0, 0, "dndable shpes...");            
            wnd.hasCloseButton = true;
            wnd.hasMinimizeButton = true;
            
            var w:int, h:int;
            w = wnd.width = 150; h = wnd.height = 140;
            wnd.x = stage.stageWidth - w - 10;
            wnd.y = stage.stageHeight - h - 10;
            
            var vb:VBox = new VBox(wnd, 15, 25);
            vb.spacing = 2;
                                
            var chb:CheckBox = new CheckBox(vb, 0, 0, "enable", function():void { 
                mShapes.visible = !mShapes.visible;
            });
            
            btnPlay = new PushButton(vb, 0, 0, "pause", function():void {
                switch(btnPlay.tag) {  // tag is id of current butt mode: pause - 0 \ play - 1
                    case 0:
                        btnPlay.label = "play";
                        mShapes.enabled = false;
                        btnPlay.tag = 1;
                    break;                
                    case 1:
                        btnPlay.label = "pause";
                        mShapes.enabled = true;
                        btnPlay.tag = 0;
                    break;
                }                
            });
            btnPlay.width = 50; btnPlay.tag = 0;
            
            var sld_max:int = 12;
            var sld:HSlider = new HSlider(vb, 0, 0);
            sld.value = p_rot * 100 / sld_max;
            sld.addEventListener("change", function():void {
                p_rot = sld.value / 100 * sld_max;                
            });
            
            var sld_max1:int = 1;
            var sld1:HSlider = new HSlider(vb, 0, 0);
            sld1.value = p_srot * 100 / sld_max1;
            sld1.addEventListener("change", function():void {
                p_srot = sld1.value / 100 * sld_max1;                
            });
            
            var sld_max2:int = 12;
            var sld2:HSlider = new HSlider(vb, 0, 0);
            sld2.value = p_roty * 100 / sld_max2;
            sld2.addEventListener("change", function():void {
                p_roty = sld2.value / 100 * sld_max2;                
            });
            
        }
           
        private function _setupStage():void {
            
            stage.scaleMode = 'noScale';
            stage.align = 'TL'
            
            addChild(mShapes = new MovieClip);
            mShapes.y = 330;
            
        }
        
        public function FlashTest() {
           
            // write as3 code here..
            if (stage) _init();
            else addEventListener(Event.ADDED_TO_STAGE, _init);
            
        }
        
        public function get p_srot():Number { return _p_srot; }
        
        public function set p_srot(value:Number):void { _p_srot = value; }
        
    }
}