/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lyH5
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]
    
    public class FlashTest extends Sprite {
        private var particle:Particle;
        private var particles:Array;
        
        public function FlashTest() {
            init();            
        }
        
        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            particles = new Array();
            stage.addEventListener(MouseEvent.MOUSE_MOVE, create, false, 0, true);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        
        private function create(evt:MouseEvent):void {
            particle = new Particle();
            particle.x = mouseX;
            particle.y = mouseY;
            addChild(particle);
            particles.push(particle);
        }
        private function update(evt:Event):void {
            for(var n:uint=0; n<particles.length; n++) {
                var particle:Particle = particle[n];
                particle.update();
                if(particle.life < 0) {
                    removeChild(particle);
                    particles.splice(n, 1);
                    particle = null;
                }
            }
        }
    }
}

import flash.display.Sprite;
import flash.filters.GlowFilter;

class Particle extends Sprite {
    private var _width:uint = 12;
    private var _height:uint = 18;
    private var blur:uint = 8;
    private static var color:uint = 0xffffff;
    private static var max:uint = 50;
    public var life:int = max;
    private static var radius:Number = 3;
    private var dx:Number = 0;
    private var gravity:Number = -6;
    private static var acceleration:Number = 0.8;
    
    public function Particle(w:uint=12, h:uint=18, b:uint=8) {
        _width = w;
        _height = h;
        blur = b;
        draw();
        init();
    }
    
    private function init():void {
        dx = Math.random()*radius*2-radius;
    }
    
    public function update():void {
        if(life < 0) return;
        life--;
        x += dx;
        gravity += acceleration;
        y += gravity;
        alpha = (life/max<0.5) ? life*2 / max : 1;
        blink();
    }
    private function blink():void {
        if(life%4 == 0) {
            visible = false;
        } else {
            visible = true;
        }
    }
    private function draw():void {
        graphics.beginFill(color);
        graphics.moveTo(0, -_height/2);
        graphics.curveTo(0, 0, -_width/2, 0);
        graphics.curveTo(0, 0, 0, _height/2);
        graphics.curveTo(0,0, _width/2, 0);
        graphics.curveTo(0,0,0,-_height/2);
        graphics.endFill();
        filters = [new GlowFilter(0xffff00, 1, blur, blur, 2, 3, false, false)];
    }
}
