/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lyFz
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
 
	public class Main extends Sprite
	{
		private var bullets:Array;
		private var frame:int = 0;
 
		public function Main()
		{
			bullets = new Array();
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			if (frame++ % 3 == 0)
			{
				var radian:Number = Math.random() * 360 * Math.PI / 180;
				var bullet:Bullet = new Bullet(0x0, 5, 232, 232, Math.cos(radian), Math.sin(radian), Math.random() * 5 + 5);
				addChild(bullet);
				bullets.push(bullet);
			}
 
			for (var i:int = 0; i < bullets.length; i++)
			{
				bullets[i].move();
				if (bullets[i].check())
				{
					removeChild(bullets[i]);
					bullets.splice(i--, 1);
				}
			}
		}
	}
}
 
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
 
class Bullet extends Sprite
{
	public var px:Number;
	public var py:Number;
	public var vx:Number;
	public var vy:Number;
	public var speed:Number;
 
	public function Bullet(color:int, radius:int, x:int, y:int, vx:Number, vy:Number, speed:Number)
	{
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
 
		this.filters = [new DropShadowFilter(2, 0, 0x0)];
 
		this.x = this.px = x;
		this.y = this.py = y;
		this.vx = vx;
		this.vy = vy;
		this.speed = speed;
	}
 
	public function move():void
	{	
		this.px += vx * speed;
		this.py += vy * speed;
 
		this.x = px;
		this.y = py;
	}
 
	public function check():Boolean
	{
		if (x < -50 || stage.stageWidth  + 50 < x ||
			y < -50 || stage.stageHeight + 50 < y)
		{
			return true;
		}
 
		return false;
	}
}
