/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lx5I
 */

package {
  import flash.display.Sprite;

  import funnel.*;
  import funnel.ui.*;

  public class ControlTheServo extends Sprite {
    private var arduino:Arduino;

    // サーボ
    private var servo:Servo;

    // 可変抵抗器に接続したピン
    private var sensorPin:Pin;

    public function ControlTheServo() {
      // サーボに接続したピンのモードをサーボ用にセット
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(9, SERVO);
      arduino = new Arduino(config);

      // サーボオブジェクトを生成
      servo = new Servo(arduino.digitalPin(9));

      // 可変抵抗器のピンにスケーラとイベントリスナをセット
      // スケーラでは0から1までの入力を0から179までにスケーリングする
      sensorPin = arduino.analogPin(0);
      sensorPin.addFilter(new Scaler(0, 1, 0, 179));
      sensorPin.addEventListener(PinEvent.CHANGE, onChange);
    }

    // 可変抵抗器の値が変化した時に以下を実行
    private function onChange(e:PinEvent):void {
      // サーボの角度を可変抵抗器の値にセット
      // 既にScalerフィルタによって0から179までの値になっているため
      // そのまま代入するだけでOK
      servo.angle = sensorPin.value;
    }
  }
}