/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lwiB
 */

package {
    import flash.text.AntiAliasType;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            const BASE_SPAN:Number = 4;
            var speed:Number = 1.0;
            
            var str:String = "文字を徐々に表示してみるテスト。";
            str += "一定時間<wait=20>待たせて<wait=20>みたり<wait=20>";
            str += "<speed=3.0>一時的に速度を変えてみたり<speed=1>。";
            str += "今のところこのふたつしかできないけれど、";
            str += "クリック待ちとか<wait=10>色変更とか<wait=10>できるようになると、";
            str += "サウンドノベルのようなものに応用できるかも。";
            str += "とりあえず即席で実装してみたけど、あとでもうちょっとコードをまとめたい。";
            str += "タグ解析の部分とか特に。";
            str += "おおむね似たようなことをしているので、だいぶまとめられそうな気はする。";
            var current:uint = 0;
            
            var textField:TextField = new TextField();
            var scale:Number = 2.0;
            textField.scaleX = scale;
            textField.scaleY = scale;
            textField.width = 456 / scale;
            textField.height = 456 / scale;
            textField.text = "";
            textField.antiAliasType = AntiAliasType.ADVANCED;
            textField.mouseEnabled = false;
            textField.wordWrap = true;
            textField.x = 4;
            textField.y = 4;
            this.addChild(textField);
            
            var frame:uint = 0;
            var nextFrame:uint = BASE_SPAN;
            var proc:Function = function (e:Event):void {
                if (current > str.length) return;

                ++frame;
                if (frame >= nextFrame) {
                    frame = 0;
                    
                    if (str.substring(current, current+6) == "<wait=") {
                        current += 6;
                        var index:uint = str.substring(current).search(">");
                        var waitFrame:uint = parseInt(str.substring(current, current + index));
                        current += index + 1;
                        nextFrame = waitFrame;
                    }
                    else if (str.substring(current, current + 7) == "<speed=") {
                        current += 7;
                        var index2:uint = str.substring(current).search(">");
                        speed = parseFloat(str.substring(current, current + index2));
                        current += index2 + 1;
                        nextFrame = 0;
                    }
                    else {
                        if (str.substring(current, current + 1) == "、") {
                            nextFrame = uint(4.0 * BASE_SPAN / speed);
                        }
                        else if (str.substring(current, current + 1) == "。") {
                            nextFrame = uint(8.0 * BASE_SPAN / speed);
                        }
                        else {
                            nextFrame = uint(BASE_SPAN / speed);
                        }
                        if (current < str.length) {
                            textField.appendText(str.substring(current, current + 1));
                        }
                        ++current;
                    }

                }

            };
            this.addEventListener(Event.ENTER_FRAME, proc);
            
        }
    }
}