/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lvoa
 */

package {
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    public class FlashTest extends Sprite {
        private var loader:Loader = new Loader();
        private var tf:TextField = new TextField();
        public function FlashTest() {
            // write as3 code here..
            addChild(tf);
            addChild(loader);
            tf.text = "test";
            tf.wordWrap=true;
            tf.width=400;
            tf.height=400;
            
            // ローダーインフォを取得
            var info:LoaderInfo = loader.contentLoaderInfo;

            info.addEventListener (Event.OPEN,LoaderInfoOpenFunc);
            function LoaderInfoOpenFunc (event : Event):void {
                tf.appendText("\n読み込みを開始した");
            }

            info.addEventListener (ProgressEvent.PROGRESS,LoaderInfoProgressFunc);
            function LoaderInfoProgressFunc (event : ProgressEvent):void {
                tf.appendText("\n読込:" + event.bytesLoaded);
                tf.appendText("全体:" + event.bytesTotal);
                tf.appendText("パーセント:" + Math.floor(event.bytesLoaded/event.bytesTotal*100));
            }

            info.addEventListener (Event.INIT,LoaderInfoInitFunc);
            function LoaderInfoInitFunc (event : Event):void {
                tf.appendText("\n読み込んだコンテンツの初期化が行われた");
            }

            info.addEventListener(Event.COMPLETE,LoaderInfoCompleteFunc);
            function LoaderInfoCompleteFunc (event:Event):void{
                tf.appendText("\n読み込み完了");
                removeChild(tf);
            }

            info.addEventListener(IOErrorEvent.IO_ERROR,LoaderInfoIOErrorFunc);
            function LoaderInfoIOErrorFunc (event:IOErrorEvent):void {
                tf.appendText("\nファイル入出力のエラー");
                tf.appendText("\n"+event.toString());
            }
            var str:String;
            var url:URLRequest;
            
            //str = "http://swf.wonderfl.net/swf/usercode/7/77/77d7/77d7267eca7b4537692ff121ba80cc1ad812b9e2.swf";
            //str = "http://swf.wonderfl.net/swf/usercode/6/61/61b8/61b8b59a22f9bc2c908368008934274e3a542f3b.swf";
            str = "http://swf.wonderfl.net/swf/usercode/0/0c/0cec/0cec573a23ac4d016fd72b9c52845f1fa649d4f4.swf";
            url = new URLRequest(str);
            
            
            
            loader.addEventListener(Event.COMPLETE,onComplete);

            loader.load(url);
            tf.text = "load";
            tf.text = "SandboxType : " + Security.sandboxType;
            tf.appendText(loader.width.toString()+"/"+loader.height.toString());
        }
        
        private function onComplete(e:Event):void{
            tf.text = "complete";
            stage.addChild(loader);            
            loader.width =400;
            loader.height = 400;
        }

    }
}