/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/luns
 */

// forked from narutohyper's Alternativa3D 7.5 Template
package
{
    import alternativ7.engine3d.loaders.MaterialLoader;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.materials.TextureMaterial;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.geom.Matrix;

    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.primitives.Plane;
    import alternativ7.engine3d.primitives.Sphere;
    import alternativ7.engine3d.primitives.GeoSphere;
    import alternativ7.engine3d.primitives.Box;
    
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Sorting;
    import flash.display.Sprite;
    import flash.display.GradientType;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.system.LoaderContext;

    /**
     * Alternativa3D 7.6
     *
     * Material
     *
     * 7.5で用意されているMaterialは
     * FillMaterial
     * TextureMaterialの2種類
     *
     * 残念ながら、シェーディング系（フラット、グロー、フォン等）は実装されていません。
     * このあたりは、現状ではTextureMaterialを継承して力技で作成するしかありません。
     * （そのうち、アップします）
     *
     * 当然、環境マップとかもありませんｗ
     *
     * ...
     * @author narutohyper
     */
    [SWF(backgroundColor="#000000", frameRate="100", width="800", height="600")]
    public class Main extends Sprite
    {
        public function Main():void    {
        
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        
        
        
        private function init(e:Event=null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
        
            //AlternativaTemplate作成
            var scene:AlternativaTemplate = new AlternativaTemplate(this);

            
            //まとめてcontrolするために、core.Object3DContainerを作成し、各Objectを入れ子にする
            var animeObject:Object3DContainer = new Object3DContainer;
            scene.container.addChild(animeObject);
            
            //塗りのみ
            var fillMaterial:FillMaterial = new FillMaterial(0x666666, 1);
                
            var fillBox:Box = new Box(200,200,200,4,4,4);
            fillBox.setMaterialToAllFaces(fillMaterial);
            animeObject.addChild(fillBox);
            
            
            //反転、ライン表示あり
            var fillLineMaterial:FillMaterial = new FillMaterial(0x666666, 1, 0,0x0);

            var fillLineBox:Box = new Box(200,200,200,4,4,4,true);
            fillLineBox.setMaterialToAllFaces(fillLineMaterial);
            fillLineBox.z = 400;
            animeObject.addChild(fillLineBox);

            
            //ちょっと透明
            var transparentMaterial:FillMaterial = new FillMaterial(0x666666, 0.8);

            var transparentBox:Box = new Box(200,200,200,4,4,4);
            transparentBox.setMaterialToAllFaces(transparentMaterial);
            transparentBox.y = -400;
            animeObject.addChild(transparentBox);
            
            
            //各面での色分け
            //Surfaceが廃止されたので、各面ごとにMaterialを分けるのはちょっと大変。
            //(setMaterialToFaceも無い)
            //BoxやPlaneの場合は、生成時にのみ、各面のMaterialを指定できる。
            var cm:Array = [];
            
            cm[0] = new FillMaterial(0x6666FF, 1);
            cm[1] = new FillMaterial(0x66FF66, 1);
            cm[2] = new FillMaterial(0xFF6666, 1);
            cm[3] = new FillMaterial(0xFFFF66, 1);
            cm[4] = new FillMaterial(0x66FFFF, 1);
            cm[5] = new FillMaterial(0xFF66FF, 1);
            
            var colorBox:Box = new Box(200, 200, 200, 1, 1, 1,false,false,cm[0],cm[1],cm[2],cm[3],cm[4],cm[5]);
            colorBox.y = 400;
            animeObject.addChild(colorBox);
            
            
            //TextureMaterial
            //BitmapDataによる、TextureMaterial
            var canvas:Shape = new Shape();
            
            var colors:Array = new Array(0xCCCCFF, 0xFFCCCC);
            var alphas:Array = new Array(1, 1);
            var ratios:Array = new Array(0, 255);
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(100, 100, 45 * Math.PI / 180, 0, 0);
            canvas.graphics.beginGradientFill(GradientType.LINEAR,colors, alphas, ratios, matrix);
            canvas.graphics.drawRect(0, 0, 100, 100);
            var bmd:BitmapData = new BitmapData(100, 100, true, 0);
            bmd.draw(canvas);
            
            var gradationMaterial:TextureMaterial = new TextureMaterial(bmd, false, true);
            var gradationBox:Box = new Box(200,200,200,1,1,1);
            gradationBox.setMaterialToAllFaces(gradationMaterial);
            gradationBox.z = -400;
            animeObject.addChild(gradationBox);
            
            
            
            //外部読み込み画像によるmaterial

            var giraffeMaterial:TextureMaterial = new TextureMaterial(null, false, true);
            giraffeMaterial.diffuseMapURL = 'http://assets.wonderfl.net/images/related_images/0/00/0018/0018827b79e081b58ce3a5ad3378aa86185f91bbm';
            var tigerMaterial:TextureMaterial = new TextureMaterial(null, false, true);
            tigerMaterial.diffuseMapURL = 'http://assets.wonderfl.net/images/related_images/2/23/239d/239d90e633f3ab0f3e95d18c0fab3200d4a2820cm';
            
            
            var textures:Vector.<TextureMaterial> = new Vector.<TextureMaterial>(2);
            textures[0] = giraffeMaterial;
            textures[1] = tigerMaterial;
            var context:LoaderContext = new LoaderContext(true);
            var materialLoader:MaterialLoader = new MaterialLoader();
            materialLoader.load(textures,context);
            
            var giraffeBox:Box = new Box(200,200,200,4,4,4);
            giraffeBox.setMaterialToAllFaces(giraffeMaterial);
            giraffeBox.x = 400;
            animeObject.addChild(giraffeBox);
            
            var tigerBox:Box = new Box(200,200,200,4,4,4);
            tigerBox.setMaterialToAllFaces(tigerMaterial);
            tigerBox.x = -400;
            animeObject.addChild(tigerBox);
    
            
            //カメラの調整
            //カメラはControllerに関連付けている為、x,y,zで直接位置を指定できないので
            //SimpleController.setObjectPosXYZを使用
            scene.cameraController.setObjectPosXYZ(0,-1000,500);
            scene.cameraController.lookAtXYZ(0, 0, 0);
            //ObjectControllerの作成
            //MouseDragで、Objectを回転させる為のController
            var objectController:SimpleObjectController = new SimpleObjectController(stage,animeObject,100);
            objectController.unbindAll();
            
            scene.onPreRender = function():void {
                objectController.update();
            }
            
            //描画開始
            scene.startRendering();
            
            

        }
        


    }
    
}


/**
 * BasicTemplate for Alternativa3D 7.5
 * Alternativa3D 7.5を扱いやすくするためのテンプレートです
 * @author narutohyper & clockmaker
 *
 */
import alternativ7.engine3d.containers.BSPContainer;
import alternativ7.engine3d.containers.ConflictContainer;
import alternativ7.engine3d.containers.DistanceSortContainer;
import alternativ7.engine3d.containers.KDContainer;
import alternativ7.engine3d.containers.LODContainer;
import alternativ7.engine3d.controllers.SimpleObjectController;
import alternativ7.engine3d.core.Camera3D;
import alternativ7.engine3d.core.Object3DContainer;
import alternativ7.engine3d.core.View;
import flash.display.DisplayObject;

import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;

import flash.events.Event;

class AlternativaTemplate extends Sprite
{
    /**
     * 子オブジェクトを最適な方法でソートするコンテナ
     * (ConflictContainer)
     */
    public static const CONFLICT:String = 'conflict';
    /**
     * 子オブジェクトをBSP(バイナリ空間分割法)によってソートするコンテナ
     * (BSPContainer)
     */
    public static const BSP:String = 'bsp';
    
    /**
     * 子オブジェクトをカメラからのZ値でソートするコンテナ
     * (DistanceSortContainer)
     */
    public static const ZSORT:String = 'zsort';
    /**
     * KDツリー(http://ja.wikipedia.org/wiki/Kd%E6%9C%A8)によってソートするコンテナ
     * (KDContainer)
     */
    public static const KD:String = 'kd';
    /**
     * detalizationと子オブジェクトの距離でソートするコンテナ（詳細は調査中）
     * (LODContainer)
     */
    public static const LOD:String = 'lod';
    
    /**
     * 3dオブジェクト格納するコンテナインスタンス。
     */
    public var container:Object3DContainer;

    /**
     * ビューインスタンスです。
     */
    public var view:View;
    
    /**
     * カメラインスタンスです。
     */
    public var camera:Camera3D;
    
    /**
     * カメラコントローラーです。
     */
    public var cameraController:SimpleObjectController;
    
    private var _mc:DisplayObjectContainer;
    private var _viewWidth:int;
    private var _viewHeight:int;
    private var _scaleToStage:Boolean;
    private var _containerType:String;
    
    /**
     * 新しい Alternativa3DTemplate インスタンスを作成します。
     * @param    mc
     * @param    containerType
     * @param    viewWidth
     * @param    viewHeight
     * @param    scaleToStage
     */
    public function AlternativaTemplate(mc:DisplayObjectContainer,containerType:String=CONFLICT,viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true)
    {
        
        _mc = mc;
        _mc.addChild(this);

        _containerType = containerType;
        _viewWidth = viewWidth;
        _viewHeight = viewHeight;
        _scaleToStage = scaleToStage;
        
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }


    /**
     * 初期化されたときに実行されるイベントです。
     * 初期化時に実行したい処理をオーバーライドして記述します。
     */
    protected function atInit():void {}


    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理をオーバーライドして記述します。
     */
    protected function atPreRender():void {}
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理をオーバーライドして記述します。
     */
    private var _onPreRender:Function = function():void{};
    public function get onPreRender():Function { return _onPreRender; }
    public function set onPreRender(value:Function):void
    {
        _onPreRender = value;
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理をオーバーライドして記述します。
     */
    protected function atPostRender():void {}
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理を記述します。
     */
    private var _onPostRender:Function = function():void{};
    public function get onPostRender():Function { return _onPostRender; }
    public function set onPostRender(value:Function):void
    {
        _onPostRender = value;
    }
    
    
    /**
     * レンダリングを開始します。
     */
    public function startRendering():void
    {
        addEventListener(Event.ENTER_FRAME, onRenderTick);
    }

    /**
    * レンダリングを停止します。
    */
    public function stopRendering():void
    {
        removeEventListener(Event.ENTER_FRAME, onRenderTick);
    }

    /**
     * シングルレンダリング(レンダリングを一回だけ)を実行します。
     */
    public function singleRender():void
    {
        onRenderTick();
    }

    /**
     * @private
     */
    private function init(e:Event = null):void
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        // entry point
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        stage.quality = StageQuality.HIGH;
        
        //Root objectの作成
        if (_containerType == CONFLICT) {
            container = new ConflictContainer();
        } else if (_containerType == BSP) {
            container = new BSPContainer();
        } else if (_containerType == ZSORT) {
            container = new DistanceSortContainer();
        } else if (_containerType == KD) {
            container = new KDContainer();
        } else if (_containerType == LOD) {
            container = new LODContainer();
        }
        //Viewの作成
        view = new View(stage.stageWidth, stage.stageHeight);
        _mc.addChild(view);

        //cameraの作成
        camera = new Camera3D();
        camera.view = view;
        camera.x = 0;
        camera.y = -500;
        camera.z = 0;
        container.addChild(camera);
        
        // Camera controller
        cameraController = new SimpleObjectController(stage, camera, 10);
        cameraController.mouseSensitivity = 0;
        cameraController.unbindAll();
        cameraController.lookAtXYZ(0, 0, 0);
        
        onResize();
        stage.addEventListener(Event.RESIZE, onResize);
        
        atInit();
    }
    
    /**
     * @private
     */    
    private function onResize(e:Event = null):void 
    {
        if (_scaleToStage)
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        } 
        else
        {
            view.width = _viewWidth;
            view.height = _viewHeight;
        }
    }
    
    /**
     * @private
     */    
    private function onRenderTick(e:Event = null):void 
    {
        atPreRender();
        _onPreRender();
        cameraController.update();
        camera.render();
        atPostRender();
        _onPostRender();
    }
    
    
}


