/**
 * Copyright kaiho ( http://wonderfl.net/user/kaiho )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lucc
 */

/*
 * 十字架パズルもどきVer0.1
 * 
 * 操作方法：
 * パーツ移動				・・・ドラッグ
 * パーツの45度回転（時計回り）・・・クリック
 * パーツ反転（パーツDのみ）	・・・MouseDownをせずにパーツ上からマウスを外へ
 * 
 * 今後の課題点(追加予定機能)
 * 1.画面中央に解答例を表示させる。
 * 	・ボタンによって解答例が切り替えられるようにする。
 * 2.パーツ上でMouseDownを行ったときに、そのパーツを最前へ表示させる。
 * 　・PartD以外のパーツをドラッグしてPartDの上を素通りするとPartDが反転し、ドラックが解除される。
 * 3.パーツをフレームの枠内からはみ出さないようにする。
 * 　・パーツごとにサイズが異なるので要注意。
 * 4.パーツ同士が接触したときにパーツをくっつける。
 * 　･パーツ同士をきれいに連結させること。
 * 	・連結したパーツを切り離すアクションの追加。
 */
package 
{
	import __AS3__.vec.Vector;
	import flash.display.Bitmap;
	import flash.display.BitmapData;

	import flash.display.Sprite;
	import flash.events.Event;
	
	//[SWF(width=500, height=300, backgroundColor=0xffffff, frameRate=200)]
	 
	public class Main extends Sprite 
	{
		private var W:Number = 500;
		private var H:Number = 300;
		
		private var partsList:Vector.<Parts>; //パーツリスト
		private var ansList:Vector.<Answers>; //解答例リスト
		
		private var ans:Answers; 
		
		private var partsFrame:Sprite;  
		private var partsBmp:Bitmap;
		private var partsBmpData:BitmapData;
		private var answerFrame:Sprite; //解答例表示用 
		private var answerBmp:Bitmap;
		private var answerBmpData:BitmapData;
		
		public function Main():void 
		{
			init();
		}
		
		private function init():void 
		{
			createFrame();
			createAnswer();
			createParts();
		}
		
		private function createFrame():void {
			partsBmpData = new BitmapData(W, H, true, 0x00FF00);
			partsBmp = new Bitmap(partsBmpData);
			
			addChild(partsBmp);
			partsFrame = new Sprite();
			partsBmpData.draw(partsFrame);
		}
		
		private function createAnswer():void {
			
			ansList = new Vector.<Answers>();
			
			var a:Answers = new ansA(this, W /2, H / 2);
			ans = a;
			stage.addChild(a);
			
			ansList.push(a);
			
			
		}
		
		//パーツ作成
		private function createParts():void
		{
			partsList = new Vector.<Parts>();
			
			var color:uint=0x0000ff;
			var p:Parts;
			for (var i:int = 0; i < 6; i++)
			{
				color *= 0xf;
				
				switch(i) {
					case 0:
						p = new PartA(this, (W / 2) - (Math.sqrt(50 * 50 * 2) / 2), (H / 2) - (Math.sqrt(50*50*2) / 2), 45, color);
						stage.addChild(p);
						partsList.push(p);
						break;
					case 1:
						p = new PartA(this, W / 2, (H / 2) + Math.sqrt(50*50*2), 45, color);
						stage.addChild(p);
						partsList.push(p);
						break;
					case 2:
						p = new PartA(this, (W / 2) + Math.sqrt(50*50*2), (H / 2) + Math.sqrt(50*50*2), -45, color);
						stage.addChild(p);
						partsList.push(p);
						break;
					case 3:
						p = new PartB(this, (W / 2) - (Math.sqrt(50 * 50 * 2) / 2), 
										(H / 2) + (Math.sqrt(50*50*2) / 2), -45, color);
						stage.addChild(p);
						partsList.push(p);
						break;
					case 4:
						p = new PartC(this, (W / 2) + Math.sqrt(50*50*2), H / 2, 135,color);
						stage.addChild(p);
						partsList.push(p);
						break;
					case 5:
						p = new PartD(this, W /2, H / 2, 225, color);
						stage.addChild(p);
						partsList.push(p);
						break;
					default:
						p = new PartA(this, Math.random() * W, Math.random() * H, 0, color);
						stage.addChild(p);
						partsList.push(p);
				}
				
			}
			
		}

		public function enterFrame(event:Event):void {
			var p:Parts;
			
			for (var i:int = 0; i < 5; i++)
			{
				for (var j:int = i + 1; j < 6; j++) {
					if (partsList[i].hitTestObject(partsList[j])) {
						
					}
				}
			}
			
		}

	}
}

import __AS3__.vec.Vector;
import flash.display.Shape;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.GlowFilter;
import flash.geom.Matrix;
import flash.display.Sprite;
import flash.geom.Point;

class Parts extends Sprite
{
	protected var field:Main;
	protected var color:uint;
	
	protected var mouseDouwnX:Number = 0;//クリック判定用(MOUSE_DOWN時のパーツのX座標)
	protected var mouseDouwnY:Number = 0;//クリック判定用(MOUSE_DOWN時のパーツのY座標)

	
	public function Parts(field:Main)
	{
		this.field = field;
		
		addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
		addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
		addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);

	}

	protected function enterFrame(event:Event):void
	{
		
	}
	
	protected function onMouseDown(event:MouseEvent): void
	{
		
		this.startDrag();
		mouseDouwnX = x;
		mouseDouwnY = y;
		
	}

	protected function onMouseUp(event:MouseEvent): void
	{
		this.stopDrag();
		//MouseEvent.ClickだとMouse_UPと同じタイミングでこのfunctionが実行されるためここでfunctuionを実行
		inversion();
	}
	
	protected function onMouseOver(event:MouseEvent):void
	{
	}

	protected function onMouseOut(event:MouseEvent):void
	{
		mouseDouwnX = 0;
		mouseDouwnY = 0;
	}
	
	//図形回転
	public function inversion():void
	{
		if (mouseDouwnX == x && mouseDouwnY == y) {
			this.rotation += 45;
		}
	}
	
	//Part結合
	public function partsJoin():void
	{
	}

	protected function update():void
	{
	}

	protected function draw():void
	{
	}

}

//パーツA
class PartA extends Parts
{
	
	
	public function PartA(field:Main, x:Number, y:Number, z:Number, c:uint)
	{
		super(field);
		this.x = x;
		this.y = y;
		this.rotation = z;
		this.color = c;
		this.field = field;
		
		draw();
		
	}
	
	//パーツ描写
	override protected function draw():void
	{
		graphics.lineStyle(1, 0, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, -50);
		graphics.lineTo(50, -50);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}

}

//パーツB
class PartB extends Parts
{
	public function PartB(field:Main, x:Number, y:Number, z:Number, c:uint)
	{
		super(field);
		this.x = x;
		this.y = y;
		this.rotation = z;
		this.color = c;
		this.field = field;
		
		draw();
	}
	
	//パーツ描写
	override protected function draw():void
	{
		graphics.lineStyle(1, 0, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, 50);
		graphics.lineTo(-50, 0);
		graphics.lineTo(0,-50);
		graphics.lineTo(50, 0);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}

}

//パーツC
class PartC extends Parts
{
	public function PartC(field:Main, x:Number, y:Number, z:Number, c:uint)
	{
		super(field);
		this.x = x;
		this.y = y;
		this.rotation = z;
		this.color = c;
		this.field = field;
		
		draw();
	}
	
	//パーツ描写
	override protected function draw():void
	{
		graphics.lineStyle(1, 0, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, 50);
		graphics.lineTo(50, 100);
		graphics.lineTo(100, 100);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}

}

//パーツD
class PartD extends Parts
{
	public function PartD(field:Main, x:Number, y:Number, z:Number, c:uint)
	{
		super(field);
		this.x = x;
		this.y = y;
		this.rotation = z;
		this.color = c;
		this.field = field;
		
		draw();
	}
	
	//パーツ描写
	override protected function draw():void
	{
		graphics.lineStyle(1, 0, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, -50);
		graphics.lineTo(50, -50);
		graphics.lineTo(50,50);
		graphics.lineTo(0, 0);
		graphics.endFill();
		this.scaleX = -1;
	}
	
	override protected function onMouseOut(event:MouseEvent):void
	{
		this.stopDrag();
		//MouseDown判定
		if ((mouseDouwnX == 0 && mouseDouwnY == 0)) {
			if (this.scaleX == -1) {
				this.scaleX = 1;
			} else {
				this.scaleX = -1;
			}
		}
		mouseDouwnX = 0;
		mouseDouwnY = 0;
	}

}

class Answers extends Shape
{
	protected var field:Main;
	protected var color:uint = 0x000000;//黒固定
		
	public function Answers(field:Main)
	{
		this.field = field;
	}

	protected function enterFrame(event:Event):void
	{
		
	}
	
	protected function onMouseDown(event:MouseEvent): void
	{
		
	}

	protected function draw():void
	{
	}

}

class ansA extends Answers
{
	public function ansA(field:Main, x:Number, y:Number)
	{
		super(field);
		
		this.x = x - 25;
		this.y = y - 50;
		
		draw();
	}
	
	//解答例描写
	override protected function draw():void
	{
		graphics.lineStyle(1, 0, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, -50);
		graphics.lineTo(50, -50);
		graphics.lineTo(50, 0);
		graphics.lineTo(100,0);
		graphics.lineTo(100, 50);
		graphics.lineTo(50, 50);
		graphics.lineTo(50, 150);
		graphics.lineTo(0,150);
		graphics.lineTo(0, 50);
		graphics.lineTo(-50, 50);
		graphics.lineTo(-50, 0);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}