/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/luSJ
 */

// forked from romatica's 四角くて甘いもの
/**
 * *********************************************************************
 * @author itoz(http://www.romatica.com)
 * 実はcubeじゃないよ
 * *********************************************************************
 */
package 
{
    import flash.geom.Matrix;
    import flash.display.GradientType;
    import flash.display.Sprite;

    import org.papervision3d.events.FileLoadEvent;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;

    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="468", height="468")]
    public class CubeSugar extends BasicView 
    {
        //*********************************************************************
        private const _domain:String         = "http://www.romatica.com/dev/wonderfl/ARetty/";
        private var _daeURL:String             = _domain + "CubeSugar.dae";
        private var _paperImageURL:String    = _domain + "PaperShadow.png";
        //*********************************************************************
        private var _cameraZ:Number = -100;
        private var _cameraY:Number = 0;
        private var _modelScale:Number = 1;
        //*********************************************************************
        private var mouseDownX:Number;
        private var mouseDownY:Number;
        private var isDragging:Boolean = false;
        //*********************************************************************
        private var sugarWrap:DisplayObject3D;
        private var subeSugar:DAE;
        private var paperShadowLoader:Loader;
        private var paperShadow:Plane;
        private var bg:Sprite;
        //*********************************************************************
        private var gradType:String = GradientType.LINEAR;
        private var gradArr:Array = [ 0x618e94, 0xd4eaef ];
        private var alphaArr:Array = [ 1, 1 ];
        private var ratioArr:Array = [ 0, 230 ];
        private var mrx:Matrix = new Matrix( );

        //*********************************************************************
        public function CubeSugar() 
        {
            //BG
            mrx.createGradientBox( 468 , 468 , Math.PI / 2 , 0 , 0 );
            bg = addChild( new Sprite( ) ) as Sprite;
            bg.graphics.beginGradientFill( gradType , gradArr , alphaArr , ratioArr , mrx );
            bg.graphics.drawRect( 0 , 0 , 468 , 468 );
            bg.graphics.endFill( );
            setChildIndex( bg , 0 );
            //camera
            camera.z = -_cameraZ;
            camera.y = _cameraY;
            //mouseEvent
            stage.addEventListener( MouseEvent.MOUSE_DOWN , onMouseDownHandler );
            stage.addEventListener( MouseEvent.MOUSE_MOVE , onMouseMoveHandler );
            stage.addEventListener( MouseEvent.MOUSE_UP , onMouseUpHandler );
            //
            paperShadowLoadStart( );
        }

        //IMAGE LOAD START
        private function paperShadowLoadStart():void 
        {
            paperShadowLoader = new Loader( );
            paperShadowLoader.contentLoaderInfo.addEventListener( Event.COMPLETE , onPaperShadowLoaded );
            paperShadowLoader.load( new URLRequest( _paperImageURL ) , new LoaderContext( true ) );
        }

        //IMAGE LOAD COMPLETE
        private function onPaperShadowLoaded(event:Event):void 
        {
            cubeSugarDAELoadStart( );
        }

        //DAE LAOD START
        private function cubeSugarDAELoadStart():void
        {
            subeSugar = new DAE( ) ;
            subeSugar.addEventListener( FileLoadEvent.LOAD_COMPLETE , onCubeSugarLoadComplete );
            subeSugar.load( _daeURL );
        }

        //DAE LOAD COMPLETE
        private function onCubeSugarLoadComplete(event:FileLoadEvent):void 
        {
            setDO3D( );
        }

        /**
         * SET DO3D
         */
        private function setDO3D():void 
        {
            sugarWrap = scene.addChild( new DisplayObject3D( ) ) as DisplayObject3D;
            sugarWrap.scale = _modelScale;
            //
            var paperMat:BitmapMaterial = new BitmapMaterial( Bitmap( paperShadowLoader.content ).bitmapData ); 
            paperMat.oneSide = false;
            paperShadow = sugarWrap.addChild( new Plane( paperMat , 80 , 80 , 16 , 16 ) ) as Plane;
            paperShadow.rotationX = 90;
            //
            subeSugar.scale = 0.2;
            subeSugar.rotationY = 90;
            sugarWrap.addChild( subeSugar );
            //--------------------------------------
            startRender( );
        }

        private function startRender():void
        {
            super.startRendering( );
        }

        /**
         * RENDERING
         */
        override protected function onRenderTick(event:Event = null):void 
        {
            super.onRenderTick( );
            if (!isDragging) {
                sugarWrap.rotationY -= 1;//回転の速さ
            }
            camera.y = (mouseY / stage.stageHeight) * 100;
        }

        /**
         *MOUSE EVENT
         */
        private function onMouseMoveHandler(e:MouseEvent):void 
        {
            var xx:Number = (mouseX - mouseDownX) / 3;
            if (isDragging) {
                sugarWrap.rotationY -= xx;
                mouseDownX = mouseX;
                mouseDownY = mouseY;
            }
        }

        private function onMouseDownHandler(e:MouseEvent):void 
        {
            isDragging = true;
            mouseDownX = mouseX;
            mouseDownY = mouseY;
        }

        private function onMouseUpHandler(e:MouseEvent):void 
        {
            isDragging = false;
        }
    }
}

