/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/luEq
 */

// forked from checkmate's massmedian challenge
package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.net.*;
    import flash.system.LoaderContext;
	
	public class Begineer extends Sprite{
		
		
		//-------------------------------//
		// Use properties as follows.
		//-------------------------------//
		private var _sliceList:Array;
		
		
		
		
		//-------------------------------//
		// Change functions as follows.
		//-------------------------------//
		public function updateEnterFrame(e:Event):void
		{
			if (!_isInitialized) _initialize();
			
			_rx += (720 * (mouseX / W - 0.5) - _rx) * 0.25;
			_ry += (360 * (mouseY / H - 0.5) - _ry) * 0.25;
			
			_matrix.identity();
			_matrix.appendRotation(_rx, Vector3D.Y_AXIS);
			_matrix.appendRotation(_ry, Vector3D.X_AXIS);
			_matrix.appendTranslation(W * 0.5, H * 0.5, 0);
			Utils3D.projectVectors(_matrix, _verts3, _verts2, _uvts);
			
			var o:Bitmap;
			var p:uint = 0;
			var n:uint = _sliceList.length;
			for (var i:uint = 0; i < n; ++i) 
			{
				o = _sliceList[i];
				
				o.x = _verts2[p++];
				o.y = _verts2[p++];
			}
		}
		
		private const W:uint = stage.stageWidth;
		private const H:uint = stage.stageHeight;
		
		private const IW:uint = 525;
		private const IH:uint = 70;
		
		private var _matrix:Matrix3D;
		private var _verts3:Vector.<Number>;
		private var _verts2:Vector.<Number>;
		private var _uvts:Vector.<Number>;
		
		private var _rx:Number;
		private var _ry:Number;
		
		/**
		 * Initialize
		 */
		private var _isInitialized:Boolean = false;
		private function _initialize():void
		{
			_isInitialized = true;
			
			_matrix = new Matrix3D();
			_verts3 = new Vector.<Number>();
			_verts2 = new Vector.<Number>();
			_uvts   = new Vector.<Number>();
			
			var o:Bitmap;
			var n:uint = _sliceList.length;
			for (var i:uint = 0; i < n; ++i) 
			{
				o = _sliceList[i];
				o.scaleX = 0.8;
				o.scaleY = 0.8;
				
				_verts3.push(
					(o.x - IW * 0.5) * 0.8,
					(o.y - IH * 0.5) * 0.8,
					(Math.random() - 0.5) * 200
				);
			}
			
			_rx = 0;
			_ry = 0;
		}


		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		//-------------------------------//
		// Do not change following codes.
		//-------------------------------//
		public function Begineer(){
            var ctxt  :LoaderContext = new LoaderContext(true);
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onLoadComplete );
			loader.load( new URLRequest("http://swf.wonderfl.net/static/assets/massmedian.png"), ctxt );
        }
		
		public function onLoadComplete(e:Event):void {
			var loader:Loader = LoaderInfo( e.target ).loader;
			loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, onLoadComplete );
			
			var bitmapdata:BitmapData = new BitmapData( loader.width, loader.height, true, 0xFF0000 );
			bitmapdata.draw( loader );
			
			_sliceList = sliceBanner( bitmapdata, bitmapdata.width );
			
			addEventListener( Event.ENTER_FRAME, updateEnterFrame );
		}
		
		
		private function sliceBanner( banner:BitmapData, length:int = 100 ):Array{
			var sliceList:Array = [];
			var w:int = Math.floor( banner.width/length );
			var h:int = Math.floor( banner.height );
			
			var t:int = Math.ceil( banner.width - w*length );
			var mat:Matrix = new Matrix();
				
			for( var i:int = 0; i<length; i++ ) {
				var bmpd :BitmapData = new BitmapData( w, h, true, 0xFFFF00 );
				mat.tx = -w*i;
				bmpd.draw( banner, mat );
				var part:DisplayObject = addChild( new Bitmap( bmpd ) );
				part.x = w*i;
				sliceList.push( part );
			}
			return sliceList;
		}
		
	}
}