/**
 * Copyright George.Profenza ( http://wonderfl.net/user/George.Profenza )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ltRx
 */

package {
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.BitmapData;
    import flash.text.TextField;
    import flash.ui.Keyboard;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.utils.Dictionary;
    import flash.display.Sprite;
    public class PlayerMoveTest extends Sprite {
        private var keys:Dictionary = new Dictionary();//hash map to keep track of keys for smooth movement(simply using on keyboard event is not very responsive)
        private var players:Vector.<Player> = new Vector.<Player>();//a list of all the players
        private var trails:BitmapData;//a bitmap to draw trails into
        private var fade:ColorTransform = new ColorTransform(1,1,1,.1);//color transform to fade bitmapdata content gradually
        public function PlayerMoveTest() {
            addEventListener(Event.ADDED_TO_STAGE,init);//make sure we have access to the stage
        }
        private function init(e:Event):void{//we're good, time to initalize everyting
            trails = new BitmapData(stage.stageWidth,stage.stageHeight,true,0x00FFFFFF);//setup a transparent image for the trails 
            addChild(new Bitmap(trails));//add its pixels to the stage
            for(var i:int = 0 ; i < 2; i++){//make some players
                var p:Player = addChild(new Player(10+i*10)) as Player;//add to stage as well as inistantiating
                p.x = stage.stageWidth * .5;//move to centre 
                p.y = stage.stageHeight * .5;//of stage
                players.push(p);//add to the list of players to be updated
            }//setup event handlers
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP,onKeyUp);
            stage.addEventListener(Event.ENTER_FRAME,update);
        }
        private function onKeyDown(e:KeyboardEvent):void{
            keys[e.keyCode] = true;//this key is pressed, make that available for the update call
        }
        private function onKeyUp(e:KeyboardEvent):void{
            keys[e.keyCode] = null;//clear the hash map entry for the released key
        }
        private function update(e:Event):void{
            if(keys[Keyboard.LEFT] != undefined)  {players[0].a -= .15;players[1].a += .15;}//change directions for lefy,right keys
            if(keys[Keyboard.RIGHT] != undefined) {players[0].a += .15;players[1].a -= .15;}
            if(keys[Keyboard.UP] != undefined)    {players[0].s += .15;players[1].s -= .15;}//change velocities/speed for up/down keys
            if(keys[Keyboard.DOWN] != undefined)  {players[0].s -= .15;players[0].s += .15;}
            for(var i:int = 0 ; i < players.length; i++) {//for each player
                players[i].move();//update it 
                trails.draw(players[i],players[i].transform.concatenatedMatrix,fade);//and draw it's trail on the background image
            }
        }
    }
    
}
import flash.display.*;
class Player extends Shape{
    public var vx:Number,vy:Number,a:Number,size:Number,r:Number,s:Number;//velocity x,y, angle, size, radius and speed
    public function Player(size:Number){
        init(size);//usually a good idea to have as little as possible in the constructor
    }
    private function init(size:Number):void{
       vx = vy = a = s = 0;//initialize variables
       this.size = size;
       this.r = size * .25;
       //draw the player
       graphics.lineStyle(1,Math.random() * 0xFFFFFF);
       graphics.drawCircle(0,0,r);
       graphics.lineTo(size,0);     
    }
    public function move():void{
        rotation = a * 57.2957795;//Shapes's rotation property (which is in degrees)
        vx = Math.cos(a) * s;//update velocities
        vy = Math.sin(a) * s;//based on angle and speed
        x += vx;//update position
        y += vy;//Shape's x,y, properties
        if(x < 0) x = 0;//keep within bounds
        if(y < 0) y = 0;
        if(x > stage.stageWidth) x = stage.stageWidth-width;
        if(y > stage.stageHeight) y = stage.stageHeight-height;
    }
}