/**
 * Copyright fqkoji ( http://wonderfl.net/user/fqkoji )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lsuv
 */

package {
	
	import flash.display.Sprite;	
	import org.libspark.thread.EnterFrameThreadExecutor;
	import org.libspark.thread.Thread;

	[SWF(width=465, height=465, backgroundColor=0xffffff, frameRate=60)]

	public class UniformizeImageTest extends Sprite {
		
		public function UniformizeImageTest() {
			Thread.initialize(new EnterFrameThreadExecutor());
			new UniformizeImage(this).start();
		}
	}
}


import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.display.InteractiveObject;
import flash.display.Loader;
import flash.display.Shape;
import flash.display.SimpleButton;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.net.FileReference;
import flash.net.FileReferenceList;
import flash.net.URLRequest;
import flash.system.Security;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.utils.ByteArray;
import flash.geom.ColorTransform;
import flash.display.BlendMode;
import flash.display.PixelSnapping;

import org.libspark.thread.Thread;

class UniformizeImage extends Thread {
	
    public static const PROXY:String = "http://5ivestar.org/proxy/";
    public static const CROSSDOMAIN:String = "http://5ivestar.org/proxy/crossdomain.xml";
        
	private var base:Sprite;
	private var loadButton:Button;
	private var dummy:DummyImage;
	private var loader:Loader;
	private var guide:Sprite;
	
	public function UniformizeImage(base:Sprite) {
		this.base = base;
		loadButton = this.base.addChild(new Button('Load Image', 100)) as Button;
		loadButton.x = 180;

		this.guide = this.base.addChild(new Sprite()) as Sprite;
		this.guide.x = this.guide.y = (465 - 256) >> 1;
		Security.loadPolicyFile(CROSSDOMAIN);
	}
	
	protected override function run():void{
		this.dummy = this.base.addChildAt(new DummyImage(), 0) as DummyImage;
		event(this.dummy, Event.COMPLETE, this.dummyLoaded);
		this.dummy.init();
	}
	
	private function dummyLoaded(e:Event):void {
		this.dummy.scaleX = this.dummy.scaleY = 256 * 0.4 / this.dummy.width;
		this._event();
	}
	
	private function _event():void {
		event(this.loadButton, MouseEvent.CLICK, this._loadImage);
	}

	// load image
	private function _loadImage(e:MouseEvent):void {
		var file:FileReference = new FileReference();
		event(file, Event.SELECT, this._loadFileSelected);
		file.browse();
	}
	private function _loadFileSelected(e:Event):void {
		var file:FileReference = FileReference(e.target);
		event(file, Event.COMPLETE, this._fileLoaded);
		file.load();
	}
	private function _fileLoaded(e:Event):void {
		if (this.loader) {
			this.loader.parent.removeChild(this.loader);
			this.loader.unload();
		}
		this.loader = this.guide.addChildAt(new Loader(), 0) as Loader;
		this.loader.loadBytes(FileReference(e.target).data);
		event(this.loader.contentLoaderInfo, Event.COMPLETE, this._imageLoaded);
	}
	private function _imageLoaded(e:Event):void {
		var a:Number = 256 / Math.max(this.loader.width, this.loader.height);
		this.loader.scaleX = this.loader.scaleY = a;
		var tw:int = this.loader.width;
		var th:int = this.loader.height;
		Bitmap(this.loader.content).smoothing = true;
		this._event();

		var text:TextField = new TextField();
		base.addChild(text);
		text.y = 300;


		var bmp_data:BitmapData = new BitmapData(tw, th, true , 0xFFFFFFFF);
		var bmp_obj:Bitmap = new Bitmap(bmp_data , PixelSnapping.AUTO , true);
		//this.guide.addChild(bmp_obj);
		var matrix:Matrix = new Matrix(1,0,0,1,0,0);
		var color:ColorTransform = new ColorTransform(1,1,1,1,0,0,0,0);
		var rect:Rectangle = new Rectangle(0,0,400,300);
		bmp_data.draw(this.guide, matrix, color, BlendMode.NORMAL, rect, true);

		var red:uint = 0;
		var green:uint = 0;
		var blue:uint = 0;

		for(var i:int = 0; i<tw; i++){
			for(var j:int = 0; j<th; j++){
				var pcolor:uint = bmp_data.getPixel(i,j);
				var _red   : uint = (pcolor >> 16) & 0xFF;
				var _green : uint = (pcolor >>  8) & 0xFF;
				var _blue  : uint = (pcolor >>  0) & 0xFF;
				red   += _red;
				green += _green;
				blue  += _blue;
			}
		}
		red   = red   / (tw*th);
		green = green / (tw*th);
		blue  = blue  / (tw*th);

		var ucolor:int;
		ucolor = (red << 16) & 0xff0000;
		ucolor += (green << 8) & 0xff00;
		ucolor += blue & 0xff;

		var uni:Shape = new Shape();
		var g:Graphics = uni.graphics;

		g.beginFill(ucolor);
		g.drawRect(0, 0, 36, 36);
		g.endFill();
		base.addChild(uni);
		uni.x = 215;
		uni.y = 350;
		
		//text.text = ""+red+"\n" + green +"\n" + blue +"\n";
		//text.text = "w = "+this.loader.width+", h = "+this.loader.height;
	}

}


class DummyImage extends Sprite {
	
	private var dummy:Loader;
	
	public function DummyImage() {
	}
	
	public function init():void {
		this.dummy = this.addChild(new Loader()) as Loader;
		this.dummy.visible = false;
		this.dummy.contentLoaderInfo.addEventListener(Event.COMPLETE, this.dummyLoaded);
		this.dummy.load(new URLRequest(UniformizeImage.PROXY + 'http://www.fqdev.com/logo.png'));
	}
	
	private function dummyLoaded(e:Event):void {
		this.dispatchEvent(new Event(Event.COMPLETE));
	}
}





class Button extends SimpleButton {
	
	public function Button(label:String, width:int = 0):void {
		var up:Sprite = _buildImage(label, 0x67A320, width);
		var over:Sprite = _buildImage(label, 0x9BC30F, width);
		var down:Sprite = _buildImage(label, 0x9BC30F, width);
		down.y = 1;
		super(up, over, down, up);
	}
	
	private static function _buildImage(label:String, color:int, width:int = 0):Sprite {
		var text:TextField = new TextField();
		text.defaultTextFormat = new TextFormat('consolas', 12, 0xffffff, true, null, null, null, null, TextFormatAlign.CENTER);
		text.autoSize = TextFieldAutoSize.LEFT
		text.selectable = false;
		text.text = label;
		text.x = (width - text.width) >> 1;
		text.y = 5;
		var base:Shape = new Shape();
		var g:Graphics = base.graphics;
		g.beginFill(color);
		g.drawRect(0, 0, width, text.height + 10);
		g.endFill();
		var sp:Sprite = new Sprite();
		sp.addChild(base);
		sp.addChild(text);
		return sp;
	}
}