/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ls1A
 */

// forked from checkmate's Saqoosha challenge for amateurs
package {
    
    import flash.display.Sprite;
    import flash.display.DisplayObject;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    
    import caurina.transitions.Equations;
    import com.flashdynamix.utils.SWFProfiler;    
    [SWF(width=465, height=465, backgroundColor=0xffffff, frameRate=30)]

    public class GradationTest1 extends Sprite {
        
        private var angle :int = 180;
        private var grad:Gradation;
        private var canvas:BitmapData;
        private var easeOffset:Function;
        private var plate:Sprite;
        
        public function GradationTest1() {
            plate = addChild( new Sprite() ) as Sprite;
            plate.x = 233; plate.y = 233;
            
            canvas = new BitmapData( w, h, false, 0xFFFFFF );
            var container:DisplayObject= plate.addChild( new Bitmap( canvas) );
            container.x = -w/2; container.y = -h/2;
            
            // Gradationクラスを作る。任意の数のカラー値を渡すことができる。
            grad = new Gradation(0xff00cc, 0x00ff33, 0x0033ff, 0xff00cc);
            
            //var easeOffset:Function = Equations.easeOutSine;
            //var easeOffset:Function = Equations.easeInQuart;
            //var easeOffset:Function = Equations.easeOutCubic;
            //var easeOffset:Function = Equations.easeOutExpo;
            //var easeOffset:Function = Equations.easeOutBounce;
           easeOffset = Equations.easeOutElastic;
           
           
            for( var y:int =0; y < h; ++y ) {
                cacheGradiete.push( grad.getColor( y /h ) );
            }
            
           addEventListener( Event.ENTER_FRAME, loop );
           
           
           SWFProfiler.init( this );
        }
        
            
        private var w:int = 320;
        private var h:int  = 233;
        private var cacheGradiete:Vector.<uint> = new Vector.<uint>();
        private function loop( e:Event ):void {
            var ty:int = 0;
            angle = ( angle + 1 ) % 360;
            
            var period:Number = Math.sin( Math.PI* angle /180 ) * 80 + 80;
            
            canvas.lock();
            for ( var x:int = 0; x < w; ++x ) {
                ty = easeOffset( x, 0, h, w, { period:period } );
                for ( var y:int = 0; y < h; y++) {
                    // getColorでグラデーションを構成する中間色を取り出す。渡す値は0〜1。滑らかにこの値を変化させることでグラデーションを作り出す。
                    
                    var c :uint =  cacheGradiete[(y+ty)%h];
                    
                    canvas .setPixel( x, y, c );
                }
            }
            canvas .unlock();
            
            plate.rotationX += 0.2; 
            plate.rotationY += 0.2; 
        }
    }
}


import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    private var _length:int;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _length = _colors.length;
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * ( _length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}