/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lrZn
 */

package {
    import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
    public class FlashTest extends Sprite {
        private var _gridMan:GridManager = new GridManager(465,465,100,70);
        private var _gridView:DisplayObject;
		private const _MASATSU:Number = 0.95;
        public function FlashTest() {
            // write as3 code here..
            _gridView = _gridMan.getView();
            addChild(_gridView);
			
			this.stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			this.stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUP);
        }
		private var lastVector:Point = new Point();
		private var lastPos:Point = new Point();
		private function onMouseUP(e:MouseEvent):void 
		{
			this.stage.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
			this.stage.addEventListener(Event.ENTER_FRAME, onEnterFrame2);
//			_refresh();
		}
		
		private function onEnterFrame2(e:Event):void 
		{
			lastVector.normalize( lastVector.length * _MASATSU );
			if ( lastVector.length < 1 ) {
				this.stage.removeEventListener(Event.ENTER_FRAME, onEnterFrame2);
			} else {
				_gridMan.addPosition(lastVector.x, lastVector.y);
			}
		}
		
		private function onMouseDown(e:MouseEvent):void 
		{
			this.stage.removeEventListener(Event.ENTER_FRAME, onEnterFrame2);
			lastPos.x = stage.mouseX;
			lastPos.y = stage.mouseY;
			this.stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(e:Event):void 
		{
			_refresh();
		}
		
		private function _refresh():void
		{
			lastVector.x = lastPos.x - stage.mouseX;
			lastVector.y = lastPos.y - stage.mouseY;
			_gridMan.addPosition(lastVector.x, lastVector.y);
			lastPos.x = stage.mouseX;
			lastPos.y = stage.mouseY;
		}
    }
}

import flash.events.*;
import flash.display.*;
import flash.geom.*;
import flash.text.FontStyle;
import flash.text.TextField;
import flash.text.TextFormat;
class GridManager extends EventDispatcher
{
    private var _sw:int;
    private var _sh:int;
    private var _gw:int;
    private var _gh:int;
    private var _xNum:int;
    private var _yNum:int;
    private var _gridView:Sprite = new Sprite();
	private var _items:Array = [];
	private var _currentX:Number;
	private var _currentY:Number;
    public function GridManager(stageWidth:int, stageHeight:int, gridWidth:int, gridHeight:int){
        super();
        _sw = stageWidth;
        _sh = stageHeight;
        _gw = gridWidth;
        _gh = gridHeight;
        _init();
    }
    private function _init():void {
        _initItems(_sw, _sh, _gw, _gh);
        setPosition(-0.5*(465-_gw),-0.5*(465-_gh));
    }
    private function _initItems(sw:int, sh:int, gw:int, gh:int):void{
        _xNum = Math.ceil(1 + sw / gw);
        _yNum = Math.ceil(1 + sh / gh);
        for( var x:int = 0; x < _xNum; x++ ){
            for ( var y:int = 0; y < _yNum; y++ ) {
				var item:GridItem = new GridItem(x, y, gw, gh);
				_items.push(item);
                _gridView.addChild( item );
            }
        }
    }
    public function setPosition(newX:Number, newY:Number):void {
		_currentX = newX;
		_currentY = newY;
		var _outX:int = _gw * (_xNum - 1);
		var _outY:int = _gh * (_yNum - 1);
		var index:int = 0;
        for( var x:int = 0; x < _xNum; x++ ){
            for ( var y:int = 0; y < _yNum; y++ ) {
				var item:GridItem = GridItem(_items[index]);
				var posX:int = item.pos.x;
				var posY:int = item.pos.y;
				var reloadFlg:Boolean = false;
				item.x = posX * _gw - _currentX; 
				item.y = posY * _gh - _currentY;
				if ( item.x > _outX ) {
					posX -= Math.ceil((item.x - _outX)/_outX) * _xNum;
					reloadFlg = true;
				} else if ( item.brx < 0 ) {
					posX += Math.ceil(-item.brx/_outX) * _xNum;
					reloadFlg = true;
				}
				if ( item.y > _outY ) {
					posY -= _yNum;
					reloadFlg = true;
				} else if( item.bry < 0 ) {
					posY += _yNum;
					reloadFlg = true;
				}
				
				if ( reloadFlg ) {
					item.x = posX * _gw - _currentX; 
					item.y = posY * _gh - _currentY;
					item.reload(posX, posY);
				}
				index++;
			}
		}
    }
	public function addPosition(dx:Number, dy:Number):void {
		setPosition(_currentX + dx, _currentY + dy);
	}
    public function getView():DisplayObject{
        return _gridView;
    }
}

class GridItem extends Sprite
{
	private var _id:int;
	private var _pos:Point;
	private var _size:Point;
	private var tf:TextField = new TextField;
	private var tf2:TextField = new TextField;
	private var _fontSize:int = 30;
    public function GridItem(x:int, y:int, w:int, h:int){
        _pos = new Point(x, y);
		_size = new Point(w, h);
		addChild(tf2);
		tf2.autoSize = "left";
		tf2.mouseEnabled = tf2.selectable = false;
		addChild(tf);
		tf.autoSize = "left";
		tf.mouseEnabled = tf.selectable = false;
		reload(x, y);
    }
	// 未使用
	public function alert():void {
		draw(0xFF0000);
	}
	public function reload(x:int, y:int):void {
		_pos.x = x;
		_pos.y = y;
		var fontSize:int = _fontSize;
		do {
			tf2.defaultTextFormat = new TextFormat("_typewriter", fontSize--);
			tf2.text = String(Util.getIdxByPos(x, y));
		} while( tf2.textWidth > _size.x * 0.7 && fontSize > 5 )
		tf2.x = 0.5 * (_size.x - tf2.textWidth);
		tf2.y = 0.5 * (_size.y - tf2.textHeight);
		draw();
	}
	private function draw(color:int = 0x00FF00):void {
		this.graphics.clear();
		this.graphics.lineStyle(0, color, 0.5);
		this.graphics.drawRect(0, 0, _size.x, _size.y);
		tf.text = pos.toString();
		tf.textColor = color;
	}
	public function get brx():int { return x + _size.x; }
	public function get bry():int { return y + _size.y; }
	public function get pos():Point { return _pos; }
	
	public function get size():Point { return _size; }
	
	public function get id():int { return _id; }
	
	public function set id(value:int):void 
	{
		_id = value;
	}
}

class Util
{
	public static function getIdxByPos(x:int, y:int):int {
		var n:int = ((x > 0?x: -x) > (y > 0?y: -y))?x:y;
		if ( n < 0 ) n = -n;
		var base:int = 4 * n * ( n + 1 ) + 1;
		if ( y == n ) { return base - n + x; }
		else if ( x == -n ) { return base - n - n - n + y; }
		else if ( y == -n ) { return base - n - n - n - n - n - x; }
		else { return base - n - n - n - n - n - n - n - y; }
	}
}