/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lrKv
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;

    import funnel.*;

    [SWF(backgroundColor="0x808080")]

    public class DetectTheMovement extends Sprite {

        private var gainer:Gainer;

        private var scopeForInputSignal:SignalScope;

        private var scopeForDiff:SignalScope;

        private var scopeForSetPoint:SignalScope;

        private var sensorPin:Pin;

        private var setPoint:SetPoint;

        public function DetectTheMovement() {
            gainer = new Gainer();
            sensorPin = gainer.analogInput(2);
            sensorPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));

            scopeForInputSignal = new SignalScope(10, 10, 200, "Z axis");
            addChild(scopeForInputSignal);

            scopeForDiff = new SignalScope(10, 70, 200, "raw - smoothed", -1, 1);
            addChild(scopeForDiff);

            scopeForSetPoint = new SignalScope(10, 130, 200, "divided by SetPoint", 0, 1);
            addChild(scopeForSetPoint);

            setPoint = new SetPoint([0.3, 0.05]);

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onEnterFrame(e:Event):void {
            scopeForInputSignal.update(sensorPin);

            var diff:Number = sensorPin.preFilterValue - sensorPin.value;
            scopeForDiff.update(diff);

            scopeForSetPoint.update(setPoint.processSample(diff));
        }
    }
}