/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lqTB
 */

package {
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.DisplayShortcuts;
	
	import com.adobe.serialization.json.JSON;
	import com.bit101.components.ColorChooser;
	import com.bit101.components.PushButton;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;
	
        /**
        * 曲は夢幻のオルゴール工房さんにて配布されているmp3ファイルを使用しています
        * http://www.dream-orgel.net/diary.cgi?no=120&continue=on
        */
	[SWF(width="465", height="465", backgroundColor="#000000", frameRate=30)]
	public class LineReader extends Sprite
	{
		private var _field:Sprite = new Sprite();
		private var _paintField:Sprite = new Sprite();
		private var _uiField:Sprite = new Sprite();
		private var _stopUiField:Sprite = new Sprite();
		private var _startField:Sprite = new Sprite();
		
		//Clearエフェクト
		private var _clearEffBmp:Bitmap = new Bitmap();
		private var _clearBmd:BitmapData = new BitmapData(465,465,true,0);
		
		//座標リスト
		private var _pointListList:Array = new Array();
		private var _currentListIndex:int = 0;
		private var _actionFlg:Boolean = true;
		/**
		 * params
		 */
		private var _col:Number = 0xFFFFFF;
		/**
		 * Sound parts
		 */
		private var player:Object = new Object();
		private var loader:Loader = new Loader();
		private var bA:ByteArray;
		private var spectrum:Array;
		public static var lowVal:Number=0;
		public static var middleVal:Number=0;
		public static var highVal:Number = 0;
		private var sound:Sound;
		private var _ch:SoundChannel;
		
		/**
		 * UI
		 */
		private var _colSelector:ColorSelector;
		private var _colChooser:ColorChooser;
		
		/**
		 * RECORD
		 */ 
		private var _rec:DrawRecoder = new DrawRecoder();
		private var _player:DrawPlayer = new DrawPlayer();
		
		/**
		 * TIMER
		 */
		private var _startTime:int;
		
		public function LineReader()
		{
			init();
			setupDisplay();
		}
		
		public function init():void {
			DisplayShortcuts.init();
			Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
			
			_field.graphics.clear();
			_field.graphics.beginFill(0xCCCCCC,0);
			_field.graphics.drawRect(0,0,465,465);
			_field.graphics.endFill();
			
			
			//UI Starting
			var _startButton:PushButton = new PushButton(_startField,20,20,"start", startHandler);
			//UI Playing
			//			var _actionBtn:PushButton = new PushButton(_uiField,20,20,"action",actionHandler);
			//			var _noActionBtn:PushButton = new PushButton(_uiField,20,45,"noAction",noActionHandler);
			var _clearBtn:PushButton = new PushButton(_uiField,20,20,"clear",clearHandler);
			var _plotBtn:PushButton = new PushButton(_uiField,20,45,"plot",plotHandler);
			var _stopBtn:PushButton = new PushButton(_uiField,20,120,"stop",stopHandler);
			//UI Stop
			var _playDataBtn:PushButton = new PushButton(_stopUiField,20,20,"play",playDataHandler);
			var _stopDrawBtn:PushButton = new PushButton(_stopUiField,20,45,"stop",stopDrawHandler);
			
			_colSelector = new ColorSelector();
			//			_colChooser = new ColorChooser(_uiField,20,145);
			
			//Effect Init
			_clearEffBmp.bitmapData = _clearBmd;
			_clearEffBmp.visible = false;
			_clearEffBmp.alpha = 0;
			//座標リスト
			var comListString:String = '[{"id":0,"col":16777010,"fx":138,"time":1490,"fy":110,"type":"draw","childlist":[{"time":1516,"x":138,"y":109},{"time":1660,"x":137,"y":110},{"time":1681,"x":134,"y":113},{"time":1702,"x":132,"y":116},{"time":1723,"x":130,"y":118},{"time":1744,"x":127,"y":123},{"time":1764,"x":124,"y":129},{"time":1785,"x":121,"y":134},{"time":1805,"x":119,"y":139},{"time":1826,"x":119,"y":140},{"time":1847,"x":118,"y":142},{"time":1868,"x":118,"y":143},{"time":1991,"x":117,"y":144},{"time":2073,"x":116,"y":144},{"time":2096,"x":114,"y":144},{"time":2117,"x":107,"y":144},{"time":2138,"x":100,"y":144},{"time":2159,"x":95,"y":144},{"time":2180,"x":88,"y":144},{"time":2200,"x":81,"y":146},{"time":2221,"x":76,"y":147},{"time":2242,"x":73,"y":148},{"time":2263,"x":69,"y":149},{"time":2284,"x":64,"y":151},{"time":2304,"x":62,"y":152},{"time":2429,"x":61,"y":153},{"time":2511,"x":63,"y":156},{"time":2531,"x":67,"y":161},{"time":2552,"x":69,"y":165},{"time":2573,"x":76,"y":170},{"time":2595,"x":80,"y":172},{"time":2616,"x":83,"y":173},{"time":2637,"x":85,"y":174},{"time":2658,"x":86,"y":174},{"time":2679,"x":89,"y":174},{"time":2700,"x":93,"y":175},{"time":2721,"x":99,"y":176},{"time":2741,"x":101,"y":176},{"time":2765,"x":102,"y":176},{"time":2785,"x":102,"y":177},{"time":2804,"x":103,"y":177},{"time":2825,"x":105,"y":177},{"time":2846,"x":108,"y":178},{"time":2866,"x":110,"y":178},{"time":2886,"x":111,"y":179},{"time":2990,"x":111,"y":180},{"time":3011,"x":108,"y":186},{"time":3032,"x":106,"y":190},{"time":3053,"x":104,"y":196},{"time":3074,"x":103,"y":200},{"time":3095,"x":103,"y":201},{"time":3115,"x":103,"y":203},{"time":3136,"x":102,"y":208},{"time":3157,"x":102,"y":211},{"time":3178,"x":102,"y":213},{"time":3199,"x":102,"y":215},{"time":3220,"x":102,"y":216},{"time":3240,"x":102,"y":218},{"time":3262,"x":102,"y":220},{"time":3283,"x":102,"y":222},{"time":3304,"x":102,"y":223},{"time":3325,"x":102,"y":226},{"time":3346,"x":102,"y":227},{"time":3408,"x":102,"y":229},{"time":3429,"x":102,"y":235},{"time":3449,"x":101,"y":237},{"time":3571,"x":103,"y":236},{"time":3592,"x":108,"y":231},{"time":3613,"x":115,"y":221},{"time":3634,"x":119,"y":216},{"time":3655,"x":122,"y":213},{"time":3676,"x":124,"y":210},{"time":3697,"x":128,"y":206},{"time":3718,"x":132,"y":202},{"time":3739,"x":133,"y":201},{"time":3760,"x":134,"y":200},{"time":3782,"x":134,"y":199},{"time":3802,"x":135,"y":198},{"time":3823,"x":137,"y":196},{"time":3843,"x":139,"y":194},{"time":3864,"x":140,"y":193},{"time":3986,"x":143,"y":195},{"time":4007,"x":149,"y":200},{"time":4028,"x":161,"y":211},{"time":4050,"x":166,"y":216},{"time":4071,"x":169,"y":218},{"time":4092,"x":174,"y":221},{"time":4114,"x":178,"y":223},{"time":4135,"x":181,"y":225},{"time":4156,"x":182,"y":226},{"time":4197,"x":183,"y":226},{"time":4218,"x":183,"y":227},{"time":4238,"x":184,"y":228},{"time":4259,"x":185,"y":229},{"time":4280,"x":186,"y":230},{"time":4301,"x":187,"y":231},{"time":4322,"x":188,"y":232},{"time":4446,"x":188,"y":229},{"time":4467,"x":186,"y":221},{"time":4488,"x":184,"y":214},{"time":4509,"x":182,"y":208},{"time":4530,"x":180,"y":202},{"time":4550,"x":178,"y":198},{"time":4571,"x":176,"y":193},{"time":4592,"x":174,"y":189},{"time":4613,"x":173,"y":186},{"time":4633,"x":172,"y":185},{"time":4655,"x":172,"y":184},{"time":4676,"x":171,"y":183},{"time":4697,"x":171,"y":182},{"time":4718,"x":170,"y":181},{"time":4739,"x":170,"y":180},{"time":4760,"x":169,"y":179},{"time":4782,"x":169,"y":178},{"time":4886,"x":168,"y":178},{"time":4991,"x":169,"y":176},{"time":5012,"x":174,"y":168},{"time":5033,"x":180,"y":161},{"time":5054,"x":182,"y":158},{"time":5075,"x":185,"y":154},{"time":5096,"x":187,"y":151},{"time":5117,"x":190,"y":148},{"time":5137,"x":191,"y":147},{"time":5158,"x":192,"y":146},{"time":5179,"x":193,"y":145},{"time":5200,"x":194,"y":144},{"time":5265,"x":195,"y":143},{"time":5286,"x":196,"y":143},{"time":5307,"x":197,"y":142},{"time":5370,"x":198,"y":142},{"time":5391,"x":199,"y":141},{"time":5411,"x":200,"y":140},{"time":5515,"x":196,"y":139},{"time":5535,"x":191,"y":138},{"time":5556,"x":188,"y":137},{"time":5577,"x":186,"y":137},{"time":5599,"x":182,"y":137},{"time":5620,"x":179,"y":137},{"time":5641,"x":176,"y":137},{"time":5664,"x":174,"y":137},{"time":5685,"x":172,"y":137},{"time":5706,"x":170,"y":137},{"time":5729,"x":165,"y":137},{"time":5751,"x":163,"y":137},{"time":5771,"x":162,"y":137},{"time":5791,"x":160,"y":137},{"time":5811,"x":159,"y":137},{"time":5851,"x":158,"y":137},{"time":6017,"x":156,"y":134},{"time":6038,"x":152,"y":127},{"time":6059,"x":148,"y":121},{"time":6080,"x":146,"y":118},{"time":6099,"x":143,"y":113},{"time":6120,"x":141,"y":109},{"time":6141,"x":138,"y":105},{"time":6164,"x":136,"y":104},{"time":6185,"x":135,"y":103},{"time":6205,"x":134,"y":103},{"time":6248,"x":133,"y":102},{"time":6310,"x":132,"y":102},{"time":6331,"x":131,"y":102}]},{"id":0,"col":16777010,"fx":353,"time":7238,"fy":123,"type":"draw","childlist":[{"time":7254,"x":352,"y":122},{"time":7296,"x":351,"y":122},{"time":7317,"x":350,"y":122},{"time":7337,"x":344,"y":122},{"time":7358,"x":339,"y":123},{"time":7379,"x":333,"y":124},{"time":7399,"x":327,"y":125},{"time":7419,"x":323,"y":127},{"time":7439,"x":316,"y":130},{"time":7464,"x":311,"y":133},{"time":7485,"x":307,"y":136},{"time":7506,"x":304,"y":140},{"time":7528,"x":300,"y":145},{"time":7549,"x":297,"y":151},{"time":7569,"x":296,"y":157},{"time":7591,"x":295,"y":162},{"time":7612,"x":295,"y":168},{"time":7632,"x":294,"y":172},{"time":7653,"x":294,"y":175},{"time":7674,"x":294,"y":178},{"time":7695,"x":295,"y":182},{"time":7715,"x":298,"y":188},{"time":7735,"x":299,"y":192},{"time":7755,"x":301,"y":197},{"time":7777,"x":304,"y":202},{"time":7798,"x":307,"y":206},{"time":7819,"x":312,"y":210},{"time":7840,"x":316,"y":213},{"time":7863,"x":321,"y":218},{"time":7883,"x":324,"y":221},{"time":7904,"x":328,"y":224},{"time":7925,"x":335,"y":226},{"time":7945,"x":343,"y":227},{"time":7966,"x":348,"y":228},{"time":7986,"x":353,"y":228},{"time":8007,"x":357,"y":228},{"time":8029,"x":360,"y":227},{"time":8049,"x":365,"y":225},{"time":8070,"x":370,"y":222},{"time":8090,"x":374,"y":219},{"time":8110,"x":376,"y":219},{"time":8130,"x":379,"y":217},{"time":8152,"x":382,"y":213},{"time":8174,"x":386,"y":209},{"time":8197,"x":389,"y":205},{"time":8218,"x":391,"y":202},{"time":8239,"x":392,"y":200},{"time":8265,"x":395,"y":194},{"time":8286,"x":398,"y":188},{"time":8307,"x":399,"y":184},{"time":8332,"x":400,"y":178},{"time":8352,"x":400,"y":176},{"time":8372,"x":401,"y":172},{"time":8393,"x":401,"y":168},{"time":8415,"x":401,"y":162},{"time":8436,"x":401,"y":159},{"time":8457,"x":401,"y":156},{"time":8478,"x":401,"y":155},{"time":8500,"x":400,"y":152},{"time":8521,"x":398,"y":147},{"time":8542,"x":396,"y":142},{"time":8564,"x":395,"y":140},{"time":8585,"x":392,"y":134},{"time":8605,"x":390,"y":131},{"time":8625,"x":387,"y":127},{"time":8648,"x":383,"y":123},{"time":8670,"x":379,"y":120},{"time":8691,"x":376,"y":118},{"time":8712,"x":373,"y":116},{"time":8732,"x":371,"y":114},{"time":8752,"x":370,"y":114},{"time":8772,"x":366,"y":113},{"time":8793,"x":360,"y":113},{"time":8815,"x":353,"y":113},{"time":8835,"x":347,"y":113},{"time":8856,"x":346,"y":113},{"time":8877,"x":343,"y":114},{"time":8898,"x":338,"y":116},{"time":8919,"x":332,"y":119},{"time":8940,"x":328,"y":122},{"time":8966,"x":325,"y":124},{"time":8987,"x":324,"y":125},{"time":9034,"x":322,"y":127},{"time":9055,"x":320,"y":128},{"time":9100,"x":320,"y":129}]},{"id":0,"col":16777010,"fx":348,"time":9926,"fy":251,"type":"draw","childlist":[{"time":9991,"x":347,"y":251},{"time":10011,"x":346,"y":251},{"time":10032,"x":345,"y":251},{"time":10052,"x":343,"y":251},{"time":10073,"x":342,"y":253},{"time":10100,"x":341,"y":254},{"time":10120,"x":340,"y":255},{"time":10140,"x":340,"y":257},{"time":10160,"x":340,"y":259},{"time":10181,"x":340,"y":260},{"time":10200,"x":341,"y":262},{"time":10219,"x":342,"y":265},{"time":10239,"x":344,"y":268},{"time":10260,"x":348,"y":271},{"time":10281,"x":352,"y":274},{"time":10302,"x":355,"y":275},{"time":10322,"x":357,"y":276},{"time":10343,"x":360,"y":276},{"time":10367,"x":363,"y":276},{"time":10388,"x":364,"y":276},{"time":10409,"x":366,"y":276},{"time":10432,"x":367,"y":276},{"time":10453,"x":370,"y":274},{"time":10474,"x":373,"y":270},{"time":10499,"x":374,"y":269},{"time":10520,"x":374,"y":267},{"time":10540,"x":375,"y":265},{"time":10582,"x":375,"y":263},{"time":10603,"x":375,"y":260},{"time":10624,"x":374,"y":258},{"time":10645,"x":374,"y":256},{"time":10667,"x":373,"y":255},{"time":10688,"x":370,"y":253},{"time":10709,"x":367,"y":251},{"time":10732,"x":364,"y":248},{"time":10753,"x":362,"y":247},{"time":10775,"x":361,"y":246},{"time":10799,"x":357,"y":246},{"time":10819,"x":356,"y":246},{"time":10839,"x":354,"y":246},{"time":10859,"x":352,"y":246},{"time":10879,"x":351,"y":246},{"time":10901,"x":349,"y":246},{"time":10921,"x":347,"y":247},{"time":10942,"x":345,"y":248},{"time":10986,"x":343,"y":249}]},{"id":0,"col":16777010,"fx":359,"time":11566,"fy":295,"type":"draw","childlist":[{"time":11584,"x":359,"y":294},{"time":11628,"x":358,"y":294},{"time":11662,"x":357,"y":294},{"time":11681,"x":356,"y":294},{"time":11696,"x":355,"y":294},{"time":11714,"x":354,"y":294},{"time":11731,"x":353,"y":295},{"time":11750,"x":350,"y":298},{"time":11767,"x":350,"y":299},{"time":11788,"x":349,"y":302},{"time":11818,"x":349,"y":304},{"time":11850,"x":348,"y":306},{"time":11883,"x":348,"y":309},{"time":11911,"x":348,"y":311},{"time":11938,"x":352,"y":316},{"time":11962,"x":355,"y":318},{"time":11986,"x":357,"y":319},{"time":12009,"x":359,"y":320},{"time":12032,"x":360,"y":320},{"time":12052,"x":364,"y":320},{"time":12073,"x":365,"y":319},{"time":12094,"x":367,"y":319},{"time":12117,"x":368,"y":318},{"time":12137,"x":369,"y":317},{"time":12157,"x":370,"y":317},{"time":12183,"x":372,"y":313},{"time":12202,"x":372,"y":311},{"time":12220,"x":373,"y":310},{"time":12239,"x":373,"y":309},{"time":12258,"x":373,"y":306},{"time":12280,"x":373,"y":305},{"time":12297,"x":371,"y":302},{"time":12318,"x":368,"y":298},{"time":12352,"x":367,"y":297},{"time":12370,"x":367,"y":296},{"time":12389,"x":366,"y":296},{"time":12408,"x":364,"y":295},{"time":12428,"x":357,"y":295},{"time":12451,"x":352,"y":294},{"time":12472,"x":348,"y":293},{"time":12492,"x":346,"y":291}]},{"id":0,"col":16777010,"fx":243,"time":13186,"fy":237,"type":"draw","childlist":[{"time":13250,"x":242,"y":237},{"time":13270,"x":241,"y":237},{"time":13291,"x":238,"y":237},{"time":13318,"x":232,"y":238},{"time":13337,"x":229,"y":238},{"time":13357,"x":224,"y":239},{"time":13380,"x":222,"y":240},{"time":13400,"x":218,"y":242},{"time":13421,"x":213,"y":244},{"time":13441,"x":209,"y":246},{"time":13460,"x":205,"y":249},{"time":13483,"x":203,"y":250},{"time":13503,"x":200,"y":253},{"time":13523,"x":196,"y":257},{"time":13551,"x":193,"y":260},{"time":13571,"x":192,"y":261},{"time":13591,"x":190,"y":265},{"time":13617,"x":188,"y":270},{"time":13637,"x":186,"y":275},{"time":13657,"x":186,"y":278},{"time":13683,"x":185,"y":285},{"time":13703,"x":185,"y":290},{"time":13722,"x":185,"y":292},{"time":13741,"x":185,"y":296},{"time":13762,"x":185,"y":299},{"time":13783,"x":185,"y":300},{"time":13804,"x":185,"y":302},{"time":13825,"x":186,"y":305},{"time":13850,"x":188,"y":309},{"time":13870,"x":190,"y":313},{"time":13890,"x":193,"y":318},{"time":13917,"x":197,"y":322},{"time":13938,"x":200,"y":326},{"time":13957,"x":204,"y":329},{"time":13984,"x":209,"y":332},{"time":14004,"x":213,"y":335},{"time":14023,"x":220,"y":338},{"time":14049,"x":225,"y":340},{"time":14069,"x":229,"y":342},{"time":14089,"x":232,"y":342},{"time":14115,"x":238,"y":342},{"time":14135,"x":246,"y":342},{"time":14156,"x":252,"y":341},{"time":14183,"x":257,"y":340},{"time":14203,"x":260,"y":338},{"time":14223,"x":265,"y":336},{"time":14242,"x":268,"y":334},{"time":14264,"x":273,"y":332},{"time":14284,"x":276,"y":331},{"time":14304,"x":277,"y":330},{"time":14324,"x":278,"y":330},{"time":14356,"x":282,"y":326},{"time":14375,"x":283,"y":326},{"time":14396,"x":284,"y":325},{"time":14416,"x":285,"y":324},{"time":14436,"x":287,"y":322},{"time":14456,"x":289,"y":319},{"time":14483,"x":290,"y":315},{"time":14502,"x":291,"y":314},{"time":14521,"x":292,"y":311},{"time":14542,"x":293,"y":308},{"time":14564,"x":295,"y":302},{"time":14584,"x":295,"y":296},{"time":14605,"x":296,"y":293},{"time":14625,"x":296,"y":292},{"time":14650,"x":296,"y":289},{"time":14671,"x":296,"y":287},{"time":14691,"x":296,"y":285},{"time":14715,"x":296,"y":283},{"time":14735,"x":296,"y":280},{"time":14756,"x":296,"y":279},{"time":14783,"x":294,"y":276},{"time":14803,"x":292,"y":272},{"time":14822,"x":289,"y":269},{"time":14841,"x":285,"y":265},{"time":14862,"x":282,"y":261},{"time":14883,"x":280,"y":259},{"time":14903,"x":277,"y":256},{"time":14923,"x":273,"y":254},{"time":14950,"x":270,"y":251},{"time":14971,"x":269,"y":249},{"time":14991,"x":268,"y":248},{"time":15017,"x":267,"y":247},{"time":15057,"x":266,"y":246},{"time":15084,"x":262,"y":244},{"time":15103,"x":260,"y":242},{"time":15124,"x":259,"y":241},{"time":15147,"x":258,"y":241},{"time":15167,"x":257,"y":240},{"time":15186,"x":255,"y":240},{"time":15207,"x":252,"y":239},{"time":15228,"x":249,"y":239},{"time":15250,"x":247,"y":239},{"time":15271,"x":244,"y":239},{"time":15292,"x":239,"y":239},{"time":15318,"x":235,"y":239},{"time":15337,"x":232,"y":239},{"time":15358,"x":230,"y":240},{"time":15384,"x":228,"y":240},{"time":15423,"x":228,"y":241}]},{"id":0,"col":16777010,"fx":263,"time":15862,"fy":264,"type":"draw","childlist":[{"time":15889,"x":261,"y":263},{"time":15931,"x":259,"y":263},{"time":15952,"x":258,"y":263},{"time":15973,"x":255,"y":264},{"time":15994,"x":253,"y":267},{"time":16017,"x":252,"y":268},{"time":16037,"x":252,"y":270},{"time":16057,"x":253,"y":273},{"time":16084,"x":257,"y":277},{"time":16104,"x":260,"y":280},{"time":16123,"x":261,"y":281},{"time":16142,"x":262,"y":282},{"time":16165,"x":263,"y":283},{"time":16185,"x":264,"y":284},{"time":16205,"x":264,"y":285},{"time":16225,"x":265,"y":286},{"time":16250,"x":265,"y":288},{"time":16271,"x":265,"y":290},{"time":16292,"x":265,"y":291},{"time":16318,"x":265,"y":292},{"time":16337,"x":265,"y":293},{"time":16384,"x":265,"y":294},{"time":16448,"x":265,"y":295},{"time":16467,"x":267,"y":296},{"time":16487,"x":268,"y":296},{"time":16507,"x":269,"y":296},{"time":16528,"x":270,"y":296},{"time":16551,"x":271,"y":296},{"time":16592,"x":272,"y":296},{"time":16618,"x":273,"y":295},{"time":16639,"x":274,"y":294},{"time":16660,"x":275,"y":294},{"time":16684,"x":275,"y":292},{"time":16703,"x":276,"y":291},{"time":16723,"x":276,"y":290},{"time":16742,"x":276,"y":288},{"time":16770,"x":277,"y":287},{"time":16791,"x":277,"y":286},{"time":16815,"x":277,"y":284},{"time":16835,"x":277,"y":282},{"time":16857,"x":277,"y":280},{"time":16884,"x":276,"y":279},{"time":16905,"x":276,"y":278},{"time":16924,"x":276,"y":277},{"time":16951,"x":274,"y":273},{"time":16970,"x":272,"y":271},{"time":16990,"x":272,"y":270},{"time":17019,"x":271,"y":269},{"time":17057,"x":270,"y":268},{"time":17085,"x":269,"y":267},{"time":17104,"x":268,"y":267},{"time":17124,"x":267,"y":266},{"time":17148,"x":266,"y":265},{"time":17167,"x":265,"y":265},{"time":17188,"x":265,"y":264},{"time":17208,"x":264,"y":264},{"time":17227,"x":262,"y":264},{"time":17251,"x":259,"y":263},{"time":17271,"x":257,"y":263},{"time":17291,"x":256,"y":263}]},{"id":0,"col":16777010,"fx":259,"time":17894,"fy":313,"type":"draw","childlist":[{"time":17927,"x":258,"y":313},{"time":17951,"x":257,"y":313},{"time":17972,"x":256,"y":313},{"time":17993,"x":254,"y":313},{"time":18017,"x":253,"y":313},{"time":18056,"x":252,"y":315},{"time":18075,"x":251,"y":316},{"time":18098,"x":251,"y":317},{"time":18120,"x":251,"y":319},{"time":18141,"x":251,"y":320},{"time":18165,"x":251,"y":321},{"time":18185,"x":252,"y":321},{"time":18207,"x":253,"y":322},{"time":18228,"x":254,"y":323},{"time":18268,"x":255,"y":323},{"time":18288,"x":256,"y":323},{"time":18316,"x":257,"y":323},{"time":18336,"x":258,"y":323},{"time":18390,"x":261,"y":322},{"time":18416,"x":262,"y":321},{"time":18435,"x":262,"y":320},{"time":18455,"x":262,"y":319},{"time":18474,"x":263,"y":317},{"time":18496,"x":263,"y":316},{"time":18515,"x":263,"y":315},{"time":18534,"x":262,"y":314},{"time":18553,"x":261,"y":313},{"time":18572,"x":258,"y":311},{"time":18593,"x":256,"y":310},{"time":18636,"x":255,"y":310}]},{"id":0,"col":16777010,"fx":259,"time":19794,"fy":363,"type":"draw","childlist":[{"time":19888,"x":258,"y":364},{"time":19907,"x":256,"y":364},{"time":19926,"x":252,"y":365},{"time":19948,"x":249,"y":366},{"time":19967,"x":242,"y":366},{"time":19987,"x":238,"y":366},{"time":20006,"x":232,"y":366},{"time":20027,"x":227,"y":366},{"time":20048,"x":224,"y":366},{"time":20069,"x":218,"y":365},{"time":20090,"x":216,"y":365},{"time":20116,"x":213,"y":364},{"time":20137,"x":208,"y":362},{"time":20157,"x":204,"y":361},{"time":20184,"x":198,"y":358},{"time":20203,"x":196,"y":358},{"time":20224,"x":193,"y":357},{"time":20252,"x":190,"y":355},{"time":20271,"x":188,"y":354},{"time":20290,"x":184,"y":352},{"time":20315,"x":180,"y":349},{"time":20334,"x":177,"y":346},{"time":20353,"x":174,"y":344},{"time":20372,"x":170,"y":340},{"time":20392,"x":165,"y":336},{"time":20415,"x":163,"y":334},{"time":20437,"x":159,"y":331},{"time":20457,"x":157,"y":330},{"time":20489,"x":151,"y":327},{"time":20508,"x":147,"y":325},{"time":20529,"x":145,"y":324},{"time":20552,"x":144,"y":323},{"time":20572,"x":143,"y":322},{"time":20591,"x":140,"y":321},{"time":20616,"x":136,"y":321},{"time":20635,"x":130,"y":320},{"time":20654,"x":126,"y":319},{"time":20674,"x":120,"y":319},{"time":20694,"x":117,"y":319},{"time":20715,"x":114,"y":319},{"time":20734,"x":112,"y":319},{"time":20755,"x":111,"y":319},{"time":20782,"x":107,"y":321},{"time":20802,"x":104,"y":322},{"time":20822,"x":101,"y":323},{"time":20842,"x":100,"y":324},{"time":20863,"x":97,"y":327},{"time":20884,"x":95,"y":330},{"time":20904,"x":93,"y":333},{"time":20923,"x":92,"y":336},{"time":20946,"x":90,"y":340},{"time":20967,"x":88,"y":344},{"time":20987,"x":87,"y":346},{"time":21007,"x":87,"y":351},{"time":21027,"x":86,"y":355},{"time":21047,"x":86,"y":356},{"time":21068,"x":86,"y":359},{"time":21088,"x":86,"y":361},{"time":21108,"x":86,"y":362},{"time":21130,"x":87,"y":369},{"time":21151,"x":88,"y":371},{"time":21171,"x":88,"y":373},{"time":21192,"x":89,"y":375},{"time":21216,"x":93,"y":380},{"time":21236,"x":97,"y":385},{"time":21256,"x":98,"y":388},{"time":21283,"x":100,"y":390},{"time":21302,"x":103,"y":392},{"time":21322,"x":107,"y":396},{"time":21346,"x":111,"y":399},{"time":21367,"x":115,"y":402},{"time":21387,"x":120,"y":405},{"time":21407,"x":123,"y":407},{"time":21427,"x":128,"y":411},{"time":21450,"x":133,"y":413},{"time":21470,"x":139,"y":416},{"time":21489,"x":143,"y":417},{"time":21517,"x":151,"y":420},{"time":21536,"x":156,"y":422},{"time":21555,"x":160,"y":423},{"time":21574,"x":167,"y":425},{"time":21595,"x":171,"y":426},{"time":21618,"x":178,"y":428},{"time":21637,"x":184,"y":430},{"time":21657,"x":190,"y":431},{"time":21680,"x":195,"y":432},{"time":21699,"x":201,"y":433},{"time":21719,"x":206,"y":434},{"time":21739,"x":210,"y":435},{"time":21759,"x":216,"y":436},{"time":21783,"x":222,"y":436},{"time":21803,"x":227,"y":437},{"time":21824,"x":230,"y":438},{"time":21850,"x":237,"y":439},{"time":21869,"x":243,"y":440},{"time":21889,"x":249,"y":440},{"time":21909,"x":253,"y":440},{"time":21931,"x":259,"y":440},{"time":21952,"x":262,"y":440},{"time":21972,"x":268,"y":440},{"time":21992,"x":271,"y":440},{"time":22017,"x":277,"y":440},{"time":22036,"x":281,"y":440},{"time":22056,"x":288,"y":440},{"time":22083,"x":295,"y":439},{"time":22103,"x":300,"y":437},{"time":22123,"x":304,"y":437},{"time":22142,"x":309,"y":436},{"time":22164,"x":315,"y":435},{"time":22185,"x":321,"y":433},{"time":22205,"x":326,"y":431},{"time":22226,"x":329,"y":430},{"time":22250,"x":335,"y":428},{"time":22269,"x":341,"y":426},{"time":22289,"x":346,"y":423},{"time":22308,"x":349,"y":422},{"time":22329,"x":352,"y":420},{"time":22350,"x":357,"y":417},{"time":22370,"x":360,"y":416},{"time":22390,"x":362,"y":414},{"time":22413,"x":364,"y":413},{"time":22434,"x":366,"y":412},{"time":22454,"x":367,"y":411},{"time":22474,"x":370,"y":407},{"time":22495,"x":373,"y":403},{"time":22515,"x":375,"y":400},{"time":22535,"x":377,"y":397},{"time":22555,"x":378,"y":394},{"time":22575,"x":380,"y":392},{"time":22597,"x":383,"y":386},{"time":22618,"x":384,"y":384},{"time":22638,"x":386,"y":381},{"time":22658,"x":387,"y":378},{"time":22683,"x":389,"y":374},{"time":22703,"x":390,"y":372},{"time":22724,"x":391,"y":371},{"time":22747,"x":391,"y":370},{"time":22767,"x":392,"y":368},{"time":22787,"x":393,"y":366},{"time":22807,"x":394,"y":364},{"time":22827,"x":394,"y":363},{"time":22851,"x":394,"y":361},{"time":22871,"x":395,"y":356},{"time":22891,"x":395,"y":353},{"time":22917,"x":395,"y":350},{"time":22937,"x":395,"y":349},{"time":22956,"x":395,"y":348},{"time":22981,"x":394,"y":346},{"time":23000,"x":393,"y":345},{"time":23019,"x":393,"y":344},{"time":23039,"x":392,"y":343},{"time":23059,"x":391,"y":342},{"time":23080,"x":390,"y":342},{"time":23100,"x":389,"y":341},{"time":23120,"x":388,"y":340},{"time":23140,"x":387,"y":340},{"time":23160,"x":385,"y":340},{"time":23184,"x":383,"y":340},{"time":23203,"x":381,"y":340},{"time":23224,"x":377,"y":340},{"time":23250,"x":373,"y":340},{"time":23269,"x":370,"y":340},{"time":23289,"x":367,"y":340},{"time":23309,"x":362,"y":340},{"time":23331,"x":355,"y":341},{"time":23352,"x":349,"y":343},{"time":23372,"x":346,"y":344},{"time":23392,"x":345,"y":344},{"time":23414,"x":341,"y":345},{"time":23434,"x":334,"y":346},{"time":23455,"x":329,"y":347},{"time":23475,"x":323,"y":349},{"time":23497,"x":318,"y":350},{"time":23518,"x":314,"y":351},{"time":23538,"x":309,"y":352},{"time":23559,"x":308,"y":353},{"time":23586,"x":303,"y":354},{"time":23606,"x":300,"y":354},{"time":23626,"x":299,"y":354},{"time":23651,"x":294,"y":355},{"time":23671,"x":291,"y":356},{"time":23691,"x":290,"y":356},{"time":23718,"x":288,"y":356},{"time":23737,"x":284,"y":356},{"time":23757,"x":279,"y":357},{"time":23788,"x":271,"y":359},{"time":23807,"x":267,"y":359},{"time":23826,"x":262,"y":360},{"time":23848,"x":259,"y":361},{"time":23867,"x":257,"y":361},{"time":23886,"x":255,"y":362},{"time":23905,"x":254,"y":362},{"time":23925,"x":252,"y":362},{"time":23950,"x":251,"y":362},{"time":23969,"x":249,"y":362},{"time":23988,"x":246,"y":362},{"time":24007,"x":241,"y":362}]},{"id":0,"col":16777010,"fx":100,"time":24561,"fy":335,"type":"draw","childlist":[{"time":24675,"x":100,"y":336},{"time":24696,"x":105,"y":343},{"time":24717,"x":112,"y":351},{"time":24736,"x":120,"y":358},{"time":24756,"x":123,"y":361},{"time":24784,"x":127,"y":364},{"time":24803,"x":130,"y":367},{"time":24823,"x":133,"y":369},{"time":24842,"x":138,"y":372},{"time":24864,"x":142,"y":375},{"time":24884,"x":146,"y":377},{"time":24904,"x":152,"y":379},{"time":24924,"x":158,"y":381},{"time":24956,"x":165,"y":384},{"time":24983,"x":168,"y":386},{"time":25003,"x":171,"y":388},{"time":25022,"x":177,"y":390},{"time":25041,"x":180,"y":392},{"time":25062,"x":185,"y":394},{"time":25084,"x":190,"y":397},{"time":25103,"x":194,"y":398},{"time":25123,"x":202,"y":399},{"time":25142,"x":209,"y":399},{"time":25163,"x":212,"y":400},{"time":25184,"x":218,"y":400},{"time":25204,"x":226,"y":400},{"time":25224,"x":235,"y":400},{"time":25250,"x":242,"y":400},{"time":25269,"x":246,"y":400},{"time":25288,"x":249,"y":400},{"time":25307,"x":253,"y":400},{"time":25326,"x":260,"y":400},{"time":25350,"x":266,"y":400},{"time":25370,"x":273,"y":400},{"time":25390,"x":279,"y":400},{"time":25417,"x":286,"y":400},{"time":25436,"x":291,"y":400},{"time":25456,"x":298,"y":398},{"time":25484,"x":307,"y":396},{"time":25503,"x":313,"y":394},{"time":25523,"x":318,"y":392},{"time":25547,"x":324,"y":389},{"time":25568,"x":329,"y":387},{"time":25588,"x":333,"y":386},{"time":25608,"x":335,"y":385},{"time":25630,"x":338,"y":383},{"time":25651,"x":341,"y":381},{"time":25671,"x":344,"y":380},{"time":25691,"x":345,"y":379},{"time":25737,"x":346,"y":378},{"time":25756,"x":347,"y":378},{"time":25775,"x":348,"y":377},{"time":25795,"x":349,"y":377},{"time":25818,"x":350,"y":376},{"time":25941,"x":350,"y":375}]},{"id":0,"col":16777010,"fx":26,"time":26953,"fy":176,"type":"draw","childlist":[{"time":26963,"x":24,"y":175},{"time":26983,"x":21,"y":174},{"time":27003,"x":16,"y":173},{"time":27023,"x":13,"y":173},{"time":27050,"x":10,"y":175},{"time":27070,"x":8,"y":180},{"time":27090,"x":8,"y":186},{"time":27118,"x":9,"y":190},{"time":27138,"x":16,"y":194},{"time":27158,"x":25,"y":194},{"time":27184,"x":35,"y":187},{"time":27205,"x":44,"y":170},{"time":27225,"x":44,"y":161},{"time":27247,"x":44,"y":148},{"time":27267,"x":38,"y":117},{"time":27354,"x":17,"y":88},{"time":27373,"x":13,"y":89},{"time":27392,"x":9,"y":94},{"time":27420,"x":7,"y":102},{"time":27439,"x":8,"y":106},{"time":27458,"x":19,"y":114},{"time":27486,"x":44,"y":120},{"time":27504,"x":68,"y":118},{"time":27524,"x":85,"y":106},{"time":27552,"x":102,"y":73},{"time":27750,"x":86,"y":67},{"time":27770,"x":107,"y":80},{"time":27790,"x":138,"y":86},{"time":27818,"x":167,"y":83},{"time":27837,"x":184,"y":66},{"time":27857,"x":186,"y":57},{"time":27884,"x":185,"y":46},{"time":27904,"x":183,"y":42},{"time":27923,"x":182,"y":40},{"time":27942,"x":179,"y":39},{"time":27964,"x":177,"y":39},{"time":27985,"x":173,"y":44},{"time":28005,"x":172,"y":48},{"time":28026,"x":172,"y":55},{"time":28051,"x":175,"y":62},{"time":28071,"x":197,"y":74},{"time":28091,"x":229,"y":81},{"time":28118,"x":254,"y":80},{"time":28137,"x":273,"y":64},{"time":28157,"x":277,"y":50},{"time":28184,"x":276,"y":42},{"time":28204,"x":274,"y":35},{"time":28224,"x":272,"y":33},{"time":28252,"x":270,"y":33},{"time":28272,"x":267,"y":33},{"time":28291,"x":263,"y":35},{"time":28316,"x":260,"y":41},{"time":28335,"x":260,"y":47},{"time":28354,"x":270,"y":61},{"time":28373,"x":285,"y":72},{"time":28393,"x":316,"y":84},{"time":28418,"x":349,"y":90},{"time":28438,"x":359,"y":89},{"time":28457,"x":363,"y":85},{"time":28485,"x":364,"y":78},{"time":28504,"x":365,"y":72},{"time":28524,"x":365,"y":68},{"time":28551,"x":364,"y":66},{"time":28570,"x":363,"y":66},{"time":28589,"x":362,"y":66},{"time":28629,"x":361,"y":68},{"time":28652,"x":361,"y":75},{"time":28671,"x":371,"y":89},{"time":28691,"x":384,"y":99},{"time":28719,"x":414,"y":106},{"time":28738,"x":426,"y":101},{"time":28757,"x":432,"y":94},{"time":28785,"x":437,"y":79},{"time":28804,"x":438,"y":75},{"time":28823,"x":438,"y":74},{"time":28871,"x":436,"y":74},{"time":28891,"x":434,"y":74},{"time":28915,"x":426,"y":82},{"time":28934,"x":418,"y":97},{"time":28954,"x":417,"y":102},{"time":28973,"x":416,"y":108},{"time":28993,"x":420,"y":113},{"time":29015,"x":424,"y":115},{"time":29035,"x":430,"y":116},{"time":29055,"x":434,"y":116},{"time":29074,"x":435,"y":116},{"time":29097,"x":436,"y":114},{"time":29172,"x":433,"y":117},{"time":29191,"x":432,"y":121},{"time":29220,"x":431,"y":133},{"time":29238,"x":431,"y":139},{"time":29256,"x":433,"y":145},{"time":29285,"x":437,"y":151},{"time":29304,"x":440,"y":152},{"time":29323,"x":441,"y":152},{"time":29351,"x":444,"y":150},{"time":29370,"x":445,"y":147},{"time":29452,"x":442,"y":150},{"time":29472,"x":440,"y":161},{"time":29491,"x":439,"y":168},{"time":29518,"x":440,"y":177},{"time":29538,"x":442,"y":182},{"time":29557,"x":443,"y":182},{"time":29585,"x":445,"y":182},{"time":29603,"x":448,"y":179},{"time":29622,"x":450,"y":178},{"time":29659,"x":450,"y":177},{"time":29684,"x":450,"y":176},{"time":29723,"x":447,"y":177},{"time":29742,"x":444,"y":180},{"time":29764,"x":441,"y":187},{"time":29786,"x":440,"y":195},{"time":29806,"x":440,"y":201},{"time":29825,"x":442,"y":205},{"time":29853,"x":447,"y":207},{"time":29872,"x":449,"y":207},{"time":29891,"x":452,"y":206},{"time":29915,"x":457,"y":203},{"time":29935,"x":459,"y":200},{"time":29955,"x":460,"y":199},{"time":29975,"x":460,"y":197},{"time":29996,"x":459,"y":195},{"time":30037,"x":458,"y":195},{"time":30058,"x":457,"y":195},{"time":30089,"x":453,"y":199},{"time":30109,"x":452,"y":206},{"time":30131,"x":452,"y":214},{"time":30161,"x":455,"y":223},{"time":30188,"x":460,"y":226},{"time":30207,"x":465,"y":227},{"time":30340,"x":465,"y":213}]},{"id":0,"col":16777010,"fx":2,"time":32141,"fy":67,"type":"draw","childlist":[{"time":32304,"x":6,"y":62},{"time":32334,"x":11,"y":55},{"time":32357,"x":13,"y":50},{"time":32378,"x":15,"y":47},{"time":32402,"x":16,"y":42},{"time":32423,"x":19,"y":36},{"time":32592,"x":26,"y":19},{"time":32614,"x":28,"y":16},{"time":32639,"x":30,"y":12},{"time":32658,"x":30,"y":11},{"time":32680,"x":31,"y":10},{"time":32706,"x":32,"y":8},{"time":32812,"x":32,"y":7},{"time":32838,"x":33,"y":5},{"time":32856,"x":34,"y":2}]},{"id":0,"col":16777010,"fx":404,"time":33957,"fy":0,"type":"draw","childlist":[{"time":34071,"x":392,"y":1},{"time":34090,"x":388,"y":4},{"time":34110,"x":384,"y":9},{"time":34134,"x":379,"y":20},{"time":34154,"x":378,"y":27},{"time":34174,"x":379,"y":34},{"time":34203,"x":400,"y":52},{"time":34224,"x":439,"y":68},{"time":34251,"x":455,"y":69},{"time":34271,"x":460,"y":67},{"time":34292,"x":465,"y":59},{"time":34372,"x":464,"y":38},{"time":34404,"x":457,"y":35},{"time":34424,"x":450,"y":34},{"time":34446,"x":443,"y":34},{"time":34469,"x":439,"y":38},{"time":34489,"x":437,"y":43},{"time":34509,"x":437,"y":45},{"time":34535,"x":439,"y":49},{"time":34556,"x":455,"y":53},{"time":34575,"x":462,"y":53},{"time":34735,"x":464,"y":46},{"time":34754,"x":459,"y":59},{"time":34772,"x":459,"y":64},{"time":34792,"x":463,"y":78},{"time":35491,"x":465,"y":186},{"time":35512,"x":428,"y":186},{"time":35538,"x":316,"y":201}]},{"id":0,"col":16777010,"fx":35,"time":36186,"fy":202,"type":"draw","childlist":[{"time":36305,"x":37,"y":207},{"time":36324,"x":43,"y":218},{"time":36345,"x":45,"y":223},{"time":36373,"x":46,"y":233},{"time":36391,"x":46,"y":237},{"time":36412,"x":46,"y":244},{"time":36439,"x":46,"y":251},{"time":36457,"x":46,"y":258},{"time":36476,"x":46,"y":261},{"time":36506,"x":46,"y":267},{"time":36524,"x":46,"y":272},{"time":36545,"x":45,"y":278},{"time":36573,"x":42,"y":286},{"time":36591,"x":41,"y":290},{"time":36617,"x":40,"y":296},{"time":36641,"x":38,"y":305},{"time":36659,"x":37,"y":310},{"time":36681,"x":35,"y":317},{"time":36706,"x":35,"y":324},{"time":36724,"x":34,"y":329},{"time":36745,"x":32,"y":336},{"time":36770,"x":30,"y":345},{"time":36789,"x":29,"y":349},{"time":36809,"x":29,"y":356},{"time":36836,"x":29,"y":364},{"time":36856,"x":29,"y":372},{"time":36876,"x":30,"y":377},{"time":36903,"x":33,"y":386},{"time":36923,"x":36,"y":393},{"time":36943,"x":38,"y":397},{"time":36970,"x":54,"y":418},{"time":36990,"x":71,"y":436},{"time":37010,"x":87,"y":452},{"time":37625,"x":418,"y":461},{"time":37652,"x":438,"y":437},{"time":37672,"x":443,"y":428},{"time":37691,"x":447,"y":422},{"time":37712,"x":453,"y":411},{"time":37736,"x":459,"y":401},{"time":37756,"x":462,"y":394},{"time":37776,"x":464,"y":389},{"time":38006,"x":462,"y":328},{"time":38024,"x":460,"y":321},{"time":38046,"x":458,"y":317},{"time":38074,"x":456,"y":309},{"time":38092,"x":453,"y":301},{"time":38114,"x":451,"y":296},{"time":38141,"x":449,"y":287},{"time":38174,"x":447,"y":278},{"time":38207,"x":445,"y":269},{"time":38239,"x":443,"y":256},{"time":38257,"x":443,"y":251},{"time":38276,"x":442,"y":247},{"time":38307,"x":442,"y":243},{"time":38323,"x":442,"y":242},{"time":38341,"x":443,"y":238},{"time":38358,"x":444,"y":235},{"time":38379,"x":446,"y":232},{"time":38406,"x":451,"y":226},{"time":38423,"x":454,"y":222},{"time":38440,"x":458,"y":217},{"time":38459,"x":460,"y":215}]}]';
			var comList:Array = JSON.decode(comListString);
			
			_player.setCommandList(comList);
			musicStart();
			_ch.stop();
		}
		
		private function musicStart():void {
			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars.mp3"), new SoundLoaderContext(10000, true));
//			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars_long.mp3"), new SoundLoaderContext(10000, true));
			_ch = sound.play();
			bA = new ByteArray();
			//			stage.quality = StageQuality.LOW;
			stage.fullScreenSourceRect=new Rectangle(0,0,465,465); 
			addEventListener(Event.ENTER_FRAME, updateSpectrum);
			
			//timer start
			_startTime = getTimer();
			
			/**
			 * action setup
			 */
			_field.addEventListener(MouseEvent.MOUSE_DOWN, _fieldDownHandler);
			_field.addEventListener(MouseEvent.MOUSE_UP, _fieldUpHandler);
			_field.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
			
			//Play Draw
			_player.addEventListener(DrawPlayer.DO_ROOT, _rootEventHandler);
			_player.addEventListener(DrawPlayer.DO_NODE, _nodeEventHandler);
			_player.addEventListener(DrawPlayer.DO_CLEAR, _clearEventHandler);
		}
		
		public function setupDisplay():void {
			addChild(_paintField);
			addChild(_field);
			addChild(_clearEffBmp);
			addChild(_uiField);
			addChild(_stopUiField);
			addChild(_startField);
			_uiField.addChild(_colSelector);
			_colSelector.x = 20;
			_colSelector.y = 85;
			_stopUiField.visible = true;
			_uiField.visible = false;
			_startField.visible = false;
		}
		/**
		 * mouse Action
		 */
		private function _fieldDownHandler(event:MouseEvent):void {
			addRoot();
			_col = _colSelector.currentColor;
			_field.addEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
			var currentTime:int = getTimer() - _startTime;
			var id:int=0;
			_rec.startLineRec(id,mouseX,mouseY,_colSelector.currentColor,currentTime);
		}
		private function _fieldUpHandler(event:MouseEvent):void {
			//今書いたものにベクトル情報追加
			_field.removeEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
		}
		private function _fieldMoveHandler(event:MouseEvent):void {
			addNode(_field.mouseX, _field.mouseY);
			//rec
			var currentTime:int = getTimer() - _startTime;
			_rec.addPoint(_field.mouseX, _field.mouseY, currentTime);
		}
		/**
		 * play Action
		 */
		private function _rootEventHandler(event:Event):void {
			addRoot();
			_col = _player.cur_Col;
		}
		private function _nodeEventHandler(event:Event):void {
			addNode(_player.cur_x, _player.cur_y);	
		}
		private function _clearEventHandler(event:Event):void {
			clear();
		}
		/**
		 * node Action
		 */
		private function addRoot():void {
			trace("adRoot");
			_currentListIndex = _pointListList.length;
			_pointListList.push(new Array());
		}
		private function addNode(px:Number, py:Number):void {
			trace("addNode");
			var _list:Array = _pointListList[_currentListIndex];
			_list.push(new LinePoint(px, py));
			var i:int = _list.length-1;
			_list[i].color = _col;
			if(_list[i-1]) {
				var _pt:LinePoint = _list[i];
				var _dx:Number = _list[i].x - _list[i-1].x;
				var _dy:Number = _list[i].y - _list[i-1].y;
				var _distance:Number = Math.sqrt(_dx*_dx+_dy*_dy);
				_pt.vx = _list[i].x - _list[i-1].x;
				_pt.vy = _list[i].y - _list[i-1].y;
				//				_pt.vx = _dx/_distance;
				//				_pt.vy = _dy/_distance;
				_pt.genRotation();
			}
		}
		private function _enterFrameHandler(event:Event):void {
			var i:int;
			var len:int = _pointListList.length;
			_paintField.graphics.clear();
			_paintField.graphics.lineStyle(1,0xFFFFFF);
			var _list:Array;
			var j:int;
			var _listlen:int;
			var nx:Number;
			var ny:Number;
			var dist:Number;
			if(_actionFlg) {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.lineStyle(1,_list[0].color);
						_paintField.graphics.moveTo(_list[0].x, _list[0].y);
						//スペクトラムずらす
						for(j=_listlen-1;j>0;j--) {
							_list[j].spectrum = _list[j-1].spectrum;
						}
						_list[0].spectrum = spectrum[10];
						for(j=0;j<_listlen;j++) {
							//							_paintField.graphics.moveTo(_list[j].x, _list[j].y);
							if(_list[j].r){
								nx = -(_list[j].vy);
								ny = _list[j].vx;
								dist = Math.sqrt(nx*nx+ny*ny);
								//							    _list[j].spectrum = spectrum[j];//スペクトラム直でまっぴんぐ
								_paintField.graphics.lineTo(_list[j].x+nx*_list[j].spectrum*7, _list[j].y+ny*_list[j].spectrum*7);
								//							    _paintField.graphics.lineTo(_list[j].x+_list[j].spectrum*2*nx/dist, _list[j].y+40*_list[j].spectrum*2*ny/dist);
							}
						}
					}
				}
			} else {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.moveTo(_list[0].x, _list[0].y); 
						for(j=0;j<_listlen;j++) {
							_paintField.graphics.lineTo(_list[j].x, _list[j].y);
						}
					}
				}
			}
		}
		
		private function updateSpectrum(e:Event):void {
			SoundMixer.computeSpectrum(bA,false,0);
			spectrum = [];
			var i:int;
			for(i=0; i<256; i++){
				spectrum[i] = bA.readFloat();
			}
			for(i=256; i<512; i++){
				spectrum[i] = bA.readFloat();
			}
			bA.position=0;
			lowVal = spectrum[0];
			middleVal = spectrum[1];
			highVal = spectrum[2];
		} 
		
		/**
		 * ui Action
		 */
		private function startHandler(event:MouseEvent):void {
			_startField.visible = false;
			_uiField.visible = true;
			musicStart();
		}
		private function actionHandler(event:MouseEvent):void {
			_actionFlg = true;
		}
		private function noActionHandler(event:MouseEvent):void {
			_actionFlg = false;
		}
		private function clearHandler(event:MouseEvent):void {
			_rec.addClear(getTimer()-_startTime)
			clear();
		}
		private function plotHandler(event:MouseEvent):void {
			_rec.outPut();
		}
		private function stopHandler(event:MouseEvent):void {
			_ch.stop();
			clear();
			_player.setCommandList(_rec.commandList);
			Tweener.addTween(_uiField, {_autoAlpha:0, time:0.5, transition:Equations.easeOutQuint});
			Tweener.addTween(_stopUiField, {_autoAlpha:1, time:0.5, transition:Equations.easeOutQuint});
		}
		private function playDataHandler(event:MouseEvent):void {
			_ch = sound.play(0);
			_player.playStart();
		}
		private function stopDrawHandler(event:MouseEvent):void {
			clear();
			_currentListIndex = 0;
			_ch.stop();
			_player.playStop();
		}
		public var clearCnt:Number = 0;
		private function clear():void {
			_clearBmd.fillRect(new Rectangle(0,0,465,465),0);
			_clearBmd.draw(_paintField);
			_clearEffBmp.visible = true;
			_clearEffBmp.alpha = 1;
			_clearEffBmp.scaleX = _clearEffBmp.scaleY = 1;
			Tweener.addTween(_clearEffBmp, {/*scaleX:2, scaleY:2, */_autoAlpha:0, time:1, transition:Equations.easeOutQuint});
			clearComp();
			//			var i:int;
			//			var len:int = _pointListList.length;
			//			var _list:Array;
			//			var _listlen:int;
			//			var j:int;
			//			var nx:int, ny:int;
			//			for(i=0; i<len; i++) {
			//				_list = _pointListList[i];
			//				_listlen = _list.length;
			//				for(j=0;j<_listlen;j++) {
			//					_list[j].endAction();
			//				}
			//			}
			//			Tweener.addTween(this, {clearCnt:10, time:0.8, transition:Equations.easeOutQuint, onComplete:clearComp});
		}
		private function clearComp():void {
			var i:int;
			var len:int = _pointListList.length;
			var _list:Array;
			var _listlen:int;
			var j:int;
			var nx:int, ny:int;
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_listlen = _list.length;
				for(j=0;j<_listlen;j++) {
					_list[j] = null;
				}
			}
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_list.length = 0;
				_list = null;
			}
			_pointListList.length = 0;
			_pointListList = new Array();
		}
	}
}
import caurina.transitions.Equations;
import caurina.transitions.Tweener;

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.external.ExternalInterface;
import flash.geom.Point;
import flash.utils.Timer;
import flash.utils.getTimer;

import org.osmf.events.TimeEvent;



class LinePoint extends Point {
	public var vx:Number, vy:Number, r:Number;
	public var spectrum:Number = 0;
	public var color:Number;
	public function LinePoint(x:Number=0, y:Number=0) {
		super(x,y);
	}
	public function genRotation():void {
		r = Math.atan2(vy, vx);
	}
	public function endAction():void {
		var _targetSp:Number = spectrum * 20;
		Tweener.addTween(this, {spectrum:_targetSp, time:0.5, transition:Equations.easeOutQuint});
	}
}

class ColorSelector extends Sprite {
	public var colorList:Array = new Array();
	public var currentColor:Number = 0xFFFF32;
	private var _colTotal:int = 5;
	private var _selectedColor:Sprite = new Sprite();
	
	public function ColorSelector() {
		init();
		setupDisplay();
	}
	public function init():void {
		var i:int;
		for(i=0; i<_colTotal; i++) {
			var block:Sprite = new Sprite();
			//			block.name = String(0xFF0000*Math.random());
			block.addEventListener(MouseEvent.CLICK, selectedHandler);
			colorList.push(block);
		}
		colorList[0].name = String(0xFFFF32);
		colorList[1].name = String(0xFFFF99);
		        colorList[2].name = String(0xFFFFCD);
		        colorList[3].name = String(0xFFCC32);
		        colorList[4].name = String(0xFFCC00);
		for(i=0; i<_colTotal; i++) {
			colorList[i].graphics.clear();
			colorList[i].graphics.beginFill(Number(colorList[i].name));
			colorList[i].graphics.drawRect(0,0,10,10);
			colorList[i].graphics.endFill();
		}
		
		currentColor = Number(colorList[0].name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
		
	}
	public function setupDisplay():void {
		addChild(_selectedColor);
		for(var i:int=0; i<_colTotal; i++) {
			addChild(colorList[i]);
			colorList[i].x = i*(colorList[i].width+1);
			colorList[i].y = 20;
		}
	}
	private function selectedHandler(event:MouseEvent):void {
		_selectedColor.graphics.clear();
		currentColor = Number(event.target.name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
	}
}

class DrawPlayer extends Sprite {
	
	public static const DO_ROOT:String = "DoRoot";
	public static const DO_NODE:String = "DoNode";
	public static const DO_CLEAR:String = "DoClear";
	private var _commandList:Array;
	private var _timer:Timer = new Timer(1);
	private var _rootIndex:int = 0;
	private var _nodeIndex:int = 0;
	private var _counter:int = 0;
	private var _watchTarget:int = 0; //0:親, 1:子
	
	//現在の命令
	public var cur_Command:int = 0; //0:親, 1:子
	public var cur_Col:Number;
	public var cur_x:Number;
	public var cur_y:Number;
	
	//timer
	private var _startTime:Number;
	
	public function DrawPlayer() {
		super();
	}
	
	public function setCommandList(list:Array):void {
		_commandList = list;
	}
	
	public function playStart():void {
		_counter = 0;
		_rootIndex = 0;
		_nodeIndex = 0;
		_watchTarget = 0;
		_startTime = getTimer();
		addEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	public function playStop():void {
		removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	
	private function _commandCheckHandler(event:Event):void {
		_counter = getTimer()-_startTime;
		//まだ終わってなかったら終わる
		if(_rootIndex == _commandList.length) {
			if(hasEventListener(Event.ENTER_FRAME))removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
			return;
		}
		if(_watchTarget==0) {
			if(_commandList[_rootIndex].time<=_counter) {
				switch(_commandList[_rootIndex].type) {
					case "clear":
						_watchTarget = 0;
						dispatchEvent(new Event(DO_CLEAR));
						_rootIndex++;
						break;
					case "draw":
						cur_Col = _commandList[_rootIndex].col;
						cur_x = _commandList[_rootIndex].fx;
						cur_y = _commandList[_rootIndex].fy;
						dispatchEvent(new Event(DO_ROOT));
						_watchTarget = 1;
						break;
				}
			}
		} else {
			var obj:Object = _commandList[_rootIndex][_nodeIndex];
			//マウス動かなかった時は親にそのまま向ける
			if(!_commandList[_rootIndex].childlist[_nodeIndex]){
				_rootIndex++;
				_nodeIndex=0;
				_watchTarget=0;
				return;
			}
			if(_commandList[_rootIndex].childlist[_nodeIndex].time<=_counter) {
				cur_x = _commandList[_rootIndex].childlist[_nodeIndex].x;
				cur_y = _commandList[_rootIndex].childlist[_nodeIndex].y;
				dispatchEvent(new Event(DO_NODE));
				_nodeIndex++;
				//最後尾到達で親監視に切り替え
				if(_nodeIndex==_commandList[_rootIndex].length-1) {
					//親も最後尾なら終了
					if(_rootIndex==_commandList.length-1) {
						_timer.removeEventListener(TimerEvent.TIMER, _commandCheckHandler);
						_timer.stop();
						return;
					} else {
						_watchTarget = 0;
						_rootIndex++;
					}
				}
			}
			
		}
	}
	
	private function _commandCheck():void{
		
	}
	
}

class DrawRecoder extends Sprite {
	private var _commandList:Array = new Array();
	public function get commandList():Array {
		return _commandList;
	}
	public function DrawRecoder() {
		
	}
	
	public function startLineRec(_id:int,_mx:Number,_my:Number,_col:Number, _time:Number):void {
		_commandList.push({type:"draw", id:_id,fx:_mx, fy:_my, col:_col, time:_time, childlist:new Array()});
	}
	public function addPoint(_mx:Number, _my:Number, _time:Number):void {
		var _currentList:Array = _commandList[_commandList.length-1].childlist;
		_currentList.push({x:_mx, y:_my, time:_time});
	}
	public function addClear(_time:Number):void {
		_commandList.push({type:"clear", time:_time});
	}
	public function endLineRec():void {
		
	}
	
	public function outPut():void {
		var i:int;
		var j:int;
	}
}