/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lqOV
 */

// forked from narutohyper's rolloverするプリミティブとrolloverしないプリミティブの混在(ダメな例)
// forked from narutohyper's Alternativa3D BoxのサーフェースごとでのrolloverとClick
// forked from narutohyper's Alternativa3D interactiveな自作Boxクラスを使ってのrollover & Click
// forked from narutohyper's [Alternativa3D]　プリミティブのrollover &　rollout & Click
// forked from clockmaker's [Alternativa3D] Basic Template
package {
	import alternativ5.engine3d.materials.FillMaterial;
	import alternativ5.engine3d.primitives.Box;
	import alternativ5.engine3d.primitives.Plane;
	import alternativ5.engine3d.events.MouseEvent3D
	import alternativ5.types.Point3D;
	import flash.display.*;

	
	[SWF(width = 465, height = 465, frameRate = 60)]
	/**
	 * Alternativa3D を簡単に扱うためのベーシックテンプレート
	 * @author Yasu (clockmaker)
	 */
	/**
	 * Alternativa3D 
	 * rolloverするプリミティブとrolloverしないプリミティブの混在
	 * 解決編
	 * @narutohyper
	 */

	public class SimpleDemo extends Sprite {
		
		public function SimpleDemo():void {
			// テンプレートを作成します
			var template:BasicTemplate = new BasicTemplate();
			addChild(template);


			// 背景用プリミティブを作成します
			var plate:Plane=new Plane(1000,1000,8,8,true,true)
			plate.cloneMaterialToAllSurfaces(new FillMaterial(0x000000,1,BlendMode.NORMAL,1,0x666666));
			plate.coords=new Point3D(0,0,100);
			template.scene.root.addChild(plate);

			//Plateでは、rolloverしても、マウスカーソルはオフのまま
			plate.addEventListener(MouseEvent3D.MOUSE_OVER, cursorOff);
			plate.addEventListener(MouseEvent3D.MOUSE_OUT, cursorOff);


			// プリミティブを作成します
			var boxX:Array=[-300,300,0,-300,300]
			var boxY:Array=[-300,-300,0,300,300]
			var boxArray:Array=[]
			for (var i:uint=0;i<5;i++) {
				boxArray[i] = new interactiveBox(200, 200, 200);
				boxArray[i].cloneMaterialToAllSurfaces(new FillMaterial(0xFF0000));
				boxArray[i].coords=new Point3D(boxX[i],boxY[i],0);

				// 3Dシーンのルートに追加します
				template.scene.root.addChild(boxArray[i]);

				boxArray[i].addEventListener(MouseEvent3D.MOUSE_OVER, cursorOn);
				boxArray[i].addEventListener(MouseEvent3D.MOUSE_OUT, cursorOff);

			}


			function cursorOn(e:MouseEvent3D):void {
				template.view.buttonMode = true;
			}

			function cursorOff(e:MouseEvent3D):void {
				template.view.buttonMode = false;
			}


			/*-------------------------------------------------------
				プリミティブのロールオーバー、クリックを有効にする為
				viewのbuttonModeとinteractiveをtrueにする
			-------------------------------------------------------*/
			template.view.buttonMode = true;
			template.view.interactive = true;

			// Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
			// レンダリング前に実行したい処理を記述します。
			template.onPreRender = function():void {

				// 立方体を回転させます (角度はラジアン)
				for (var i:uint=0;i<5;i++) {
					boxArray[i].rotationY += 1 * Math.PI / 180;
				}	
				// マウスがステージの高さ何%の位置にあるか算出
				//var rateY:Number = mouseY / stage.stageHeight;
				
				// カメラの高さの座標を調整
				// イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
				//template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;
				
				// カメラの座標を中央に向かせる
				template.cameraContoller.lookAt(new Point3D());
			}


		}



	}
}


import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;

import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;

import alternativ5.engine3d.primitives.Box;
import alternativ5.engine3d.events.MouseEvent3D
import alternativ5.engine3d.materials.FillMaterial;


/**
 * 追記
 * interactiveなbox
 */
class interactiveBox extends Box{

	private var colorArray:Array=[0xFF0000,0x0000FF,0x00FF00,0xFF00FF,0xFFFF00,0x00FFFF]
	private var colorCounter:Object={front:0,back:0,left:0,right:0,top:0,bottom:0}
	private var material:FillMaterial

	public function interactiveBox(width:Number = 100, length:Number = 100, height:Number = 100, widthSegments:uint = 1, lengthSegments:uint = 1, heightSegments:uint = 1, reverse:Boolean = false, triangulate:Boolean = false) {
		super(width, length, height, widthSegments, lengthSegments, heightSegments, reverse, triangulate)

		/*-------------------------------------------------------
		*	各フェイスにロールオーバー、クリックのリスナーを追加
		*-------------------------------------------------------*/
		

		this.getSurfaceById("front").addEventListener(MouseEvent3D.CLICK, onClick);
		this.getSurfaceById("front").addEventListener(MouseEvent3D.MOUSE_OVER, onMouseOver);
		this.getSurfaceById("front").addEventListener(MouseEvent3D.MOUSE_OUT, onMouseOut);
		this.getSurfaceById("back").addEventListener(MouseEvent3D.CLICK, onClick);
		this.getSurfaceById("back").addEventListener(MouseEvent3D.MOUSE_OVER, onMouseOver);
		this.getSurfaceById("back").addEventListener(MouseEvent3D.MOUSE_OUT, onMouseOut);
		this.getSurfaceById("left").addEventListener(MouseEvent3D.CLICK, onClick);
		this.getSurfaceById("left").addEventListener(MouseEvent3D.MOUSE_OVER, onMouseOver);
		this.getSurfaceById("left").addEventListener(MouseEvent3D.MOUSE_OUT, onMouseOut);
		this.getSurfaceById("right").addEventListener(MouseEvent3D.CLICK, onClick);
		this.getSurfaceById("right").addEventListener(MouseEvent3D.MOUSE_OVER, onMouseOver);
		this.getSurfaceById("right").addEventListener(MouseEvent3D.MOUSE_OUT, onMouseOut);
		this.getSurfaceById("top").addEventListener(MouseEvent3D.CLICK, onClick);
		this.getSurfaceById("top").addEventListener(MouseEvent3D.MOUSE_OVER, onMouseOver);
		this.getSurfaceById("top").addEventListener(MouseEvent3D.MOUSE_OUT, onMouseOut);
		this.getSurfaceById("bottom").addEventListener(MouseEvent3D.CLICK, onClick);
		this.getSurfaceById("bottom").addEventListener(MouseEvent3D.MOUSE_OVER, onMouseOver);
		this.getSurfaceById("bottom").addEventListener(MouseEvent3D.MOUSE_OUT, onMouseOut);

	}

	/*-------------------------------------------------------
		ロールオーバー、クリック動作を設定
	-------------------------------------------------------*/
	private function onClick(e:MouseEvent3D):void {
		var sid:Object=e.surface.id;
		colorCounter[sid]=(colorCounter[sid]+1)%6;
		material.color=colorArray[colorCounter[sid]];
		this.setMaterialToSurface(material,e.surface)

	}

	private function onMouseOver(e:MouseEvent3D):void {
		var sid:Object=e.surface.id;
		material=new FillMaterial(colorArray[colorCounter[sid]],0.5);
		this.setMaterialToSurface(material,e.surface)

	}

	private function onMouseOut(e:MouseEvent3D):void {
		var sid:Object=e.surface.id;
		material=new FillMaterial(colorArray[colorCounter[sid]],1);
		this.setMaterialToSurface(material,e.surface)

	}


}










/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
class BasicTemplate extends Sprite{
	/**
	 * シーンインスタンスです。
	 */
	public var scene:Scene3D;
	/**
	 * ビューインスタンスです。
	 */
	public var view:View;
	/**
	 * カメラインスタンスです。
	 */
	public var camera:Camera3D;
	/**
	 * カメラコントローラーです。
	 */
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	/**
	 * 新しい BasicTemplate インスタンスを作成します。
	 * @param	viewWidth
	 * @param	viewHeight
	 * @param	scaleToStage
	 */
	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.z = -1000;
		scene.root.addChild(camera);
		
		// camera contoller
		cameraContoller = new CameraController(this);
		cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理をオーバーライドして記述します。
	 */
	protected function atInit():void {}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理を記述します。
	 */
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPreRender():void {}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理を記述します。
	 */
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPostRender():void {
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理を記述します。
	 */
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	/**
	 * レンダリングを開始します。
	 */
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	/**
	 * レンダリングを停止します。
	 */
	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	/**
	 * シングルレンダリング(レンダリングを一回だけ)を実行します。
	 */
	public function singleRender():void {
		onRenderTick();
	}
	
	/**
	 * @private
	 */
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		// resize
		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		// render
		startRendering();
		
		atInit();
		_onInit();
		
	}
	
	/**
	 * @private
	 */
	private function onRenderTick(e:Event = null):void {
		atPostRender();
		_onPostRender();
		scene.calculate();
		atPreRender();
		_onPreRender();
	}
	
	/**
	 * @private
	 */
	private function onResize(event:Event = null):void {
		if (_scaleToStage) {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}else {
			view.width = _viewWidth;
			view.height = _viewHeight;
		}
	}
}

