/**
 * Copyright Kenshiro_N ( http://wonderfl.net/user/Kenshiro_N )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lpte
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="465", height="465", frameRate="30",backgroundColor=0x000000)]
    public class BrownianParticles extends Sprite{
        
        public var particles:Array;
        public var num:uint= 50;
        public var fl:Number = 0.8;
        public var gravity:Number = 0.1;
        public var bounce:Number = -0.8;
        public var sun:particle;
        
        public function BrownianParticles() 
        {
            
            sun = new particle(0xFF0099,20);
            sun.x = stage.stageWidth/2;
            sun.y = stage.stageHeight/2;
            sun.vx = 0;
            sun.vy = 0;
            sun.mass = 10000;
            addChild(sun);
            
            particles = new Array();
            for(var i:uint = 0; i < num; i++)
            {
                var obj:particle = new particle(0xFF0099);
                obj.x = Math.random() * stage.stageWidth;
                obj.y = Math.random() * stage.stageHeight;
                obj.vx = Math.random() * 0.2 - 0.1
                obj.vy = Math.random() * 0.2 - 0.1;
                obj.mass = 1;
                addChild(obj);
                particles.push(obj);

            }
            
            addEventListener(Event.ENTER_FRAME, onEF);
        }
        private function onEF(event:Event):void
        {
            graphics.clear();
            sun.x = mouseX;
            sun.y = mouseY;
            screenCheck(sun);
            
            for(var i:uint = 0; i < num; i++)
            {
                move(particles[i]);
                graphics.lineStyle(1, 0xFF0099, .5);
                graphics.moveTo(sun.x, sun.y);
                graphics.lineTo(particles[i].x, particles[i].y);
                gravitate(particles[i], sun);
                screenCheck(particles[i])
            }
        }
        private function move(me:particle):void
        {
            me.x += me.vx;
            me.y += me.vy;
            me.vy += gravity;
            me.vx *= fl;
            me.vy *= fl;
        }
        private function gravitate(partA:particle, partB:particle):void
        {
            var dx:Number = partB.x - partA.x;
            var dy:Number = partB.y - partA.y;
            var distSQ:Number = dx*dx + dy*dy;
            var dist:Number = Math.sqrt(distSQ);
            if(dist > partB.r + partA.r){
                var force:Number = partA.mass * partB.mass / distSQ;
                var ax:Number = force * dx / dist;
                var ay:Number = force * dy / dist;
                partA.vx += ax / partA.mass;
                partA.vy += ay / partA.mass;
            }else{
                partA.vx = Math.random() * 100 - 50;
                partA.vy = Math.random() * 100 - 50;
            }

        }
        private function screenCheck(me:particle):void
        {
            var rad:Number =  me.r;
            if(me.x + rad > stage.stageWidth)
            {
                me.x = stage.stageWidth - rad;
                me.vx *= bounce;
            }
            else if(me.x - rad < 0)
            {
                me.x = rad;
                me.vx *= bounce;
            }
            if(me.y + rad > stage.stageHeight)
            {
                me.y = stage.stageHeight - rad;
                me.vy *= bounce;
            }
            else if(me.y - rad < 0)
            {
                me.y = rad;
                me.vy *= bounce;
            }

        }
    }
}

import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.Event;

class particle extends Sprite
{
    public var color:uint;
    public var r:Number = 1;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var mass:Number = 1;

    public function particle(color:uint=0xFFFFFF,r:Number=1)
    {
        this.r = r;
        this.color = color;
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, r);
        graphics.endFill();
    }
}