/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lpem
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
 
	public class Main extends Sprite
	{
		private var charaChip:BitmapData;
		private var mapChip:BitmapData;
		private const C_WIDTH:int = 32;
		private const C_HEIGHT:int = 48;
		private const CHIPSIZE:int = 32;
		private const SPEED:int = 4;
 
		private var frame:int = 0;
		private var cx:int = 1;
		private var cy:int = 0;
		private var prevcy:int = 0;
		private var chara:BitmapData;
		private var key:int = 0;
		private var player:Sprite;		
		private var isMoving:Boolean = false;
		private var vx:int = 0;
		private var vy:int = 0;
		private var images:Object = new Object();
		private var bg:BitmapData;
 
		private	const IMAGE_URL:Array =
		[
			["http://assets.wonderfl.net/images/related_images/3/33/3384/3384200b2dc435c82a6c311375c2e26b81bc80e2", Image.CHARACTER],
			["http://assets.wonderfl.net/images/related_images/9/96/960f/960f848ab2430cd34645d8bea61661491d5cdcaf", Image.MAP]
		];
 
		public function Main()
		{
			var loadCount:int = 0;
			var f:Function = function(event:Event):void
			{
				images[event.currentTarget.loader.name] = event.currentTarget.loader;
				if (++loadCount == IMAGE_URL.length) initHandler();
			}
 
			for (var i:int = 0; i < IMAGE_URL.length; i++)
			{
				var loader:Loader = new Loader();
				loader.contentLoaderInfo.addEventListener(Event.INIT, f);
				loader.load(new URLRequest(IMAGE_URL[i][0]), new LoaderContext(true));
				loader.name = IMAGE_URL[i][1];
			}
		}
 
		private function initHandler():void
		{			
			var loader:Loader = images[Image.MAP];
			mapChip = new BitmapData(loader.width, loader.height, true, 0x0);
			mapChip.draw(loader);
 
			bg = new BitmapData(Map.width * CHIPSIZE, Map.height * CHIPSIZE, true, 0x0);
			addChild(new Bitmap(bg));
 
			var length:int = mapChip.width / CHIPSIZE;
			for (var y:int = 0; y < Map.height; y++)
			{
				for (var x:int = 0; x < Map.width; x++)
				{
					var mx:int = Map.data[y][x] % length;
					var my:int = Map.data[y][x] / length;
					bg.copyPixels(mapChip, new Rectangle(mx * CHIPSIZE, my * CHIPSIZE, CHIPSIZE, CHIPSIZE), new Point(x * CHIPSIZE, y * CHIPSIZE));
				}
			}
 
			loader = images[Image.CHARACTER];
			charaChip = new BitmapData(loader.width, loader.height, true, 0x0);
			charaChip.draw(loader);
			charaChip.threshold(charaChip, charaChip.rect, new Point(), "==", 0x78c380, 0x0, 0xFFFFFF);
 
			chara = new BitmapData(C_WIDTH, C_HEIGHT, true, 0x0);
			var bitmap:Bitmap = new Bitmap(chara);
			bitmap.y -= CHIPSIZE / 2;
			player = new Sprite();
			player.addChild(bitmap);
			addChild(player);
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
 
		private function onEnterFrame(event:Event = null):void
		{
			if (isMoving)
			{
				player.x += vx;
				player.y += vy;
 
				if ((vx && player.x % CHIPSIZE == 0) || (vy && player.y % CHIPSIZE == 0))
				{
					isMoving = false;
					if (!key) cx = 1;
				}
			}
			else
			{
				vx = vy = 0;
 
				if (key & Key.LEFT) vx = -SPEED, cy = 1;
				else if (key & Key.RIGHT) vx = SPEED, cy = 2;
				else if (key & Key.TOP) vy = -SPEED, cy = 3;
				else if (key & Key.BOTTOM) vy = SPEED, cy = 0;
 
				if (vx || vy)
				{
					var px:int = player.x / CHIPSIZE;
					var py:int = player.y / CHIPSIZE;
					py += vy / SPEED;
					px += vx / SPEED;
					if (0 <= py && py < Map.height &&
						0 <= px && px < Map.width  &&
						Map.data[py][px] == 0)
					{
						isMoving = true;
						onEnterFrame();
					}
				}
			}
 
			if (prevcy != cy || frame++ % 5 == 0)
			{
				chara.copyPixels(charaChip, new Rectangle(C_WIDTH * (cx + 6), C_HEIGHT * cy, C_WIDTH, C_HEIGHT), new Point());
				if (isMoving) cx = (cx + 1) % 3;
				prevcy = cy;
			}
		}
 
		private function onKeyDown(event:KeyboardEvent):void
		{
			if (event.keyCode == 37) key |= Key.LEFT;
			if (event.keyCode == 39) key |= Key.RIGHT;
			if (event.keyCode == 38) key |= Key.TOP;
			if (event.keyCode == 40) key |= Key.BOTTOM;
		}
 
		private function onKeyUp(event:KeyboardEvent):void
		{
			if (event.keyCode == 37) key -= Key.LEFT;
			if (event.keyCode == 39) key -= Key.RIGHT;
			if (event.keyCode == 38) key -= Key.TOP;
			if (event.keyCode == 40) key -= Key.BOTTOM;
		}
	}
}
 
class Key
{
	public static const LEFT:int = 1;
	public static const RIGHT:int = 2;
	public static const TOP:int = 4;
	public static const BOTTOM:int = 8;
}
 
class Map
{
	public static var width:int = 5;
	public static var height:int = 5;
 
	public static var data:Array = 
	[
		[0, 0, 0, 0, 0],
		[0, 98, 98, 100, 0],
		[0, 0, 0, 98, 0],
		[0, 0, 0, 98, 0],
		[0, 0, 0, 0, 0]
	];
}
 
class Image
{
	public static const CHARACTER:int = 0;
	public static const MAP:int = 1;
}
