/**
 * Copyright Naohiko.Ueno ( http://wonderfl.net/user/Naohiko.Ueno )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lp6A
 */

package 
{
    //    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.system.Capabilities;    
    
    import starling.core.Starling;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="#222222")]
    public class Startup extends flash.display.Sprite
    {
        private var mStarling:Starling;
        
        public function Startup()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            Starling.multitouchEnabled = false; // useful on mobile devices
            Starling.handleLostContext = true; // deactivate on mobile devices (to save memory)            
            
            mStarling = new Starling(RenderTextureScene, stage);
            mStarling.simulateMultitouch = true;
            mStarling.enableErrorChecking = Capabilities.isDebugger;
            mStarling.showStats = true;
            mStarling.start();            
            
            // this event is dispatched when stage3D is set up
            mStarling.stage3D.addEventListener(Event.CONTEXT3D_CREATE, onContextCreated);
        }
        
        private function onContextCreated(event:Event):void
        {
            // set framerate to 30 in software mode
            if (Starling.context.driverInfo.toLowerCase().indexOf("software") != -1)
                Starling.current.nativeStage.frameRate = 30;
        }
    }
}


import flash.geom.Point;
import flash.utils.Dictionary;

import starling.core.Starling;
import starling.display.BlendMode;
import starling.display.Button;
import starling.display.Image;
import starling.display.Quad;
import starling.display.Sprite;
import starling.events.Event;
import starling.events.Touch;
import starling.events.TouchEvent;
import starling.events.TouchPhase;
import starling.text.BitmapChar;
import starling.text.BitmapFont;
import starling.text.TextField;
import starling.textures.RenderTexture;
import starling.textures.Texture;

class RenderTextureScene extends Sprite
{
    private var mRenderTexture:RenderTexture;
    private var mCanvas:Image;
    private var mBrush:Image;
//    private var mButton:Button;
    private var mButton:TextField;
    private var mColors:Dictionary;

    private var stageWidth:int;
    private var stageHeight:int;
    
    public function RenderTextureScene()
    {
        stageWidth = Starling.current.stage.stageWidth;
        stageHeight = Starling.current.stage.stageHeight;
        
        mColors = new Dictionary();
        mRenderTexture = new RenderTexture(stageWidth - 20, stageHeight - 40);
        
        var background:Quad = new Quad(mRenderTexture.width, mRenderTexture.height, 0xCCCCCC);
        background.setVertexColor(0, 0xDDDDDD);
        background.setVertexColor(3, 0xBBBBBB);
        background.x = 10;
        background.y = 30;
        addChild(background);
        
        mCanvas = new Image(mRenderTexture);
        mCanvas.x = background.x;
        mCanvas.y = background.y;
        mCanvas.addEventListener(TouchEvent.TOUCH, onTouch);
        addChild(mCanvas);        
        
        var mini:BitmapFont = new BitmapFont();
        var charID:int = "*".charCodeAt(0);
        var char:BitmapChar = mini.getChar(charID);
        
        //mBrush = new Image(Assets.getTexture("Brush"));
        mBrush = char.createImage();
        mBrush.pivotX = mBrush.width / 2;
        mBrush.pivotY = mBrush.height / 2;
        mBrush.scaleX = 4;
        mBrush.scaleY = 4;
        mBrush.blendMode = BlendMode.NORMAL;
        
        var infoText:TextField = new TextField(256, 128, "Touch the screen\nto draw!");
        infoText.color = 0xFFFFFF;
        infoText.fontSize = 24;
        infoText.x = mCanvas.width - infoText.width >> 1;
        infoText.y = mCanvas.height - infoText.height >> 1;
        mRenderTexture.draw(infoText);  
        
        mButton = new TextField(150, 21, "Mode: Draw");
        mButton.fontName = BitmapFont.MINI;
        mButton.color = 0xCCCCCC;
        mButton.fontSize = BitmapFont.NATIVE_SIZE * 2;
        mButton.border = true;
        mButton.x = stageWidth - mButton.width >> 1;
        mButton.y = 5;
        mButton.addEventListener(TouchEvent.TOUCH, onButtonTriggered);
        addChild(mButton);
    }
    
    private function onTouch(event:TouchEvent):void
    {
        // touching the canvas will draw a brush texture. The 'drawBundled' method is not
        // strictly necessary, but it's faster when you are drawing with several fingers
        // simultaneously.
        
        mRenderTexture.drawBundled(function():void
        {
            var touches:Vector.<Touch> = event.getTouches(mCanvas);
            
            for each (var touch:Touch in touches)
            {
                if (touch.phase == TouchPhase.BEGAN)
                    mColors[touch.id] = Math.random() * uint.MAX_VALUE;
                
                if (touch.phase == TouchPhase.HOVER || touch.phase == TouchPhase.ENDED)
                    continue;
                
                var location:Point = touch.getLocation(mCanvas);
                mBrush.x = location.x;
                mBrush.y = location.y;
                mBrush.color = mColors[touch.id];
                mBrush.rotation = Math.random() * Math.PI * 2.0;
                
                mRenderTexture.draw(mBrush);
            }
        });
    }
    
    private function onButtonTriggered(event:TouchEvent):void
    {
        var touch:Touch = event.getTouch(mButton, TouchPhase.ENDED);
        
        if (!touch) return;
        
        if (mBrush.blendMode == BlendMode.NORMAL)
        {
            mBrush.blendMode = BlendMode.ERASE;
            mButton.text = "Mode: Erase";
        }
        else
        {
            mBrush.blendMode = BlendMode.NORMAL;
            mButton.text = "Mode: Draw";
        }
    }
    
    public override function dispose():void
    {
        mRenderTexture.dispose();
        super.dispose();
    }
}
