/**
 * Copyright xperiments1 ( http://wonderfl.net/user/xperiments1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/locZ
 */

// forked from just_a_dude's Zooming Grid
package {
   
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.ui.Keyboard;
   
    public class ZoomingGrid extends Sprite {
        
        private var _container:Sprite;
        private var _numCols:int;
        private var _numRows:int;
        private var _tileWidth:int;
        private var _tileHeight:int;
        private var _tileGap:int;
        private var _numTiles:int;
        
        private var _matrixTweener:MatrixTweener;
        
        public function ZoomingGrid() 
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
            
        protected function    addedToStageHandler(event:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            // stage.scaleMode = StageScaleMode.NO_SCALE;
            
            init();
        }
        
        private function init():void
        {
            _container = new Sprite();
            addChild(_container);
            _container.graphics.beginFill(0, .5);
            _container.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            _container.graphics.endFill();
            
            _container.scrollRect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
            
            _matrixTweener = new MatrixTweener(_container);
            _matrixTweener.duration = 1.2;
            _matrixTweener.transition = "easeInOutQuad";
            
            _numCols = 4
            _numRows = 5;
            
            _tileWidthº = 80;
            _tileHeight = 160;
            _tileGap = 5;
            
            var cx:Number = (stage.stageWidth / 2) - ((_numCols * (_tileWidth + _tileGap)) / 2);
            var cy:Number = (stage.stageHeight / 2) - ((_numCols * (_tileHeight + _tileGap)) / 2);
            
            var i:int, j:int;
            var tile:Sprite;
            for (i = 0; i < _numCols; i++) {
                for (j = 0; j < _numRows; j++) {
                    tile = new Sprite();
                    tile.graphics.beginFill(Math.random() * 255 * 255 * 255);
                    tile.graphics.drawRect(0, 0, _tileWidth, _tileHeight);
                    tile.graphics.endFill();
                    
                    _container.addChild(tile);
                    tile.x = cx + (_tileWidth  + _tileGap) * i;
                    tile.y = cy + (_tileHeight + _tileGap) * j;
                    
                    tile.addEventListener(MouseEvent.CLICK, tileMouseClickHandler);
                }
            }
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, stageKeyDownHandler);
        }
        
        private function tileMouseClickHandler(event:MouseEvent):void 
        {
            var tile:Sprite = event.currentTarget as Sprite;
            if (_container.scaleX > 1 || _container.scaleY > 1) {
                _matrixTweener.reset(true);
            } else {
                _matrixTweener.getMatrixForSelection([tile], true);
            }
        }
        
        protected function stageKeyDownHandler(event:KeyboardEvent):void 
        {
            if (_container.scaleX > 1 || _container.scaleY > 1 && !isNaN(_matrixTweener.selectedIndex)) {
                var index:int = _matrixTweener.selectedIndex;
                
                if (event.keyCode == Keyboard.LEFT) {
                    if (index > 1) 
                        index--;
                } else if (event.keyCode == Keyboard.RIGHT) {
                    if (index < _container.numChildren)
                        index++;
                }
                _matrixTweener.selectedIndex = index;
                
            }
        }
     
    }
}

import caurina.transitions.Tweener;
import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;

class MatrixTweener extends EventDispatcher
{
    // the target DisplayObjectContainer that we 
        // want to scale
        private var _target:DisplayObjectContainer;
        
        // the matrix that will be used to 
        // scale our container
        private var _matrix:Matrix;
        
        // target scale / translation values
        // are stored in these properties
        private var _tSX:Number;
        private var _tSY:Number;
        private var _tTX:Number;
        private var _tTY:Number;
        
        // a flag indicating if we're "tweening" our matrix
        // or not
        private var _animating:Boolean;
        
        public function get animating():Boolean 
        { 
            return _animating;
        }
        
        // default "tweening duration"
        private var _duration:Number;
        
        public function get duration():Number
        {
            return _duration;
        }
        
        public function set duration(value:Number):void 
        {
            if (value == _duration)
                return;
            
            if (value < 0 )
                return;
                
            _duration = value;
        }
        
        // default "transtion" type
        // @see caurina.transitions.Tweener
        private var _transition:String;
        
        public function get transition():String
        {
            return _transition;
        }
        
        public function set transition(value:String):void
        {
            if (value == _transition)
                return;
            _transition = value;
        }
        
        // selected "child" index
        private var _selectedIndex:int;
        
        public function get selectedIndex():int 
        {
            return _selectedIndex;
        }
        
        public function set selectedIndex(value:int):void 
        {
            if (value == _selectedIndex)
                return;
            _selectedIndex = value;
            
            var child:DisplayObject = _target.getChildAt(_selectedIndex);
            if (!child)
                return;
            reset();
            getMatrixForSelection([child], true);
        }
        
        
        public function MatrixTweener(target:DisplayObjectContainer) 
        {
            _target = target;
            _matrix = new Matrix();
            _target.transform.matrix = _matrix;            
            _duration = 1;
            _transition = "easeInOut"; 
        }
        
        // if any of the DisplayObject isn't "nested" in our target
        // this method will throw an error, so be sure you're
        // including "valid" DisplayObject
        public function getMatrixForSelection(selection:Array, update:Boolean = false):void 
        {
            var i:int;
            var target:DisplayObject;
            var globalBounds:Rectangle;
            
            var tl:Point;
            var br:Point;
            
            
            for (i = 0; i < selection.length; i++) {
                target = selection[i] as DisplayObject;
                
                _selectedIndex = _target.getChildIndex(target);
                trace("selectedIndex : ", _selectedIndex);
                
                tl = target.localToGlobal(new Point(0, 0));
                
                br = target.localToGlobal(new Point(
                    target.width / target.scaleX, 
                    target.height / target.scaleY));
                
                if (i == 0) {
                    globalBounds = new Rectangle(tl.x, tl.y, 
                        br.x - tl.x , br.y - tl.y);
                } else {
                    globalBounds = globalBounds.union(new Rectangle(
                        tl.x, tl.y, br.x - tl.x , br.y - tl.y));
                }
            }
            
            
            tl = _target.globalToLocal(globalBounds.topLeft);
            br = _target.globalToLocal(globalBounds.bottomRight);
            
            var w:Number = br.x - tl.x;
            var h:Number = br.y - tl.y;                                
            var sX:Number = _target.width / w;
            var sY:Number = _target.height / h;
            
            var scale:Number  = Math.min(sX, sY);
            
            _tSX = scale;
            _tSY = scale;
            _tTX = -(tl.x + w / 2)  * scale + (_target.width  / 2);
            _tTY = -(tl.y + h / 2 ) * scale + (_target.height / 2);
            
            if (update) 
                animate();
        }
        
        public function reset(update:Boolean = false):void 
        {
            _tSX = _tSY = 1;
            _tTX = _tTY = 0;
            
            if (update)
                animate();
            else
                _target.transform.matrix = new Matrix();
        }
        
        
        public function animate():void 
        {
            Tweener.addTween(_matrix, {
                a: _tSX, 
                d: _tSY, 
                tx: _tTX,
                ty: _tTY,
                time: _duration, 
                transition: _transition,
                onStart:    animateStart,
                onUpdate:   animateUpdate,
                onComplete: animateComplete
            });
        }
        
        private function animateStart():void 
        {
            _animating = true;
            dispatchEvent(new Event("start"));
        }
        
        private function animateUpdate():void 
        {
            _animating = true;
            _target.transform.matrix = _matrix;
            dispatchEvent(new Event("update"));
        }
        
        private function animateComplete():void
        {
            _animating = false;
            dispatchEvent(new Event("complete"));
        }
}