/**
 * Copyright snaf ( http://wonderfl.net/user/snaf )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/loPe
 */

package  {
    import flash.display.AVM1Movie;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.sampler.NewObjectSample;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import caurina.transitions.Tweener;
    
    [SWF(width=465,height=465,backgroundColor=0x000000,frameRate=30)]
    public class ShootingGame extends Sprite{
        private var machine:Sprite=new Sprite();
        private var boss:Sprite=new Sprite();
        private var frontBtn:Boolean;
        private var backBtn:Boolean;
        private var rightBtn:Boolean;
        private var leftBtn:Boolean;
        private var spaceBtn:Boolean;
        private var bullet_flag:Boolean;
        private var game_flag:Boolean=true;
        private var countTimer_flag:Boolean;
        private var countEnemy1_flag:Boolean;
        private var countEnemy2_flag:Boolean;
        private var countEnemy3_flag:Boolean;
        private var countEnemy4_flag:Boolean;
        private var timer3_flag:Boolean;
        private var timer4_flag:Boolean;
        private var item_flag:Boolean;
        private var boss_flag:Boolean;
        private var attack1_flag:Boolean;
        private var attack2_flag:Boolean;
        private var attack3_flag:Boolean;
        private var bullet_mode:int=0;
        private var score:int=0;
        private var boss_life:int=100;
        private var score_text:TextField=new TextField();
        private var score_text_format:TextFormat=new TextFormat();
        private var gameover_text:TextField=new TextField();
        private var gameover_text_format:TextFormat=new TextFormat();
        private var clear_text:TextField=new TextField();
        private var clear_text_format:TextFormat=new TextFormat();
        private var btn:Sprite=new Sprite();
        private var d:int=8;//機体の速度
        private var timer:Timer=new Timer(3000);//3秒に一度発生するイベント
        private var timer2:Timer=new Timer(1700);//
        private var timer3:Timer=new Timer(4600);//
        private var timer4:Timer=new Timer(3750);//
        private var timer_item:Timer=new Timer(5150);//
        private var timer_star:Timer=new Timer(500);//
        private var timeScale:Timer=new Timer(1000);//1秒毎に発生するイベント
        private var timer_boss:Timer=new Timer(60000,1);//最終イベント
        private var timer_bossAttack1:Timer=new Timer(1000);//
        private var timer_bossAttack2:Timer=new Timer(1100);//
        private var timer_bossAttack3:Timer=new Timer(6000);
        private var count:int=0;
        private var enemy_array:Array=new Array();//敵機配列
        private var enemymidium_array:Array=new Array();//敵機配列
        private var enemy_array2:Array=new Array();//敵機配列
        private var item_array:Array=new Array();//アイテム配列
        private var bullet_array:Array=new Array();//弾配列
        private var beam_array1:Array=new Array();//ボス弾１
        private var beam_array2:Array=new Array();//ボス弾2
        private var beam_array3:Array=new Array();//ボス弾3
        private var star_array:Array=new Array();//背景の☆
        private var speed:int=0;


        public function ShootingGame() {
            MainObject();
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeydownHandler);//ボタンを押した時のイベント
            stage.addEventListener(KeyboardEvent.KEY_UP,onKeyupHandler);//ボタン離した時
            addEventListener(Event.ENTER_FRAME,xEnterFrame);//ENTER_FRAMEイベント
            timeScale.addEventListener(TimerEvent.TIMER,timerCount);//秒数カウント
            timer.addEventListener(TimerEvent.TIMER,normalEnemy);//敵出現1
            timer2.addEventListener(TimerEvent.TIMER,normalEnemy2);//敵出現2
            timer3.addEventListener(TimerEvent.TIMER,normalEnemy3);//敵出現3
            timer4.addEventListener(TimerEvent.TIMER,normalEnemy4);//敵出現4
            timer_item.addEventListener(TimerEvent.TIMER,item);//アイテム出現
            timer_star.addEventListener(TimerEvent.TIMER,backGround);//背景表示
            timer_boss.addEventListener(TimerEvent.TIMER,bossBattle);//ボス出現
            timer_bossAttack1.addEventListener(TimerEvent.TIMER,bossAttack1);//ボス攻撃1
            timer_bossAttack2.addEventListener(TimerEvent.TIMER,bossAttack2);//ボス攻撃2
            timer_bossAttack3.addEventListener(TimerEvent.TIMER,bossAttack3);//ボス攻撃3
            timeScale.start();//カウントタイマースタート
            timer.start();//第１敵機スタート
            timer2.start();//第２敵機スタート
        　  timer_item.start();//アイテムスタート
            timer_star.start();//背景スタート
            timer_boss.start();//ボススタート
        }
        private function MainObject():void{
            //自機の作成
            machine.graphics.beginFill(0x00ffff);
            machine.graphics.drawRect(0,0,16,16);
            machine.x=stage.stageWidth/2;
            machine.y=stage.stageHeight-machine.height*2;
            machine.graphics.endFill();
            addChild(machine);
            
            //スコアの作成
            score_text_format.size=16;
            score_text_format.color=0xffffff;
            score_text.x=stage.stageWidth-150;
            score_text.y=stage.stageHeight-20;
            score_text.text="SCORE   "+ score +" POINT";
            score_text.autoSize=TextFieldAutoSize.LEFT;
            score_text.setTextFormat(score_text_format);
            addChild(score_text);
            
            //ゲームオーバーテキスト
            gameover_text_format.size=24;
            gameover_text_format.color=0xffffff;
            gameover_text.x=stage.stageWidth/2-gameover_text.width/2;
            gameover_text.y=stage.stageHeight/2;
            gameover_text.text="REPLAY?";
            gameover_text.autoSize=TextFieldAutoSize.LEFT;
            gameover_text.setTextFormat(gameover_text_format);
            btn.addChild(gameover_text);
            addChild(btn);
            gameover_text.mouseEnabled = false;
            btn.buttonMode=true;
            
            btn.visible=false;
            btn.addEventListener(MouseEvent.CLICK,replayHandler);
            
            //ゲームクリアテキスト
            clear_text_format.size=30;
            clear_text_format.color=0xffffff;
            clear_text.x=stage.stageWidth/2-clear_text.width;
            clear_text.y=stage.stageHeight/4;
            clear_text.text="GAME CLEAR";
            clear_text.autoSize=TextFieldAutoSize.LEFT;
            clear_text.setTextFormat(clear_text_format);
            addChild(clear_text);
            clear_text.visible=false;
            
        }
        
        //キー操作イベント
        private function onKeydownHandler(e:KeyboardEvent):void{
            //上ボタン
            if(e.keyCode==38){
                frontBtn=true;
            }
            //下ボタン
            if(e.keyCode==40){
                backBtn=true;
            }
            //右ボタン
            if(e.keyCode==39){
                rightBtn=true;
            }
            //左ボタン
            if(e.keyCode==37){
                leftBtn=true;
            }
            //スペースキー
            if(e.keyCode==32){
                spaceBtn=true;
            }
        }
        private function onKeyupHandler(e:KeyboardEvent):void{
            if(e.keyCode==38){
                frontBtn=false;
            }
            if(e.keyCode==40){
                backBtn=false;
            }
            if(e.keyCode==39){
                rightBtn=false;
            }
            if(e.keyCode==37){
                leftBtn=false;
            }
            if(e.keyCode==32){
                spaceBtn=false;
                bullet_flag=false;
            }
        }
        private function xEnterFrame(e:Event):void{
            for(var o:int=0;o<star_array.length;o++){
                    star_array[o].y+=2;
                    //画面から外れた背景を取り除く
                    if(star_array[o].y>stage.stageHeight){
                        removeChild(star_array[o]);
                        var remove_star:Array=star_array.splice(o,1);
                    }
            }
    
            if(game_flag==true){
                //上に進む
                if(frontBtn==true&&machine.y>0){
                    machine.y-=d;
                }
                //下に進む
                if(backBtn==true&&machine.y<stage.stageHeight-machine.height){
                    machine.y+=d;
                }
                //右に進む
                if(rightBtn==true&&machine.x<stage.stageWidth-machine.width){
                    machine.x+=d;
                }
                //左に進む
                if(leftBtn==true&&machine.x>0){
                    machine.x-=d;
                }
                //攻撃
                if(spaceBtn==true){
                    if(bullet_flag==false){
                    //弾作成
                        if(bullet_mode==0){
                            var bullet:Sprite=new Sprite();
                            bullet.graphics.beginFill(0x000066);
                            bullet.graphics.drawRect(0,0,4,10);
                            bullet.graphics.endFill();
                            addChild(bullet);
                            bullet_array.push(bullet);
                            bullet.x=machine.x+6;
                            bullet.y=machine.y-machine .height;
                        }
                        if(bullet_mode==1){
                            var bullet2:Sprite=new Sprite();
                            bullet2.graphics.beginFill(0x002288);
                            bullet2.graphics.drawRect(0,0,4,20);
                            bullet2.graphics.endFill();
                            addChild(bullet2);
                            bullet_array.push(bullet2);
                            bullet2.x=machine.x+2;
                            bullet2.y=machine.y-machine .height;
                        }
                        if(bullet_mode==1){
                            var bullet3:Sprite=new Sprite();
                            bullet3.graphics.beginFill(0x002288);
                            bullet3.graphics.drawRect(0,0,4,20);
                            bullet3.graphics.endFill();
                            addChild(bullet3);
                            bullet_array.push(bullet3);
                            bullet3.x=machine.x+10;
                            bullet3.y=machine.y-machine .height;
                            
                        }
                        if(bullet_mode>=2){
                            var bullet4:Sprite=new Sprite();
                            bullet4.graphics.beginFill(0xffff00);
                            bullet4.graphics.drawRect(0,0,6,30);
                            bullet4.graphics.endFill();
                            addChild(bullet4);
                            bullet_array.push(bullet4);
                            bullet4.x=machine.x-8;
                            bullet4.y=machine.y-machine .height;
                        }
                        if(bullet_mode>=2){
                            var bullet5:Sprite=new Sprite();
                            bullet5.graphics.beginFill(0xffff00);
                            bullet5.graphics.drawRect(0,0,6,30);
                            bullet5.graphics.endFill();
                            addChild(bullet5);
                            bullet_array.push(bullet5);
                            bullet5.x=machine.x+5;
                            bullet5.y=machine.y-machine .height;
                        }
                        if(bullet_mode>=2){
                            var bullet6:Sprite=new Sprite();
                            bullet6.graphics.beginFill(0xffff00);
                            bullet6.graphics.drawRect(0,0,6,30);
                            bullet6.graphics.endFill();
                            addChild(bullet6);
                            bullet_array.push(bullet6);
                            bullet6.x=machine.x+machine.width+3;
                            bullet6.y=machine.y-machine .height;
                        }
                        addChild(bullet_array[bullet_array.length-1]);
                        bullet_flag=true;//弾の連射防止
                    }
                }
                //ボスフェードイン
                if(boss.y<=boss.height){
                    boss.y+=1;
                }
                for(var p:int=0;p<beam_array1.length;p++){
                    beam_array1[p].x+=Math.round(Math.random()*30-15);
                    beam_array1[p].y+=Math.round(Math.random()*5+1);
                    //画面から外れた攻撃を取り除く
                    if(beam_array1[p].y>stage.stageHeight){
                        removeChild(beam_array1[p]);
                        var remove_beam1:Array=beam_array1.splice(p,1);
                    //攻撃を受けてしまった時のヒット判定    
                    }else if(beam_array1[p].hitTestObject(machine)){
                        removeChild(beam_array1[p]);
                        remove_beam1=beam_array1.splice(p,1);
                        gameOverEvent();
                    }
                }
                for(var q:int=0;q<beam_array2.length;q++){
                    beam_array2[q].y+=6;
                    if(beam_array2[q].y>stage.stageHeight){
                        removeChild(beam_array2[q]);
                        var remove_beam2:Array=beam_array2.splice(q,1);
                    }else if(beam_array2[q].hitTestObject(machine)){
                        removeChild(beam_array2[q]);
                        remove_beam2=beam_array2.splice(q,1);
                        gameOverEvent();
                    }
                }
                for(var r:int=0;r<beam_array3.length;r++){
                    beam_array3[r].y+=5;
                    if(beam_array3[r]>stage.stageHeight){
                        removeChild(beam_array3[r]);
                        var remove_beam3:Array=beam_array3.splice(r,1);
                    }else if(beam_array3[r].hitTestObject(machine)){
                        removeChild(beam_array3[r]);
                        remove_beam3=beam_array3.splice(r,1);
                        gameOverEvent();
                    }
                }
                
                for(var i:int=0;i<enemy_array.length;i++){
                    enemy_array[i].y+=6;
                    if(enemy_array[i].y>stage.stageHeight){
                        removeChild(enemy_array[i]);
                        var remove_enemy:Array=enemy_array.splice(i,1);
                    }
                    else if(enemy_array[i].hitTestObject(machine)){
                        removeChild(enemy_array[i]);
                        remove_enemy=enemy_array.splice(i,1);
                        gameOverEvent()
                    }
            
                }
                for(var t:int=0;t<enemy_array2.length;t++){
                    enemy_array2[t].x+=Math.round(Math.random()*60-30);
                    enemy_array2[t].y+=Math.round(Math.random()*20-5);
                    if(enemy_array2[t].y>stage.stageHeight){
                        removeChild(enemy_array2[t]);
                        var remove_enemy2:Array=enemy_array2.splice(t,1);
                    }
                    else if(enemy_array2[t].hitTestObject(machine)){
                        removeChild(enemy_array2[t]);
                        remove_enemy2=enemy_array2.splice(t,1);
                        gameOverEvent()
                    }
            
                }
                for(var k:int=0;k<enemymidium_array.length;k++){
                    speed+=21;
                    var rad:int=speed*Math.PI/180;
                    enemymidium_array[k].y+=10;
                    enemymidium_array[k].x+=Math.cos(rad)*10
                    if(enemymidium_array[k].y>stage.stageHeight){
                        removeChild(enemymidium_array[k]);
                        var remove_enemymidium:Array=enemymidium_array.splice(k,1);
                    }
                    else if(enemymidium_array[k].hitTestObject(machine)){
                        removeChild(enemymidium_array[k]);
                        remove_enemymidium=enemymidium_array.splice(k,1);
                        gameOverEvent()
                    }
            
                }
                if(boss.hitTestObject(machine)){
                    gameOverEvent();
                }
                for(var m:int=0;m<item_array.length;m++){
                    item_array[m].y+=4;
                    if(item_array[m].y>stage.stageHeight){
                        //画面から外れたアイテムを取り除く
                        removeChild(item_array[m]);
                        var remove_item:Array=item_array.splice(m,1);
                    }
                    else if(item_array[m].hitTestObject(machine)){
                        trace("overRide!!");
                    　　//アイテムゲット
                        bullet_mode+=1;
                        removeChild(item_array[m]);
                        remove_item=item_array.splice(m,1);
                        
                        
                    }
            
                }
                for(i=0; i<bullet_array.length; i++){
                    bullet_array[i].y-=10;
                    if(bullet_array[i].y<-50){
                        removeChild(bullet_array[i]);
                        var remove_bullet:Array=bullet_array.splice(i,1);
                    }else if(boss.hitTestObject(bullet_array[i])){
                        removeChild(bullet_array[i]);
                        remove_bullet=bullet_array.splice(i,1);
                        if(boss.y>boss.height){
                            trace(boss_life);
                            boss_life-=1;
                            Tweener.addTween(boss,{alpha:0,time:0.1});
                            Tweener.addTween(boss,{alpha:1,time:0.1,delay:0.1});
                            if(boss_life<=0){
                                Tweener.addTween(boss,{alpha:0,time:0.1});
                                Tweener.addTween(boss,{alpha:1,time:0.1,delay:0.1});
                                Tweener.addTween(boss,{alpha:0,time:0.1,delay:0.2});
                                Tweener.addTween(boss,{alpha:1,time:0.1,delay:0.3});
                                Tweener.addTween(boss,{alpha:0,time:0.5,delay:0.4,onComplete:gameClear});
                            }
                        }
                    }
                }
                
                //ヒット判定
                loop:for(i=0;i<enemy_array.length;i++){
                    for(var j:int=0; j<bullet_array.length; j++){
                        if(enemy_array[i].hitTestObject(bullet_array[j])){
                            trace("Hit!!");
                            //ヒットした敵機と弾を取り除く
                            removeChild(bullet_array[j]);
                            removeChild(enemy_array[i]);
                            remove_bullet=bullet_array.splice(j,1);
                            remove_enemy=enemy_array.splice(i,1);
                            score++;
                            break loop;//loopを停止
                        }
                    }
                }
                loop2:for(k=0;k<enemymidium_array.length;k++){
                    for(var l:int=0; l<bullet_array.length; l++){
                         if(enemymidium_array[k].hitTestObject(bullet_array[l])){
                            trace("Hit!!");
                            //ヒットした敵機と弾を取り除く
                            removeChild(bullet_array[l]);
                            removeChild(enemymidium_array[k]);
                            remove_bullet=bullet_array.splice(l,1);
                            remove_enemymidium=enemymidium_array.splice(k,1);
                            score++;
                            break loop2;//loopを停止
                        }
                    }
                }
                loop3:for(t=0;t<enemy_array2.length;t++){
                    for(var u:int=0; u<bullet_array.length; u++){
                         if(enemy_array2[t].hitTestObject(bullet_array[u])){
                            trace("Hit!!");
                            //ヒットした敵機と弾を取り除く
                            removeChild(bullet_array[u]);
                            removeChild(enemy_array2[t]);
                            remove_bullet=bullet_array.splice(u,1);
                            remove_enemy2=enemy_array2.splice(t,1);
                            score++;
                            break loop3;//loopを停止
                        }
                    }
                }
                score_text.text="SCORE   "+ score +" POINT";
                score_text.autoSize=TextFieldAutoSize.LEFT;
                score_text.setTextFormat(score_text_format);
            }
        }
        private function backGround(e:TimerEvent):void{
            for(var i:int=0;i<2;i++){
                var star:Sprite=new Sprite();
                star.graphics.beginFill(0x888888);
                star.graphics.drawCircle(0,0,2 );
                star.graphics.endFill();
                star.x=Math.floor(Math.random()*(465-star.width));
                star.alpha=0.3;
                addChild(star);
                star_array.push(star);
                addChild(star_array[star_array.length-1]);
            }
        }
        private function timerCount(e:TimerEvent):void{
            count++;
            trace(count);
            trace(e.target.currentCount);
            if(countTimer_flag==true){
                timeScale.reset();
                count=0;
            }else if(count==20){
                timer3_flag=true;
            }else if(count==40){
                timer4_flag=true;
            }
        }
        private function normalEnemy(e:TimerEvent):void{
            
            trace("getEnemy");
            //敵機作成
            for(var i:int=0;i<Math.random()*4;i++){
                var enemy:Sprite=new Sprite();
                enemy.graphics.beginFill(0x660000);
                enemy.graphics.drawRect(0,0,30,10);
                enemy.graphics.endFill();
                addChild(enemy);
                //敵機を配列に
                enemy_array.push(enemy);
                enemy_array[enemy_array.length-1].x=Math.floor(Math.random()*(465-enemy.width));
                enemy_array[enemy_array.length-1].y=Math.floor(Math.random()*200-200);        
                addChild(enemy_array[enemy_array.length-1]);
                if(countEnemy1_flag==true){
                    timer.reset();
                }
            } 
            for(var j:int=0;j<Math.random()*2;j++){
                var enemy6:Sprite=new Sprite();
                enemy6.graphics.beginFill(0xffb6c1);
                enemy6.graphics.drawRect(0,0,24,7);
                enemy6.graphics.endFill();
                addChild(enemy6);
                //敵機を配列に
                enemy_array2.push(enemy6);
                enemy_array2[enemy_array2.length-1].x=Math.floor(Math.random()*(465-enemy6.width));
                enemy_array2[enemy_array2.length-1].y=Math.floor(Math.random()*200-200);        
                addChild(enemy_array2[enemy_array2.length-1]);
                if(countEnemy1_flag==true){
                    timer.reset();
                }
            } 
        }
        private function normalEnemy2(e:TimerEvent):void{
            
            trace("getEnemy2");
            //敵機作成
            for(var i:int=0;i<Math.random()*2;i++){
                var enemy2:Sprite=new Sprite();
                enemy2.graphics.beginFill(0x335511);
                enemy2.graphics.drawRect(0,0,32,20);
                enemy2.graphics.endFill();
                addChild(enemy2);
                //敵機を配列に
                enemy_array2.push(enemy2);
                enemy_array2[enemy_array2.length-1].x=Math.floor(Math.random()*(465-enemy2.width));
                enemy_array2[enemy_array2.length-1].y=Math.floor(Math.random()*200-200);        
                addChild(enemy_array2[enemy_array2.length-1]);
                if(countEnemy2_flag==true){
                    timer2.reset();
                }
            }
            for(var j:int=0;j<Math.random()*4;j++){
                var enemy5:Sprite=new Sprite();
                enemy5.graphics.beginFill(0xf0f8ff);
                enemy5.graphics.drawRect(0,0,40,35);
                enemy5.graphics.endFill();
                addChild(enemy5);
                //敵機を配列に
                enemy_array.push(enemy5);
                enemy_array[enemy_array.length-1].x=Math.floor(Math.random()*(465-enemy5.width));
                enemy_array[enemy_array.length-1].y=Math.floor(Math.random()*200-200);        
                addChild(enemy_array[enemy_array.length-1]);
                if(countEnemy2_flag==true){
                    timer2.reset();
                }
            }
        }
        private function normalEnemy3(e:TimerEvent):void{
            if(timer3_flag==true){
                trace("getEnemy3");
                //敵機作成
                for(var i:int=0;i<Math.random()*4+1;i++){
                    var enemy3:Sprite=new Sprite();
                    enemy3.graphics.beginFill(0x003377);
                    enemy3.graphics.drawRect(0,0,20,25);
                    enemy3.graphics.endFill();
                    enemy3.x=Math.floor(Math.random()*(465-enemy3.width));
                    addChild(enemy3);
                    //敵機を配列に
                    enemymidium_array.push(enemy3);
                    enemymidium_array[enemymidium_array.length-1].x=Math.floor(Math.random()*(465-enemy3.width));
                    enemymidium_array[enemymidium_array.length-1].y=Math.floor(Math.random()*200-200);        
                    addChild(enemymidium_array[enemymidium_array.length-1]);　　
                    if(countEnemy3_flag==true){
                        timer3.reset();
                    }
                }
            }
        }
        private function normalEnemy4(e:TimerEvent):void{
            if(timer4_flag==true){
                trace("getEnemy4");
                //敵機作成
                for(var i:int=0;i<Math.random()*4+1 ;i++){
                    var enemy4:Sprite=new Sprite();
                    enemy4.graphics.beginFill(0xff4500);
                    enemy4.graphics.drawRect(0,0,15,20);
                    enemy4.graphics.endFill();
                    enemy4.x=Math.floor(Math.random()*(465-enemy4.width));
                    addChild(enemy4);
                    //敵機を配列に
                    enemy_array2.push(enemy4);
                    enemy_array2[enemy_array2.length-1].x=Math.floor(Math.random()*(465-enemy4.width));
                    enemy_array2[enemy_array2.length-1].y=Math.floor(Math.random()*200-200);        
                    addChild(enemy_array2[enemy_array2.length-1]);
                    if(countEnemy4_flag==true){
                        timer4.reset();
                    }
                }
            }
        }
        private function item(e:TimerEvent):void{
            
            trace("getItem");
            //アイテム作成
            var item:Sprite=new Sprite();
            item.graphics.beginFill(0x883388);
            item.graphics.drawCircle(0,0,10);
            item.graphics.endFill();
            addChild(item);
            //アイテムを配列に
            item_array.push(item);
            item_array[item_array.length-1].x=Math.floor(Math.random()*(465-item.width));
            item_array[item_array.length-1].y=-20;
            addChild(item_array[item_array.length-1]);
            if(item_flag==true){
                timer_item.reset();
            }
        }
        private function bossBattle(e:TimerEvent):void{
            trace("boss")
            boss.graphics.beginFill(0xff0000);
            boss.graphics.drawRect(0,0,200,50);
            boss.graphics.endFill();
            boss.x=stage.stageWidth/2-boss.width/2;
            boss.y=0-boss.height;
            addChild(boss);
            boss.alpha=1;
            timer.stop();
            timer2.stop();
            timer3.stop();
            timer4.stop();
            timer_item.stop();
            countTimer_flag=true;
            countEnemy1_flag=true;
            countEnemy2_flag=true;
            countEnemy3_flag=true;
            countEnemy4_flag=true;
            item_flag=true;
            
            timer_bossAttack1.start();
            timer_bossAttack2.start();
            timer_bossAttack3.start();
            
            if(boss_flag==false){
                trace("boss_reset")
                timer_boss.reset();
                
            }
            
        }
        private function bossAttack1(e:TimerEvent):void{
            for(var i:int=0;i<2;i++){
                var boss_beam1:Sprite=new Sprite();
                boss_beam1.graphics.beginFill(0xc71585);
                boss_beam1.graphics.drawCircle(0,0,4);
                boss_beam1.graphics.endFill();
                boss_beam1.x=Math.round(Math.random()*800-400);
                boss_beam1.y=boss.y+boss.height;
                addChild(boss_beam1);
                beam_array1.push(boss_beam1);
                addChild(beam_array1[beam_array1.length-1]);
                
            }
            if(attack1_flag==true){
                timer_bossAttack1.reset();
            }
        }
        private function bossAttack2(e:TimerEvent):void{
            for(var i:int=0; i<3;i++){
                var boss_beam2:Sprite=new Sprite();
                boss_beam2.graphics.beginFill(0xfffacd);
                boss_beam2.graphics.drawRect(0,0,2,30);
                boss_beam2.graphics.endFill();
                boss_beam2.x=Math.round(Math.random()*800-400);
                boss_beam2.y=boss.y+boss.height;
                addChild(boss_beam2);
                beam_array2.push(boss_beam2);
                addChild(beam_array2[beam_array2.length-1]);
            }
            if(attack2_flag==true){
                timer_bossAttack2.reset();
            }
            
        }
        private function bossAttack3(e:TimerEvent):void{
            var boss_beam3:Sprite=new Sprite();
            boss_beam3.graphics.beginFill(0x708090);
            boss_beam3.graphics.drawRect(0,0,150,150);
            boss_beam3.graphics.endFill();
            boss_beam3.x=stage.stageWidth/2-boss_beam3.width/2;
            boss_beam3.y=boss.y+boss.height;
            addChild(boss_beam3);
            beam_array3.push(boss_beam3);
            addChild(beam_array3[beam_array3.length-1]);
            
            if(attack2_flag==true){
                timer_bossAttack2.reset();
            }
        }
        private function gameOverEvent():void{
            //自機の消滅＆ゲームオーバー
            removeChild(machine);
            if(addChild(boss)){
                removeChild(boss);
            }
            game_flag=false;
            btn.visible=true;
            while (bullet_array.length > 0) {
                removeChild (bullet_array[bullet_array.length -1]);
                bullet_array.pop ();
            }
            while (enemy_array.length > 0) {
                removeChild (enemy_array[enemy_array.length -1]);
                enemy_array.pop ();
            }
            while (enemymidium_array.length > 0) {
                removeChild (enemymidium_array[enemymidium_array.length -1]);
                enemymidium_array.pop ();
            }
            while (enemy_array2.length > 0) {
                removeChild (enemy_array2[enemy_array2.length -1]);
                enemy_array2.pop ();
            }
            while (item_array.length > 0) {
                removeChild (item_array[item_array.length -1]);
                item_array.pop ();
            }
            while (beam_array1.length > 0) {
                removeChild (beam_array1[beam_array1.length -1]);
                beam_array1.pop ();
            }
            while (beam_array2.length > 0) {
                removeChild (beam_array2[beam_array2.length -1]);
                beam_array2.pop ();
            }
            while (beam_array3.length > 0) {
                removeChild (beam_array3[beam_array3.length -1]);
                beam_array3.pop ();
            }
            countFlagEvent();//タイマーリセットのイベント
        
        }
        private function replayHandler(e:MouseEvent):void{
            game_flag=true;
            btn.visible=false;
            score=0;
            machine.x=stage.stageWidth/2;
            machine.y=stage.stageHeight-machine.height*2;
            addChild(machine);
            clear_text.visible=false;
            bullet_array.push ();
            timeScale.start();
            timer.start();
            timer2.start();
            timer3.start();
            timer4.start();
            timer_item.start();
            timer_boss.start();
            countTimer_flag=false;
            countEnemy1_flag=false;
            countEnemy2_flag=false;
            countEnemy3_flag=false;
            countEnemy4_flag=false;
            attack1_flag=false;
            attack2_flag=false;
            attack3_flag=false;
            item_flag=false;
            boss_flag=false;
            bullet_mode=0;
            
        }
        private function countFlagEvent():void{
            timer.stop();
            timer2.stop();
            timer3.stop();
            timer4.stop();
            timer_item.stop();
            timer_boss.stop();
            timer_bossAttack1.stop();
            timer_bossAttack2.stop();
            timer_bossAttack3.stop();
            countTimer_flag=true;
            countEnemy1_flag=true;
            countEnemy2_flag=true;
            countEnemy3_flag=true;
            countEnemy4_flag=true;
            attack1_flag=true;
            attack2_flag=true;
            attack3_flag=true;
            item_flag=true;
            timer3_flag=false;
            timer4_flag=false;
        }
        private function gameClear():void{
            clear_text.visible=true;
            btn.visible=true;
            boss_life=100;
            removeChild(machine);
            removeChild(boss);
            countFlagEvent();
        }
    }
}
