/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lo0O
 */

package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import com.bit101.components.HUISlider;
 
	public class Main extends Sprite
	{
		private var bitmap:Bitmap;
		private var point:Point = new Point();
 
		public function Main()
		{
			var slider:HUISlider = new HUISlider(this, 132, 400, "Frame Rate",
			function():void
			{
				stage.frameRate = slider.value;
			});
			slider.value = 30;
			slider.minimum = 1;
			slider.maximum = 60;
 
			// 適当な設定で
			var bd:BitmapData = new BitmapData(100, 100, false, 0xED1A3D);
			bitmap = new Bitmap(bd);
			addChild(bitmap);
 
			// マウスボタンが押されたら、onMouseDown()を呼び出す - ドラッグ開始
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
 
			// マウスボタンが離されたら、onMouseUp()を呼び出す - ドラッグ終了
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
 
		private function onMouseDown(event:MouseEvent):void
		{
			// クリックした地点にbitmapが無かったら処理終了
			if (!bitmap.hitTestPoint(mouseX, mouseY)) return;
 
			// ローカル座標を取得
			point = bitmap.globalToLocal(new Point(mouseX, mouseY));
 
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private function onMouseUp(event:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private function onMouseMove(event:MouseEvent):void
		{
			bitmap.x = mouseX - point.x;
			bitmap.y = mouseY - point.y;
		}
	}
}
