/**
 * Copyright awef ( http://wonderfl.net/user/awef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lnJk
 */


package
{
    import flash.events.Event;
    import flash.display.Sprite;
    
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2World;
    
    [SWF(backgroundColor="#FFFFFF", frameRate="60")]
    
    public class main extends Sprite
    {
        private var world : b2World;
        
        public function main()
        {
            var worldAABB : b2AABB = new b2AABB();
            
            worldAABB.lowerBound.Set(-50, -50);
            worldAABB.upperBound.Set(50, 50);
            
            var gravity : b2Vec2 = new b2Vec2(0, 10);
            
            world = new b2World(worldAABB, gravity, true);
            
            // 板
            var floorBodyDef : b2BodyDef = new b2BodyDef();
            floorBodyDef.position.Set(25, 40);
            
            var floorShapeDef : b2PolygonDef = new b2PolygonDef();
            floorShapeDef.SetAsBox(10, 1);
            
            var floor : b2Body = world.CreateBody(floorBodyDef);
            floor.CreateShape(floorShapeDef);
            
            // 箱
            
            var bodyDef : b2BodyDef;
            var shapeDef : b2PolygonDef;
            var body : b2Body;
            
            for(var i : uint = 0; i < 10; i++)
            {
                bodyDef = new b2BodyDef();
                bodyDef.position.Set(24 + Math.random() * 2, i);
                
                shapeDef  = new b2PolygonDef();
                shapeDef.SetAsBox(1, 1);
                shapeDef.density = 1;
                shapeDef.restitution = 0.2;
                
                body = world.CreateBody(bodyDef);
                body.CreateShape(shapeDef);
                body.SetMassFromShapes();
            }
            
            // 描写設定
            var debugDraw : b2DebugDraw = new b2DebugDraw();
            debugDraw.m_sprite = this;
            debugDraw.m_drawScale = 9;
            debugDraw.m_fillAlpha = 0.3;
            debugDraw.m_lineThickness = 1;
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
            world.SetDebugDraw(debugDraw);
            
            
            stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(e : Event) : void
        {
            world.Step(1 / 60, 10);
        }
    }
}
