/**
 * Copyright simultechnology ( http://wonderfl.net/user/simultechnology )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lnCj
 */

package
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	public class BitMapStar extends Sprite
	{
		private var _starList:Array = new Array();
		private var _rotationList:Array = new Array();
		
		public function BitMapStar()
		{
			this.addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);

		}
		
		private function init(e:Event):void
		{
			this.removeEventListener(Event.ADDED_TO_STAGE, init, false);
			createStar(200, 200, 50);
			
			this.stage.addEventListener(MouseEvent.CLICK, goToCreateStar, false, 0, true);
			
			addEventListener(Event.ENTER_FRAME, rotate, false, 0, true);
		}
		
		private function goToCreateStar(e:MouseEvent):void
		{
			createStar(mouseX, mouseY, 100 * (Math.random() * 0.9 + 0.1));
		}
		
		private function createStar(x:int, y:int, radius:int):void
		{	
			// 色の生成
			var color:uint = (Math.random() * 0.9 + 0.1) * 0xFFFFFF;
			var star:Shape = new Shape();
			//var bmd:BitmapData = new BitmapData(100, 100, true, 0x50FFFFFF);
			//var bm:Bitmap = new Bitmap(bmd);
			//star.graphics.beginBitmapFill(bmd);
			star.graphics.beginFill(color);
			var i:int;
			star.graphics.lineStyle(10, color);
			star.x = x;
			star.y = y;
			
			star.graphics.moveTo(radius * Math.cos(72 * Math.PI / 180), radius * Math.sin(72 * Math.PI / 180));
			// 順番に角度72の倍数ずつ、順番に頂点をずらしていくと正五角形になるが、ここで欲しいのは
			// 星型なので、頂点を一つ飛ばしでラインを書いていく。なのでfor文のインクリメントは2の倍数
			for (i = 1; i < 6; i ++)
			{
				star.graphics.lineTo(radius * Math.cos((72 + 144 * i) * Math.PI / 180 ), radius * Math.sin((72 + 144 * i) * Math.PI / 180));
			}

			star.graphics.moveTo(radius * Math.cos((36 + 72*i) * Math.PI / 180 ) / 3, radius * Math.sin((36 + 72*i) * Math.PI / 180) / 3);
			for (i = 1; i < 6; i ++)
			{
				star.graphics.lineTo(radius * Math.cos((36 + 72*i) * Math.PI / 180 ) / 3, radius * Math.sin((36 + 72*i) * Math.PI / 180) / 3);
			}

			// 回転度数を設定（-5度 ～ 5度）
			this._rotationList.push(Math.random() >= 0.5 ? (Math.random() * 0.9 + 0.1) * 5 : (Math.random() * -0.9 - 0.1) * 5);
			_starList.push(star);
			
			this.stage.addChild(star);
		}
		
		private function rotate(e:Event):void
		{
			//forで毎回lengthをとりに行くのは高コストなので、
			//一回ですむようにする。
			var len:int = this._starList.length;
			for (var i:int = 0; i < len; i++) {
				this._starList[i].rotation += this._rotationList[i];
			}
		}
	}
}