/**
 * Copyright djakarta_trap ( http://wonderfl.net/user/djakarta_trap )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lnCU
 */

// forked from ProjectNya's ドット (2)
////////////////////////////////////////////////////////////////////////////////
// ドット (2)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.system.Security;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var base:Sprite;
        private var canvas:BitmapData;
        private var dots:Array;
        private var itween:ITween;
        private var filePath:String = "http://www.project-nya.jp/images/flash/piyo.png";
		private var console:TextField;
		private var tweens:Array;

        public function Main() {
            Wonderfl.capture_delay(8);
            init();
        }

        private function init():void {
            Security.allowDomain("www.project-nya.jp");
            Security.loadPolicyFile("http://www.project-nya.jp/crossdomain.xml");
            base = new Sprite();
            base.graphics.beginFill(0x000000);
            base.graphics.drawRect(0, 0, 465, 465);
            base.graphics.endFill();
            addChild(base);
            canvas = new BitmapData(465, 465, false, 0xFF000000);
            var bitmap:Bitmap = new Bitmap(canvas);
            addChild(bitmap);
            var loader:Loader=new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(filePath));
			
			console = new TextField();
			console.autoSize = TextFieldAutoSize.LEFT;
			console.defaultTextFormat = new TextFormat("_sans", 12, 0xffffff);
			addChild(console);
        }
        private function complete(evt:Event):void {
            var content:Bitmap = evt.target.content;
            content.x = int((465 - content.width)/2);
            content.y = int((465 - content.height) / 2);
			
			console.appendText("load complete \n")
            initialize(content);
        }
        private function initialize(bitmap:Bitmap):void {
            var bitmapData:BitmapData = bitmap.bitmapData;
            dots = new Array();
            tweens = new Array();
            for (var y:uint = 0; y < bitmapData.height; y++) {
                for (var x:uint = 0; x < bitmapData.width; x++) {
                    var tx:uint = x + bitmap.x;
                    var ty:uint = y + bitmap.y;
                    var dot:Dot = new Dot(tx, ty);
                    var color:uint = bitmapData.getPixel(x, y);
                    dot.color = color;
                    dots.push(dot);
                    var sx:uint = uint(Math.random()*800) - 400 + 232;
                    var sy:uint  = uint(Math.random()*800) - 400 + 232;
                    var tween:ITween = BetweenAS3.tween(dot, { x: dot.tx, y: dot.ty }, { x: sx, y: sy }, 2, Quad.easeOut);
					tween.onUpdate = function():void { canvas.setPixel(dot.x, dot.y, dot.color); };
                    tweens.push(tween);
                }
            }
            itween = BetweenAS3.parallelTweens(tweens);
            base.buttonMode = true;
            base.addEventListener(MouseEvent.CLICK, click, false, 0, true);
        }
        private function click(evt:MouseEvent):void {
            base.mouseEnabled = false;
            base.useHandCursor = false;
            start();
        }
        private function start():void {
            itween.addEventListener(TweenEvent.UPDATE, update, false, 0, true);
            itween.addEventListener(TweenEvent.COMPLETE, stop, false, 0, true);
            itween.play();
        }
        private function stop(evt:TweenEvent):void {
            evt.target.removeEventListener(TweenEvent.UPDATE, update);
            evt.target.removeEventListener(TweenEvent.COMPLETE, stop);
            base.mouseEnabled = true;
            base.useHandCursor = true;
        }
        private function update(evt:Event):void {
            canvas.lock();
            canvas.fillRect(canvas.rect, 0xFF000000);
            for (var n:uint = 0; n < dots.length; n++) {
                var dot:Dot = dots[n];
                canvas.setPixel(dot.x, dot.y, dot.color);
            }
            canvas.unlock();
        }

    }

}


//////////////////////////////////////////////////
// Dotクラス
//////////////////////////////////////////////////

class Dot {
    public var x:Number = 0;
    public var y:Number = 0;
    public var tx:int = 0;
    public var ty:int = 0;
    public var color:uint;

    public function Dot(x:int, y:int) {
        tx = x;
        ty = y;
    }

}
