/**
 * Copyright smallwind1912 ( http://wonderfl.net/user/smallwind1912 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lmEj
 */

// forked from ProjectNya's EmitLight (6)
// forked from Event's Instrument

////////////////////////////////////////////////////////////////////////////////
// EmitLight (6)
//
// 音はTsabeat より拝借
// http://www.ektoplazm.com/free-music/tsabeat-warp-speed-ep/
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.geom.Rectangle;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var light:EmitLight;

        public function Main() {
            //Wonderfl.capture_delay(4);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            light = new EmitLight(rect);
            addChild(light);
        }

    }

}


//////////////////////////////////////////////////
// EmitLightクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.display.BlendMode;
import flash.filters.BlurFilter;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.media.SoundMixer;
import flash.utils.ByteArray;
import flash.net.URLRequest;
import flash.system.Security;
import frocessing.color.ColorHSV;

class EmitLight extends Sprite {
    private var rect:Rectangle;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var container:Sprite;
    private static var max:uint = 4;
    private var particles:Array;
    private var color:ColorHSV;
    private var colorTrans:ColorTransform;
    private static var blur:BlurFilter;
    private static var point:Point = new Point();
    private var id:uint = 0;
    private static var policyPath:String = "http://mutast.heteml.jp/crossdomain.xml";
    private var sound:Sound;
    private var channel:SoundChannel;
    private static var soundPath:String = "http://mutast.heteml.jp/works/music/music.mp3";
    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private var factors:uint = 0;
    private static var radian:Number = Math.PI/180;
    private static var radius:uint = 128;

    public function EmitLight(r:Rectangle) {
        rect = r;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        container = new Sprite();
        addChild(container);
        particles = new Array();
        color = new ColorHSV(0);
        colorTrans = new ColorTransform();
        blur = new BlurFilter(8, 8, 3);
        //
        Security.loadPolicyFile(policyPath);
        sound = new Sound();
        sound.addEventListener(Event.COMPLETE, loaded, false, 0, true);
        sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        byteArray = new ByteArray();
    }
    private function loaded(evt:Event):void {
        evt.target.removeEventListener(Event.COMPLETE, loaded);
        start();
    }
    private function start():void {
        channel = sound.play(0, 1000);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function update(evt:Event):void {
        SoundMixer.computeSpectrum(byteArray, false, factors);
        var units:Array = new Array();
        for (var c:uint = 0; c < 2; c++) {
            units[c] = new Array();
            for (var n:uint = 0; n < channels; n++) {
                var p:Number = byteArray.readFloat();
                if (n%32 == 0) units[c].push(p);
            }
        }
        create(units);
        draw();
    }
    private function draw():void {
        bitmapData.lock();
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:Particle = particles[n];
            particle.update();
            particle.scale = particle.alpha = particle.power;
            if (particle.power < 0) {
                container.removeChild(particle);
                particles.splice(n, 1);
                particle = null;
            }
        }
        color.h = id;
        colorTrans.color = color.value;
        bitmapData.draw(container, null, colorTrans, BlendMode.SCREEN, null, true);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
        id ++;
    }
    private function create(units:Array):void {
        for (var c:uint = 0; c < 2; c++) {
            var unit:Array = units[c];
            for (var n:uint = 0; n < max; n++) {
                var particle:Particle = new Particle();
                var u:Number = unit[n];
                var p:Number;
                if (c > 0) {
                    p = - u*180 + 90;
                } else {
                    p = u*180 + 90;
                }
                var r:Number = radius*(1 + u)*0.8;
                particle.tx = 232 + r*Math.cos(p*radian);
                particle.ty = 242 + r*Math.sin(p*radian);
                particle.angle = Math.random()*360;
                particle.speed = Math.random()*3 + 5;
                particle.power = 1;
                particle.setup();
                container.addChild(particle);
                particles.push(particle);
            }
        }
    }

}


//////////////////////////////////////////////////
// Particleクラス
//////////////////////////////////////////////////

import flash.display.Shape;

class Particle extends Shape {
    private static var radius:uint = 6;
    private static var color:uint = 0xFFFFFF;
    public var angle:Number = 0;
    public var speed:Number = 0;
    public var tx:Number;
    public var ty:Number;
    private var vx:Number = 0;
    private var vy:Number = 0;
    public var power:Number = 0;
    private static var radian:Number = Math.PI/180;
    private static var friction:Number = 0.96;
    private static var deceleration:Number = 0.016;
    private static var acceleration:Number = 0.02;
    private var _scale:Number = 1;

    public function Particle() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function setup():void {
        x = tx;
        y = ty;
        vx = speed*Math.cos(angle*radian);
        vy = speed*Math.sin(angle*radian);
    }
    public function update():void {
        tx += vx;
        ty += vy;
        x += (tx - x)*acceleration;
        y += (ty - y)*acceleration;
        vx *= friction;
        vy *= friction;
        power -= deceleration;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}
