/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lmCh
 */

// やっぱり描画処理が重い…

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
     import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.materials.special.BitmapParticleMaterial

    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]

    public class Main extends Sprite {
        
        private var _w:int = stage.stageWidth;
        private var _h:int = stage.stageHeight;
        
        //
        private var _world:Sprite = new Sprite()
        private var _scene:Scene3D;
        private var _rootNode:DisplayObject3D;
        private var _camera:Camera3D;
        private var _viewport:Viewport3D;
        private var _renderer:BasicRenderEngine;
        private var _cube:Cube
        private var _sphere:Sphere

        private var _vpX:Number;
        private var _vpY:Number;
        private var _angle:Number;
        
        private var _isDragging:Boolean
        private var _currentMouseX:Number = 0
        private var _currentMouseY:Number = 0

        private var _container:Sprite = new Sprite()
        private var _bmd:BitmapData = new BitmapData(640, 480, false, 0)
        
        private var _cam:CameraCapture
        
        public function Main () {
            _world.blendMode = "add"
            _cam = new CameraCapture(640, 480, 30)
            _container.addChild(_cam)
            addChild(_container)
            addChild(_world)
            //
            init3D();
            //
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown)
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp)
            stage.addEventListener(Event.ENTER_FRAME, update)
        }
        
        private function init3D():void {
            initStage();
            initScene();
            initCamera();
            initDO3D();
            //
            _renderer.renderScene(_scene, _camera, _viewport);
        }
        
        private function initStage():void {
            _w = stage.stageWidth;
            _h = stage.stageHeight;
            _vpX = _w / 2;
            _vpY = _w / 2;
        }
        
        private function initScene():void{
            _renderer = new BasicRenderEngine();
            _scene = new Scene3D();
            _viewport  = new Viewport3D(0, 0, true, true);
            _world.addChild(_viewport);
        }
        
        private function initCamera():void {
            _camera = new Camera3D();
            _camera.x = 0;
            _camera.y = 0;
            _camera.z = -900;
            _camera.zoom = 30;
            _camera.focus = 30;
            _camera.target = DisplayObject3D.ZERO;
        }
        
        private function initDO3D():void {
            var particleMat:BitmapParticleMaterial = new BitmapParticleMaterial(_bmd)
            var particles:ParticleField = new ParticleField(particleMat, 300, 0.125, 2000, 2000, 2000)
            _rootNode = new DisplayObject3D();
            _sphere  = new Sphere(new BitmapMaterial(_bmd), 180, 32, 24)
            _scene.addChild(_rootNode);  
            _rootNode.addChild(_sphere);          
            _rootNode.addChild(particles);
        }
    
        private function update(e:Event):void { 
            var X:Number = mouseX - _currentMouseX
            var Y:Number = mouseY - _currentMouseY
            if(_isDragging) {
                _sphere.rotationY -= X/2
                _sphere.rotationX += Y/2
                _currentMouseX = mouseX;
                _currentMouseY = mouseY;
                _camera.x -= X*2
                _camera.y += Y*2
                _currentMouseX = mouseX;
                _currentMouseY = mouseY;
                
            }
            _sphere.rotationY -= 0.5
            _rootNode.rotationY+=.5;
            _rootNode.rotationX+=.3;
            _rootNode.rotationZ+=.1;
            _bmd.lock();
            _bmd.draw(_container)
            _bmd.unlock();
            _renderer.renderScene(_scene, _camera, _viewport);
        }
        
        private function onDown(e:MouseEvent):void {
            _isDragging = true;
            _currentMouseX = mouseX;
            _currentMouseY = mouseY;
        }
        
        private function onUp(e:MouseEvent):void {
            _isDragging = false;
        }
    }
}


import flash.events.ActivityEvent;
import flash.events.Event;
import flash.media.Camera;
import flash.display.Sprite;
import flash.media.Video;

class CameraCapture extends Video{
    private var _cam:Camera;
    private var _camW:Number
    private var _camH:Number
    private var _fps:Number
    private var _activityThreshold:Number
    private var _actLevel:int
    public static const ACTIVE:String = "active"
    public static const INACTIVE:String = "inactive"

    public function CameraCapture(camW:Number, camH:Number, fps:Number=30, activityThreshold:Number=10) {
        this.width = camW
        this.height = camH
        _camW = camW
        _camH = camH
        _fps = fps
        _activityThreshold = activityThreshold
        setUpCamera();
    }

    private function setUpCamera():void {
        _cam = Camera.getCamera();
        _cam.setMode(_camW, _camH, _fps);
        this.attachCamera(_cam);
        _cam.addEventListener(ActivityEvent.ACTIVITY, CamActivityCheck);
    }
        
    private function CamActivityCheck(e:ActivityEvent):void {
        if (_cam.activityLevel >= _activityThreshold) {
            dispatchEvent(new Event(CameraCapture.ACTIVE))
        } else {
            dispatchEvent(new Event(CameraCapture.INACTIVE))
        }
        _actLevel = _cam.activityLevel
    }
        
    public function get actLevel():Number{
        return _actLevel
    }
        
}