/**
 * Copyright Matt_Wakeling ( http://wonderfl.net/user/Matt_Wakeling )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/llpL
 */

package 
{
    // Import External Classes
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
        
    
    // Reconfigure Stage Properties
    [SWF(width='465',height='465',backgroundColor='#000000',frameRate='30')]
    
    /**
    * Name           : Main 
    * Coded By       : Matt Wakeling
    * Date           : 29th April 2012
    * Description    : Main Class for the Application.
    *                  Simple Stars using Polar Coordinates.
    *
    * @author Matt Wakeling
    */
    public class Main extends Sprite 
    {
        // Main Constructor
        public function Main()
        {
            // Constructor Code
            super();
            InitialiseMain();
        }

        // InitialiseMain Method
        private function InitialiseMain():void
        {
            if (stage)
                this.InitialiseStage();
            else addEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
        }
        
        // InitialiseStage Method
        private function InitialiseStage(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
                                                                   
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align     = StageAlign.TOP_LEFT;
            
            // Black Screen for Wonderfl Capture
            this.graphics.beginFill(0x000000,1);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();            
            
            var $Points:uint = 0;
            
            for (var $column:Number = 0; $column < 3; $column++)
            {
                for (var $row:Number = 0; $row < 3; $row++)
                {
                    displayStar(($row * 170) + 70, ($column * 170) + 70, 50, $Points);
                    $Points++;
                }
            }
            
        }
                        
        // displayStar Method
        private function displayStar($x:int, $y:int, $r:uint, $points:uint) :void
        {
            // $r = Radius
            // $a = Polar Angle or Azimuth
            
            var sprSprite:Sprite = new Sprite;
            
            sprSprite.graphics.clear();
            
            displayAxis(sprSprite);
            
            sprSprite.graphics.beginFill(0xFFFF00, 0.5);
            sprSprite.graphics.lineStyle(2, 0xFFFFFF);
            
            var $arrPoints:Array = new Array(5, 7, 11, 13, 17, 19, 23, 29,31);
            var $m:uint = $arrPoints[$points]/2;
            var $a:uint = 0;
            
            for (var $loop:uint = 0; $loop <= $arrPoints[$points]; $loop++ )
            {
                $a = (((360 * $loop) * $m) / $arrPoints[$points]);
                
                if ($loop == 0) movep($r, $a, sprSprite);
            
                drawp($r, $a, sprSprite);
            }
            
            sprSprite.graphics.endFill();
            
            sprSprite.x = $x;
            sprSprite.y = $y;
            
            addChild(sprSprite);
        }
        
        
        // displayAxis Method
        private function displayAxis($sprObject:Sprite) :void
        {
            $sprObject.graphics.lineStyle(1, 0xFFFFFF,0.5);
            $sprObject.graphics.moveTo(-60, 0);
            $sprObject.graphics.lineTo(60, 0);
            $sprObject.graphics.moveTo(0, -60);
            $sprObject.graphics.lineTo(0, 60);
            
            for (var $Axis:Number = -60; $Axis <= 60; $Axis = $Axis + 5)
            {
                $sprObject.graphics.moveTo(-2, $Axis);
                $sprObject.graphics.lineTo(2, $Axis);
                
                $sprObject.graphics.moveTo($Axis, -2);
                $sprObject.graphics.lineTo($Axis, 2);
            }
        }
        
        // movep Method
        private function movep($r:int, $a:Number, $sprObject:Sprite) :void
        {
            $a = $a * Math.PI / 180;
            
            $sprObject.graphics.moveTo(($r * Math.cos($a)), ($r * Math.sin($a)));
        }
        
        // drawp Method
        private function drawp($r:int, $a:Number, $sprObject:Sprite) :void
        {
            $a = $a * Math.PI / 180;
            
            $sprObject.graphics.lineTo(($r * Math.cos($a)), ($r * Math.sin($a)));
        }
        
    }
}