/**
 * Copyright rickyhk ( http://wonderfl.net/user/rickyhk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/llnz
 */

// forked from rickyhk's forked from: int, uint, Number, String の比較による処理速度の違い
// forked from kaikoga's int, uint, Number, String の比較による処理速度の違い
// forked from kaikoga's forked from: [最適化 Tips] Number, int, uint の計算による処理速度の違い
// forked from tail_y's forked from: [最適化 Tips] Number, int, uint の計算による処理速度の違い
// forked from muta244's [最適化 Tips] Number, int, uint の計算による処理速度の違い
package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:int = 1000000;
    static private var a:Array = new Array();

    
    private function _init():void
    {
        _debug(
            "Compare loop run for " + _NUM_TIMES + " times \n"
        );
        
        
        _measure("initialize", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                a.push(new Point(Math.round(Math.random()*10),Math.round(Math.random()*10)));
            }
        });
        
        _measure("simple for loop", function ():void
        {
            var c:Point;   
            for (var i:uint = 0; i < _NUM_TIMES; i++) { 
                c = a[i];
                var b:String = "x is: " + c.x;
            }
        });
        
        _measure("for each", function ():void
        {
            // For-each loop:
            var p:Point;
            for each (p in a)
            {
                var b:String = "x is: " + p.x;
            }
        });
        
        _measure("for-in loop", function ():void
        {
            // For-in loop:
            var c:Point;
            for (var k:* in a)
            {
               c = a[k];
               var b:String = "x is: " + c.x;
            }        
        });
          
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;

        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
