/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/llZT
 */

// forked from siaukia's Dancing Circles
package {
    import flash.display.MovieClip;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    
    import gs.TweenMax;
    import gs.easing.*;
    
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    
    import flash.events.MouseEvent;
    import flash.events.Event;
    
    public class DancingCircles extends MovieClip {
        
        private var mcLine:MovieClip;
        private var mcCircle1:MovieClip;
        private var mcCircle2:MovieClip;
        private var mcCircle3:MovieClip;
        private var bd:BitmapData;
        private var bdBM:Bitmap;
        
        public function DancingCircles() {
            init();
        }
        
        private function init():void {            
            mcCircle1                           = createCircle();
            mcCircle2                           = createCircle();
            mcCircle3                           = createCircle();
            mcLine                              = new MovieClip();
        
            var glow:GlowFilter                = new GlowFilter(0xFFFFFF);  
            var blur:BlurFilter            = new BlurFilter(20,20,3);
            var filtersArray:Array         = new Array(blur);
            bd                        = new BitmapData(stage.stageWidth,stage.stageHeight,false,0xffffff);
            bdBM                         = new Bitmap(bd);
            bdBM.filters              = filtersArray;
            
            mcCircle1.filters                   = filtersArray;
            mcCircle2.filters                   = filtersArray;
            mcCircle3.filters                   = filtersArray;
            mcLine.filters                      = filtersArray;

            this.addChild(mcLine);
            this.addChild(mcCircle1);
            this.addChild(mcCircle2);
            this.addChild(mcCircle3);
            this.addChild(bdBM)
            this.setChildIndex(bdBM,0)
                        
            repositionMC(mcCircle1);
            repositionMC(mcCircle2);
            repositionMC(mcCircle3);            
        }
        
        // -----------------------------------------------------------------------------------------------------------
        
        private function createCircle():MovieClip {
            var circle:MovieClip                = new MovieClip();
            
            circle.graphics.beginFill(0xFFFFFF, 1);
            circle.graphics.drawCircle( 0, 3, 60); 
            circle.addEventListener(MouseEvent.MOUSE_DOWN, mcClick);
            circle.addEventListener(MouseEvent.MOUSE_UP, mcRelease);
            circle.blendMode = "invert";
             
            return circle;
        }
        private function updateLine(mc:MovieClip):void {
            bd.draw(stage)
            mc.graphics.clear();
            //mc.graphics.lineStyle(1,0xFFFFFF,1);
            mc.graphics.moveTo(mcCircle1.x,mcCircle1.y)
            mc.graphics.lineTo(mcCircle2.x-mc.x,mcCircle2.y-mc.y)
            mc.graphics.lineTo(mcCircle3.x-mc.x,mcCircle3.y-mc.y)
            mc.graphics.lineTo(mcCircle1.x,mcCircle1.y);
        }
        private function repositionMC(mc:MovieClip):void { 
        var posX:Number    =  stage.stageWidth  /2;   //(Math.random()*stage.stageWidth)   * 0.5; 
        var posY:Number    =  stage.stageHeight  /2;   //(Math.random()*stage.stageHeight)  * 0.5;    
        TweenMax.to(mc, 1, {x:posX,y:posY,ease:Sine.easeInOut, onUpdate:mcUpdateCallback, onComplete:mcCompleteCallback,onCompleteParams:[mc]})
        
        TweenMax.to(mcCircle2, 1, {motionBlur:true, rotationZ:mcCircle2.rotationZ++, ease:Quad.easeOut});
        TweenMax.to(mcCircle3, 1, {motionBlur:true, rotationX:mcCircle3.rotationX++, y:+5, ease:Quad.easeOut}); 
                
        }         
        private function mcCompleteCallback(mc:MovieClip):void {
            repositionMC(mc);
        }
        private function mcUpdateCallback():void {
            updateLine(mcLine);            
        }
        
        // -----------------------------------------------------------------------------------------------------------
        
        private function mcClick(e:MouseEvent):void {
            e.target.startDrag();
        }
        private function mcRelease(e:MouseEvent):void {
            e.target.stopDrag();
        }       

    }
}