/**
 * Copyright kawamura ( http://wonderfl.net/user/kawamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lkuh
 */

package 
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    /**
     * ...
     * @author jaiko
     */
    public class Main extends Sprite 
    {
        private var circleList:Array;
        private var pointList:Array;
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            layout();
        }
        
        private function layout():void 
        {
            var i:uint;
            var n:uint;
            var g:Graphics;
            var circle:Circle;
            //
            circleList = [];
            //
            n = 3 + Math.floor(5 * Math.random());
            for (i = 0; i < n; i++)
            {
                circle = new Circle();
                addChild(circle);
                circle.radius = 10 + 10*Math.random();
                circleList.push(circle);
            }

            addEventListener(Event.ENTER_FRAME, enterFrameListener);
        }
        
        private function enterFrameListener(e:Event):void 
        {
            moveCircle();
            draw();
        }
        
        private function moveCircle():void 
        {
            var i:uint;
            var n:uint;
            var circle:Circle;
            n = circleList.length;
            for (i = 0; i < n; i++)
            {
                circle = circleList[i];
                circle.enterFrameListenr();
            }
        }
        
        private function draw():void 
        {
            var i:uint;
            var n:uint;
            var d:Number;
            var distance:Number;
            var _x:Number;
            var _y:Number;
            var theta:Number;
            var g:Graphics;
            var circle:Circle;
            //
            g = this.graphics;
            g.clear();
            g.beginFill(0xFF0000);
            n = circleList.length;
            for (i = 0; i < n; i++)
            {
                circle = circleList[i];
                distance = Math.sqrt(Math.pow(mouseX - circle.x , 2) + Math.pow(mouseY - circle.y , 2));
                if (distance > circle.radius)
                {
                    d = Math.pow(circle.mouseX , 2) + Math.pow(circle.mouseY , 2);
                    _x = circle.x + circle.radius * ( ((circle.mouseX * circle.radius) + circle.mouseY  * Math.sqrt( d - Math.pow(circle.radius , 2))) / d);
                    _y = circle.y + circle.radius * ( ((circle.mouseY * circle.radius) - circle.mouseX  * Math.sqrt( d - Math.pow(circle.radius , 2)) )/ d);
                    g.beginFill(0x000000);
                    g.drawCircle(_x, _y, 5);
                    setLine(_x, _y);
                    _x = circle.x + circle.radius * ( ((circle.mouseX * circle.radius) - circle.mouseY  * Math.sqrt( d - Math.pow(circle.radius , 2))) / d);
                    _y = circle.y + circle.radius * ( ((circle.mouseY * circle.radius) + circle.mouseX  * Math.sqrt( d - Math.pow(circle.radius , 2)) )/ d);
                    g.beginFill(0x000000);
                    g.drawCircle(_x, _y, 5);
                    setLine(_x, _y);
                }
            }
        }
        
        private function setLine(_x:Number, _y:Number):void 
        {
            var g:Graphics = this.graphics;
            var m:Number;
            var n:Number;
            g.lineStyle(1, 0x999999);
            if ( (mouseX -_x) != 0)
            {
                m = (mouseY - _y) / (mouseX -_x);
                n = _y -m * _x;
                g.moveTo(0, n);
                g.lineTo(stage.stageWidth, m * stage.stageWidth + n);
                g.endFill();
            }
            else
            {
                g.moveTo(_x, 0);
                g.lineTo(_x, stage.stageHeight);
                g.endFill();
            }
            
        }
        
    }
    
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.MouseEvent;
class Circle extends Sprite 
{
    private var _radius:Number;
    private var vx:Number;
    private var vy:Number;
    private var preX:Number;
    private var preY:Number;
    public function Circle() 
    {

    }
    
    private function mouseOverListener(e:MouseEvent):void 
    {
        vx *= 3;
        vy *= 3;
    }
    public function enterFrameListenr():void
    {
        vx *= 0.98;
        vy *= 0.98;
        this.x += vx;
        this.y += vy;
        
        if (this.x < 0)
        {
            this.x = 0;
            vx *= -1;
        }
        else if (this.x > stage.stageWidth)
        {
            this.x = stage.stageWidth;
            vx *= -1;
        }
        if (this.y < 0)
        {
            this.y = 0;
            vy *= -1;
        }
        else if ( this.y > stage.stageHeight)
        {
            this.y = stage.stageHeight;
            vy *= -1;
        }
        preX = this.x;
        preY = this.y;
    }
    private function mouseDownListener(e:MouseEvent):void 
    {
        stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
        this.startDrag();
    }
    
    private function mouseUpListener(e:MouseEvent):void 
    {
        stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
        this.stopDrag();
        vx = this.x - preX;
        vy = this.y - preY;
    }
    
    public function get radius():Number 
    {
        return _radius;
    }
    
    public function set radius(value:Number):void 
    {
        if (!_radius)
        {
            _radius = value;
            init();
        }
    }
    
    private function init():void 
    {
        var g:Graphics;
        var theta:Number;
        g = this.graphics;
        g.beginFill(0xFF0000);
        g.drawCircle(0, 0, _radius);
        //
        theta = 2 * Math.PI * Math.random();
        vx = 30 * Math.cos(theta); 
        vy = 30 * Math.sin(theta);
        //
        this.x = 30 + (stage.stageWidth - 60)*Math.random();
        this.y = 30 + (stage.stageHeight - 60) * Math.random();
        
        this.buttonMode = true;
        addEventListener(MouseEvent.MOUSE_DOWN, mouseDownListener);
        addEventListener(MouseEvent.MOUSE_OVER, mouseOverListener);
    }
    
}