/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lkpP
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
 
	public class Main extends Sprite
	{	
		private var bd:BitmapData;
		private var brush:BitmapData;
		private var prev:Point = new Point();
		private var frame:int = 0;
 
		public function Main()
		{	
			bd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0);
			addChild(new Bitmap(bd));
 
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(100, 100, 0);
 
			var rect:Sprite = new Sprite();
			rect.graphics.beginGradientFill("linear", [0xFEBF05, 0xFFD65D], [1.0, 1.0], [0, 255], matrix);
			rect.graphics.drawRect(0, 0, 100, 100);
			rect.graphics.endFill();
 
			brush = new BitmapData(100, 100, true, 0x0);
			brush.draw(rect);
 
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
 
		private function onMouseDown(event:MouseEvent):void
		{	
			prev.x = mouseX;
			prev.y = mouseY;
 
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private function onMouseMove(event:MouseEvent):void
		{
			if (frame++ % 3 == 0)
			{
				var matrix:Matrix = new Matrix();
				matrix.scale((mouseX - prev.x) / brush.width, (mouseY - prev.y) / brush.height);
				matrix.translate(prev.x, prev.y);
 
				bd.draw(brush, matrix); 
				prev.x = mouseX;
				prev.y = mouseY;
			}
		}
 
		private function onMouseUp(event:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}
