/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lkDW
 */

package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.display.StageQuality;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    public class FlashTest extends Sprite {
        
        
        //定数-----------------
        //(private or public) const [定数名] : [クラス名] =  [内容];
        private const KAIGYOU :String = "\n";    //￥ｎ
        
        
        //変数-----------------
        // (private or public) var [変数名] : [クラス名];
        // (private or public) var [変数名] : [クラス名] = [内容];
        private var mySprite :Sprite;
        private var myGra :Graphics;
        private var myText :TextField;
        
        private var myNumber :Number;
        private var myInt :int;
        private var myUint :uint;
        private var myBoolean :Boolean;
        private var myString :String;
        private var myArray :Array;
        
        
        
        //コンストラクタ----------
        // public function [クラス名]() { [処理内容] }
        public function FlashTest() {
            
            
            //--------DisplayObject の例------------
            //表示用クラス。 DisplayObject クラスのサブクラス
            
            
            //■ TextField
            myText = new TextField();
            myText.x = 20;
            myText.y = 20;
            myText.width = 200;
            myText.height = 300;
            myText.text = "TechHUB Flash" + KAIGYOU;
            //myText.autoSize = TextFieldAutoSize.LEFT;
            myText.multiline = true;
            myText.background = true;
            myText.border = true;
            //myText.rotation = 20;    //デバイスフォント(特にフォントデータを指定しないテキスト)は角度を変えると表示されない。
            addChild(myText);
            
            
            //■ Sprite
            mySprite = new Sprite();
            mySprite.x = 300;
            mySprite.y = 100;
            myGra = mySprite.graphics;
            myGra.beginFill(0x999999);
            myGra.drawCircle(0,0,50);
            addChild(mySprite);
            //myText.appendText(mySprite.toString() + KAIGYOU);    //文字として書き出してみる。
            
            
            //■ Stage
            /*
            Sprite や TextField が茶碗や湯飲みだとすると、
            ドキュメントクラス(このクラス。 FlashTest)はお盆。全ての表示オブジェクトを載せるもの。
            さらにそれを載せるちゃぶ台的なものが、Stageクラス。開発者は限定的にしか操作できない。
            Sprite.stage のように、Stageクラスのインスタンスは全ての DisplayObject から直接アクセスできる。
            */
            mySprite.stage.frameRate = 10;
            mySprite.stage.quality = StageQuality.BEST;
            //myText.appendText(mySprite.stage.toString() + KAIGYOU);
            
            
            
            myText.appendText(KAIGYOU + "---------------------" + KAIGYOU);
            //-------top level classes　の例--------------
            
            
            //■ Number
            myNumber = 3.1415;
            myText.appendText("myNumber: " + myNumber.toString() + KAIGYOU);
            
            //■ int
            myInt = 10.5;
            myText.appendText("myInt: " + myInt.toString() + KAIGYOU);
            
            //■ uint
            myUint = 50.1;
            myText.appendText("myUint: " + myUint.toString() + KAIGYOU);
            
            //■ Boolean
            myBoolean = false;
            myText.appendText("myBoolean: " + myBoolean.toString() + KAIGYOU);
            
            //■ String
            myString = "文字列データ";
            myText.appendText("myString: " + myString + KAIGYOU);
            
            //■ Array
            myArray = ["あいう", 1, 2, true, mySprite];
            myText.appendText("myArray: " + myArray.toString() + KAIGYOU);
            
            
            
            myText.appendText(KAIGYOU + "---------------------" + KAIGYOU);
            //--------メソッドの例----------------------------
            
            myNumber = Math.random();
            myText.appendText(myNumber.toString() + KAIGYOU);
            myNumber = Math.floor(myNumber * 10000);
            myText.appendText(myNumber.toString() + KAIGYOU);
            
            
            
        }
    }
}