/**
 * Copyright ricserje ( http://wonderfl.net/user/ricserje )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/ljyf
 */

package {
    
    //code from http://savagelook.com/blog/away3d/away3d-simpleshadow-and-simple-shadows
    
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    
    import away3d.cameras.*;
    import away3d.containers.ObjectContainer3D;
    import away3d.core.math.Number3D;
    import away3d.core.utils.Cast;
    import away3d.materials.BitmapMaterial;
    import away3d.materials.utils.SimpleShadow;
    import away3d.primitives.Cube;
    import away3d.primitives.Plane;
    import away3d.primitives.TextField3D;
    import away3d.containers.View3D;
    import flash.filters.BlurFilter;
    
    //import flash.geom.Vector3D;
    
    //tween
    import caurina.transitions.Tweener;
    import away3d.events.MouseEvent3D;
    
    public class FlashTest extends Sprite {
        
        private var ssCube:Cube;
        private var ssShadow:SimpleShadow;            
        private var pngContainer:ObjectContainer3D;
        private var pngCube:Cube;
        private var pngPlane:Plane;
        private var lastX:int = -1;
        private var lastY:int = -1;
        private var view:View3D;
        
        public function FlashTest() {
            // write as3 code here..
            initAway3D();
        }
        
              
        private function initAway3D():void {
            stage.quality = flash.display.StageQuality.HIGH;
            var cam:Camera3D = new Camera3D({zoom:16,focus:100,x:0,z:-550,y:24});
            view = new View3D({x:250,y:200,z:200,camera:cam});
            //view.camera.position = new Vector3D(0, 100, -200);
            //view.camera.lookAt(new Vector3D(0,0,0));
            addChild(view);
            setupShadowCubes();
            
            addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
           // addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        private function setupShadowCubes():void {
            // setup the SimpleShadow cube
            ssCube = new Cube({height:50, width:50, depth:50, x:-50});
            ssCube.addOnMouseDown(cubeClick);
            view.scene.addChild(ssCube);
            //SimpleShadow(object3d:Object3D, color:uint = 0xFF666666, blur:Number = 4, base:Number, range:Number)
            ssShadow = new SimpleShadow(ssCube, 0xff666666, 50, -50, 50);
            ssShadow.apply(view.scene);
            
            // setup the PNG BitmapMatieral cube
            pngContainer = new ObjectContainer3D();
            pngContainer.x = 50;
            pngCube = new Cube({height:50, width:50, depth:50});
            //pngPlane = new Plane({material:new BitmapMaterial(Cast.bitmap(pngShadow)), height:55, width:55, y:-50, bothsides:true});
            //pngPlane.ownCanvas = true;
            //pngPlane.pushback = true;
            //pngPlane.filters = [new BlurFilter(32, 32)];
            pngContainer.addChild(pngCube);
            //pngContainer.addChild(pngPlane);
            view.scene.addChild(pngContainer);
        }
        
        private function cubeClick(e:MouseEvent3D):void{
              Tweener.addTween(ssCube, {
                                y: 25,
                                scaleX: 1.5,
                                scaleY: 1.5,
                                //alpha:0,
                                time: 2,
                                transition: "easeInOutSine",
                                onComplete: function ():void{     
                                               Tweener.addTween(ssCube, {
                                                    y: 0,
                                                    scaleX: 1,
                                                    scaleY: 1,
                                                    //alpha:0,
                                                    time: 2,
                                                    transition: "easeInOutSine",
                                                    onComplete: function ():void{
                                                        
                                                              
                                                        },
                                                    onCompleteParams: [ssCube]
                                                });    
                                    },
                                onCompleteParams: [ssCube]
                            });            
            }
        
        private function onMouseMove(event:MouseEvent):void {
            var minY:int = 0;
            var maxY:int = 120;
            var minX:int = -150;
            var maxX:int = 50;
            var newX:int = event.stageX;
            var newY:int = event.stageY;
            var speed:Number = 0.33;
            var diff:Number;
            
            if (lastX != -1) {
                diff = (newX - lastX) * speed;
                if (event.buttonDown) {
                    if (!(ssCube.x + diff < minX) && !(ssCube.x + diff > maxX)) {
                        ssCube.x += diff;
                        pngContainer.x += diff;
                    }
                } else {
                    ssCube.rotationY += diff;
                    pngContainer.rotationY += diff;
                }
            }
            lastX = newX;    
            
            // I rotate and move the pngCube and not pngContainer otherwise the shadow would move
            // from its position on the "floor".  Hard to imagine a situation where this is expected behavior!
            if (lastY != -1) {
                diff = (newY - lastY) * speed;
                if (event.buttonDown) {
                    if (!(ssCube.y - diff < minY) && !(ssCube.y - diff > maxY)) {
                        ssCube.y -= diff;
                        pngCube.y -= diff;
                    }
                } else {
                    ssCube.rotationX += diff;
                    pngCube.rotationX += diff;
                }
            }
            lastY = newY;
            
            // positionPlane() only really needs to be called when the shadow's object moves             
            ssShadow.positionPlane();
            
            // apply() only needs to be called when the shadow needs to be redrawm.  This could be caused by
            // scaling, rotating, and increasing the shadow's object's distance from the shadow
            ssShadow.apply(view.scene);
        }
        
        private function onMouseUp(event:MouseEvent):void {
            lastX = -1;
            lastY = -1;
        }
        
        private function render(evt:Event):void {
            view.render();
        }        
    }
}

  
            
            