/**
 * Copyright yasurageruheya ( http://wonderfl.net/user/yasurageruheya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ljiy
 */

package {
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.system.System;
	import flash.text.TextField;
	import flash.utils.ByteArray;
	public class FlashTest extends Sprite {
		
		public const LOOP:int = 500;
		
		public const txt:TextField = new TextField();
		
		public var tests:Vector.<Tester> = new Vector.<Tester>();
		
		public var freeMemory:int;
		
		public var gcCount10byte:int = 0;
		
		public var gcCount100byte:int = 0;
		
		public var gcCount1KB:int = 0;
		
		public var gcCount10KB:int = 0;
		
		public var gcCount100KB:int = 0
		
		public var gcCount1MB:int = 0;
		
		public var gcCount10MB:int = 0;
		
		public var gcCount100MB:int = 0;
		
		public var gcCount:int = 0;
		
		public var totalFrames:Number = 1;
		
		public var vec_byte:Vector.<ByteArray> = new Vector.<ByteArray>();
		
		public function FlashTest() {
			
			var vec:Vector.<Rectangle> = new Vector.<Rectangle>(LOOP);
			var count:int = 0;
			
			stage.frameRate = 1000;
			
			var originalBitmapData:BitmapData = new BitmapData(100, 100, true, 0x0);
			originalBitmapData.perlinNoise(100, 100, 1, 1, false, false);
			
			var mtx:Matrix = new Matrix(1, 0, 0, 1, 25, 25);
			var clipRect:Rectangle = new Rectangle(25, 25, 50, 50);
			var colorTransform:ColorTransform = new ColorTransform(1, 1, 1, 1, 255, 0, 0, 0);
			
			var bmd:BitmapData = new BitmapData(clipRect.width, clipRect.height, true, 0x0);
			var point:Point = new Point();
			
			var originalSizeBmd:BitmapData = new BitmapData(originalBitmapData.width, originalBitmapData.height, originalBitmapData.transparent, 0x0);
			
			//*
			tests[tests.length] = new Tester("draw と clip : ", function():void
			{
				var i:int = LOOP;
				var _clipRect:Rectangle = clipRect;
				while (i--)
				{
					bmd.draw(originalBitmapData, null, null, null, _clipRect);
				}
			});
			
			tests[tests.length] = new Tester("draw と clip（Matrix） : ", function():void
			{
				var i:int = LOOP;
				var _mtx:Matrix = mtx;
				while (i--)
				{
					bmd.draw(originalBitmapData, _mtx);
				}
			});
			
			tests[tests.length] = new Tester("draw と colorTransform : ", function():void
			{
				var i:int = LOOP;
				var _clrTransform:ColorTransform = colorTransform;
				while (i--)
				{
					originalSizeBmd.draw(originalBitmapData, null, _clrTransform, null);
				}
			});
			
			tests[tests.length] = new Tester("draw と clip と colorTransform : ", function():void
			{
				var i:int = LOOP;
				var _clrTransform:ColorTransform = colorTransform;
				var _clipRect:Rectangle = clipRect;
				while (i--)
				{
					bmd.draw(originalBitmapData, null, _clrTransform, null, _clipRect);
				}
			});
			
			tests[tests.length] = new Tester("copyPixels と clip : ", function():void
			{
				var i:int = LOOP;
				var _clrTransform:ColorTransform = colorTransform;
				var _clipRect:Rectangle = clipRect;
				while (i--)
				{
					bmd.copyPixels(originalBitmapData, _clipRect, point, null, null, true);
				}
			});
			
			tests[tests.length] = new Tester("copyPixels と colorTransform : ", function():void
			{
				var i:int = LOOP;
				var _clrTransform:ColorTransform = colorTransform;
				var _clipRect:Rectangle = originalSizeBmd.rect
				while (i--)
				{
					originalSizeBmd.copyPixels(originalBitmapData, _clipRect, point, null, null, true);
					originalSizeBmd.colorTransform(bmd.rect, _clrTransform);
				}
			});
			
			tests[tests.length] = new Tester("copyPixels と clip と colorTransform : ", function():void
			{
				var i:int = LOOP;
				var _clrTransform:ColorTransform = colorTransform;
				var _clipRect:Rectangle = clipRect;
				while (i--)
				{
					bmd.copyPixels(originalBitmapData, _clipRect, point, null, null, true);
					bmd.colorTransform(bmd.rect, _clrTransform);
				}
			});
			/*/
			tests[tests.length] = new Tester("new Rectangle() : ", function():void
			{
				var i:int = LOOP;
				while (i--)
				{
					new Rectangle();
				}
			});
			//*/
			
			tests.reverse();
			txt.width = 500;
			txt.height = 500;
			addChild(txt);
			
			freeMemory = System.freeMemory;
			
			// write as3 code here..
			addEventListener(Event.ENTER_FRAME, test);
		}
		
		private var testIndex:int = 0;
		
		private function test(e:Event):void 
		{
			var str:String = "";
			tests[testIndex].start();
			testIndex++;
			if (tests.length <= testIndex) testIndex = 0;
			var i:int = tests.length;
			while (i--)
			{
				str += tests[i].message;
			}
			/*if (tests.length > 1)
			{
				str += "プーリングと取り出しの合計 : " + (tests[0].timeAverage + tests[1].timeAverage) + " ms.\n";
			}*/
			str += "memory : total " + System.totalMemory + " / private " + System.privateMemory + "\n";
			
			const currentFreeMemory:Number = System.freeMemory;
			
			if (freeMemory < currentFreeMemory)
			{
				gcCount++;
				const gcMemory:Number = currentFreeMemory - freeMemory;
				if (gcMemory > 100000000)
				{
					gcCount100MB++;
				}
				else if (gcMemory > 10000000)
				{
					gcCount10MB++;
				}
				else if (gcMemory > 1000000)
				{
					gcCount1MB++;
				}
				else if (gcMemory > 100000)
				{
					gcCount100KB++;
				}
				else if (gcMemory > 10000)
				{
					gcCount10KB++;
				}
				else if (gcMemory > 1000)
				{
					gcCount1KB++;
				}
				else if (gcMemory > 100)
				{
					gcCount100byte++;
				}
				else if (gcMemory > 10)
				{
					gcCount10byte++;
				}
			}
			freeMemory = System.freeMemory;
			
			str += "\n100MB\tGC発生回数？\t: " + gcCount100MB;
			str += "\n10MB\t\tGC発生回数？\t: " + gcCount10MB;
			str += "\n1MB\t\tGC発生回数？\t: " + gcCount1MB;
			str += "\n100KB\t\tGC発生回数？\t: " + gcCount100KB;
			str += "\n10KB\t\tGC発生回数？\t: " + gcCount10KB;
			str += "\n1KB\t\tGC発生回数？\t: " + gcCount1KB;
			str += "\n100byte\tGC発生回数？\t: " + gcCount100byte;
			str += "\n10byte\t\tGC発生回数？\t: " + gcCount10byte;
			str += "\n\t\t\tGC発生回数？\t: " + gcCount;
			
			str += "\n\t\t\tGC発生率？\t: " + ((gcCount / (totalFrames++)) * 100) + "%";
			
			txt.text = str;
		}
	}
}

import flash.system.System;
import flash.utils.getTimer;
class Tester
{
	public var time:Number = 0;
	
	public var name:String;
	
	public var test:Function;
	
	public var count:Number = 1;
	
	public function start():String
	{
		const startTime:int = getTimer();
		test();
		time += getTimer() - startTime;
		return name + (time / (count++)) + " ms.\n";
	}
	
	public function get message():String
	{
		return name + (time / count) + " ms.\n";
	}
	
	public function get timeAverage():Number
	{
		return time / count;
	}
	
	public function Tester(name:String, test:Function)
	{
		this.name = name;
		this.test = test;
	}
}