/**
 * Copyright foo9 ( http://wonderfl.net/user/foo9 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ljYn
 */

package
{
    import flash.display.Sprite;
    import flash.text.TextField;
    
    [SWF(backgroundColor="#CCCCCC")]
    public class Test extends Sprite 
    {
    		public static const TEST_TEXT:String = "123.456km";
    		public static const TEST_TEXT2:String = "0.12345INCH";
    		public static const TEST_TEXT3:String = "123.456hoge";
    		
    		private var tf:TextField;
    		
    		public function Test()
    		{
    			tf = new TextField();
    			addChild(tf);
    			
    			var tmp:String = "";
    			
    			var lengthTest:Length = new Length(TEST_TEXT);
    			tmp += lengthTest.toString() +"\n"+ lengthTest.value.toString() +"\n"+ lengthTest.unit +"\n"; 
    			tmp += "------------------------\n";    			  
    			tmp += lengthTest.getAs("mm").toString() +"\n";
    			tmp += "------------------------\n";    			 			
    			var lengthTest2:Length = new Length(TEST_TEXT2);
    			tmp += lengthTest2.toString() +"\n"+ lengthTest2.value.toString() +"\n"+ lengthTest2.unit +"\n";
    			//tmp += "------------------------\n";
    			//var lengthTest3:Length = new Length(TEST_TEXT3);
    			//tmp += lengthTest3.toString() +"\n"+ lengthTest3.value.toString() +"\n"+ lengthTest3.unit +"\n";
    			
    			tf.text = tmp;
    		}
    }
}

//************************************************************************************************************

import mx.utils.StringUtil;

class Length 
{
	public static const AUTOMATIC:String = "automatic"; //unit of measurement chosen by implementation.  
	public static const MM:String = "mm"; //milimeter. 
	public static const CM:String = "cm"; //centimeter. 
	public static const M:String = "m"; //meter 
	public static const KM:String = "km"; //kilometer. 
	public static const PT:String = "pt"; //point.  1pt=1/72inch
	public static const PC:String = "pc"; //point code. 
	public static const INCH:String = "inch"; //inch. 
	public static const FT:String = "ft"; //foot. 
	public static const MI:String = "mi"; //mile. 
    
	private var _value:Number;
 	private var _unit:String;
    	
    	public function Length(text:String) 
    {
    		var i:int = text.search(/(automatic$|mm$|cm$|m$|km$|pt$|pc$|inch$|ft$|mi$)/i);
	    	if(i != -1)
	    	{
	    		_value = Number(text.substring(0, i));
			_unit = text.substring(i, text.length).toLowerCase();
	    	}else
	    	{
    			throw new ArgumentError("Invalid length specified.");
    		}
    }
    
    //TODO:
	public function getAs(unit:String):Number 
	{
		return convert(_unit, unit, _value);
	}

	//TODO:
	private function convert(inUnit:String, outUnit:String, value:Number):Number
	{
		var v:Number;
		if(inUnit == outUnit){
			v = value;
		}else{
			if(outUnit == Length.AUTOMATIC){
				v = 0.0; //TODO:
			}else if(outUnit == Length.MM){
		    		if(inUnit == Length.CM) 
		    			v = value * 10;
		    		if(inUnit == Length.M)
					v = value * 1000;
		    		if(inUnit == Length.KM) 
		    			v = value * 1000000;
		    		//if(inUnit == Length.PT) 
		    			//v = value * ;
		    		//if(inUnit == Length.PC) 
		    			//v = value * ;
		    		if(inUnit == Length.INCH) 
		    			v = value * 25.4;
		    		//if(inUnit == Length.FT) 
		    			//v = value * ;
		    		//if(inUnit == Length.MI) 
		    			//v = value * ;
			}else if(outUnit == Length.CM){
	    			v = convert(inUnit, Length.MM, value) / 10.0;
			}else if(outUnit == Length.M){
	    			v = convert(inUnit, Length.MM, value) / 1000.0;
			}else if(outUnit == Length.KM){
	    			//v = convert(inUnit, Length.MM, value) / ;
			}else if(outUnit == Length.PT){
	    			v = convert(inUnit, Length.MM, value) / 0.352777778;
			}else if(outUnit == Length.PC){
	    			//v = convert(inUnit, Length.MM, value) / ;
			}else if(outUnit == Length.INCH){
	    			v = convert(inUnit, Length.MM, value) / 25.4;
			}else if(outUnit == Length.FT){
	    			//v = convert(inUnit, Length.MM, value) / ;
			}else if(outUnit == Length.MI){
	    			//v = convert(inUnit, Length.MM, value) / ;
			}else{
	    			v = 0.0;
			}
		}
		return v;
	}
        
    public function get value():Number{return _value;}        
    public function get unit():String{return _unit;}
        
	public function toString():String
	{
		return _value.toString() + _unit;
 	}
 }
