/**
 * Copyright ahchang ( http://wonderfl.net/user/ahchang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lhZ4
 */

// forked from Scmiz's multi-layer lifegame
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    
    public class FlashTest extends Sprite {
        private var WIDTH:uint = 40;
        private var HEIGHT:uint = WIDTH;
        
        private var _rectArray:Array;
        private var _logicArray:Array;
        private var _frame:uint;
        
        public function FlashTest() {
            this.graphics.beginFill(0x000000);
            this.graphics.drawRect(0, 0, 465, 465);
            this.graphics.endFill();
            
            _rectArray = new Array();
            _logicArray = new Array();
            _frame = 0;

            initLogic(_logicArray);
            initRect();
            
            this.addEventListener(Event.ENTER_FRAME, proc);
        }

        private function initLogic(a:Array):void {
            for (var y:uint = 0; y < HEIGHT + 2; ++y) {
                a.push(new Array());
                for (var x:uint = 0; x < WIDTH + 2; ++x) {
                    if (x == 0 || y == 0 || x == WIDTH + 1 || y == HEIGHT + 1) {
                        a[y].push(false);
                    }
                    else {
                        var flag:Boolean = Math.random() < 0.25;
                        a[y].push(flag);
                    }
                }
            }            
        }

        private function initRect():void {
            for (var y:uint = 0; y < HEIGHT; ++y) {
               _rectArray.push(new Array());
                for (var x:uint = 0; x < WIDTH; ++x) {
                    var r:Rect = new Rect();
                    r.x = 10+(11*x);
                    r.y = 10+(11 * y);
                    this.addChild(r);
                    _rectArray[y].push(r);
                }
            }
        }
       
        private function proc(e:Event):void {
            ++_frame;

            if (_frame < 5) return;
            _frame = 0;
            
            updateLogic(_logicArray);
            updateRect();
        }
        
        private function updateLogic(a:Array):void {
            for (var y:uint = 1; y < HEIGHT + 1; ++y) {
                for (var x:uint = 1; x < WIDTH + 1; ++x) {
                    var num:uint = getNum(a, x, y);
                    
                    if (a[y][x]) {
                        if (num <= 1 || num >= 4) {
                            a[y][x] = false;
                        }
                    }
                    else {
                        if (num == 3) {
                            a[y][x] = true;
                        }
                    }
                }
            }
        }
      
        private function updateRect():void {
            for (var y:uint = 0; y < HEIGHT; ++y) {
                for (var x:uint = 0; x < WIDTH; ++x) {
                    _rectArray[y][x].update(_logicArray[y + 1][x + 1]);
                }
            }
        }
    
        private function getNum(a:Array, x:uint, y:uint):uint {
            var num:uint = 0;
            return num;
        }   
    }
}

import flash.display.Sprite;
import flash.events.Event;
class Rect extends flash.display.Sprite
{
    public const SIZE:uint = 10;
    
    private var _black:Sprite;
    private var _white:Sprite;

    public function Rect() {
        _white = create(0xffffff);
        _black = create(0x000000);
        colorset();
        this.addEventListener(Event.ENTER_FRAME, rectup)
    }
    
    private function create(color:uint):Sprite {
        var s:Sprite = new Sprite();
        s.graphics.beginFill(color);
        s.graphics.drawRect(0, 0, SIZE, SIZE);
        s.graphics.endFill();
        return s;
    }
    
    public function colorset():Sprite {
            if(Math.floor(Math.random()*2) == 0) {
                addChild(_black);
            } else {
                addChild(_white);            
            }
            return _white;
            return _black;
     }
     
     public function rectup(e:Event):void
        {
            if(Math.floor(Math.random()*20) == 0) {
                addChild(_black);
            } else {
                addChild(_white);
            }
            
        } 
}