/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lenl
 */

package {
  import flash.display.Sprite;

  import funnel.*;
  import funnel.ui.*;

  public class DetectVibration extends Sprite {
    // Arduino
    private var arduino:Arduino;

    // センサに接続したピン
    private var sensorPin:Pin;

    // D13に接続されているオンボードのLED
    private var led:LED;

    public function DetectVibration() {
      // LEDに接続したピンのモードを出力にセット
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(13, OUT);
      arduino = new Arduino(config);
      
      // サンプリング間隔を10msに変更
      arduino.samplingInterval = 10;

      // センサとLEDを表す変数を初期化
      sensorPin = arduino.analogPin(0);
      led = new LED(arduino.digitalPin(13));

      // センサに接続したピンに対してSetPointフィルタと
      // イベントリスナをセット
      sensorPin.addFilter(new SetPoint([0.2, 0.05]));
      sensorPin.addEventListener(PinEvent.RISING_EDGE, 
                                 onKnock);
    }

    // センサの値に対してSetPointフィルタをかけたものが
    // 0から1に変化したら以下を実行
    private function onKnock(e:PinEvent):void {
      // LEDを100ms間点灯
      led.blink(100, 1);
    }
  }
}
