/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lejvW
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="465",height="465",frameRate="60")]
    /**
     * ...
     * @author okoi
     */
    public class Main extends Sprite 
    {
        public static const WIDTH:Number = 465;
        public static const HEIGHT:Number = 465;
        public static const TILE_COUNT_X:int = 70;
        public static const TILE_COUNT_Y:int = 70;
        
        private var _forceMap:BitmapData
        private var _forceLife:int;
        private var _particles:Vector.<Particle>;
        
        private var _canvas:BitmapData;
        
        private var _tiles:Array;
                
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            
            this._canvas = new BitmapData(WIDTH, HEIGHT, true, 0 );
            addChild( new Bitmap( this._canvas ) );
            
            this._initParticle();
            this._initForceMap();
            this._initTiles();
                        
            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
        }
        
        /**
         * perlinNoiseを使用してforceMap作成
         */
        private function _initForceMap() : void
        {
            this._forceLife = Math.random() * 50 + 50;
            this._forceMap = new BitmapData(WIDTH, HEIGHT);
            this._forceMap.perlinNoise(
                WIDTH/3,            //    x 方向で使用する周波数(幅)
                HEIGHT/3,            //    y 方向で使用する周波数(高さ)
                1,                    //    重ねる回数　やりすぎると重い
                int(Math.random() * 200),                    //    適当な整数
                true,                //    補正があり、タイリング可能なノイズ生成を試みる(第09引数でスクロール時に効果的)
                true,                //    フラクタルノイズの有無。falseの場合、炎や海の波のような視覚効果
                (0 | 0 | 2 | 1),    // (8 | 4 | 2 | 1),    //    ノイズ生成のチャンネル
                false,                //    グレースケール化
                null                //    第03引数で決めた各レイヤーをスクロールするためのPoint型の配列データ
            );
        }
        
        private function _initParticle () : void
        {
            _particles = new Vector.<Particle>();
            for ( var i:int = 0; i < 3000; i++ ) {
                _addParticle();
            }
        }
        
        private function _initTiles () : void
        {
            this._tiles = new Array();
            this._tiles.x = WIDTH * 0.5;
            this._tiles.y = HEIGHT * 0.5;
            for (var y:int = 0; y < TILE_COUNT_Y; y++) {
                for (var x:int = 0; x < TILE_COUNT_X; x++) {
                    var tile:Tile = new Tile();
                    tile.x = (WIDTH * 0.5) + (Tile.SIZE * 0.5 * x) - (y * Tile.SIZE * 0.5);
                    tile.y = (HEIGHT * 0.5) - (TILE_COUNT_X * Tile.SIZE * 0.25) + (Tile.SIZE * 0.25 * y) + (Tile.SIZE * 0.25 * x);
                    tile.drawCanvas(this._canvas);
                    this._tiles.push( tile );
                }
            }
        }
        
        private function _addParticle() : void
        {
            var p:Particle = new Particle();
            p.x = Math.random() * WIDTH;
            p.y = Math.random() * HEIGHT;
            p.velocityX = 0; p.velocityY = 0;
            this._particles.push( p );
        }
        
        /**
         * 
         * @param    e
         */
        private function _enterFrameHandler (e:Event) : void
        {
            
            var tilesForce:Vector.<int> = new Vector.<int>(TILE_COUNT_X * TILE_COUNT_Y);
            
            var i:int;
            var num:int = this._particles.length;
            for ( i = num - 1; i >= 0; i-- )
            {
                var p:Particle = this._particles[i];
                var col:uint = this._forceMap.getPixel( p.x, p.y );
                var r:uint = (col >> 16) & 0xff;
                var g:uint = (col >> 8) & 0xff;
                var bx:Number = p.x;
                var by:Number = p.y;
                
                p.velocityX += ( r - 128 ) * .001;
                p.velocityY += ( g - 128 ) * .001;
                p.velocityX *= 0.98;
                p.velocityY *= 0.98;
                p.x += p.velocityX;
                p.y += p.velocityY;
                
                if ( p.x < 0 )    p.x = WIDTH + p.x;
                else if ( p.x >= WIDTH )    p.x = p.x % WIDTH;
                if ( p.y < 0 )    p.y = HEIGHT + p.y;
                else if ( p.y >= HEIGHT )    p.y = p.y % HEIGHT;
                
                var rateX:Number = p.x / WIDTH;
                var rateY:Number = p.y / HEIGHT;
                var tileIndex:int = Math.floor(rateX * TILE_COUNT_X) + Math.floor(rateY * TILE_COUNT_Y) * TILE_COUNT_X;
                tilesForce[tileIndex] += 1;
            
            }
            

            
            this._canvas.lock();

            var tileCount:int = this._tiles.length;
            for ( i = 0; i < tileCount; i++ ) {
                var tile:Tile = this._tiles[i] as Tile;
                tile.reduceColorV();
                if (tilesForce[i] > 0) {
                    tile.addColorV( tilesForce[i] );
                }
                tile.drawCanvas(this._canvas);
            }
            this._canvas.unlock();
            
            this._forceLife--;
            if ( this._forceLife <= 0 ) {
                this._initForceMap();
            }
            
            
        }
    }
    
}
import flash.display.Graphics;
import flash.display.Shape;
import flash.geom.Matrix;
import flash.geom.Point;
import frocessing.color.ColorHSV;
import flash.display.BitmapData;

class Particle
{
    public var x:Number;
    public var y:Number;
    public var velocityX:Number;
    public var velocityY:Number;
    public var life:int;
}

class Tile extends Shape
{
    public static const SIZE:int = 20;
    public var color:int = 0x2cf210;
    public var colorV:Number = 50;
    
    private var _colorHSV:ColorHSV = new ColorHSV();
    
    private var _updateFlg:Boolean = true;
    
    private var _sourceTile:BitmapData;
    private static var _sourceTiles:Object = null;
    
    public function Tile() 
    {
        if (!Tile._sourceTiles) {
            Tile._sourceTiles = new Object();
            this._colorHSV.value = color;
            var v:Number = 50;
            var halfSize:Number = SIZE * 0.5;
            var quarterSize:Number = SIZE * 0.25;
            
            for ( ; v <= 100; v += 1 ) {
                var sourceTile:BitmapData = new BitmapData( Tile.SIZE, Tile.SIZE * 0.5, true, 0 );
                this._colorHSV.v = v*0.01;
                
                var shape:Shape = new Shape();
                var g:Graphics = shape.graphics;
                
                this._colorHSV.v = 0.5;        
                g.clear();
                g.lineStyle( 1, this._colorHSV.value );
                this._colorHSV.v = v*0.01;
                g.beginFill( this._colorHSV.value );
                g.moveTo( halfSize, 0 );
                g.lineTo( Tile.SIZE, quarterSize );
                g.lineTo( halfSize,  halfSize );
                g.lineTo( 0, quarterSize );
                g.endFill();
                sourceTile.draw( shape );
                Tile._sourceTiles[""+v] = sourceTile;
            }
        }
    }
    
    
    public function drawTile () : void
    {
        if (!this._updateFlg) return;
        
        var g:Graphics = this.graphics;
            
        var halfSize:Number = SIZE * 0.5;
        var quarterSize:Number = SIZE * 0.25;
            
        g.clear();
        
        this._colorHSV.value = this.color;    
        this._colorHSV.v = 0.5;
        
        g.lineStyle( 1, this._colorHSV.value );
        
        this._colorHSV.v = this.colorV;
        g.beginFill( this._colorHSV.value );
        g.moveTo( 0, -quarterSize );
        g.lineTo(  halfSize, 0 );
        g.lineTo( 0,  quarterSize );
        g.lineTo( -halfSize, 0 );
        g.endFill();
        
        this._updateFlg = false;
    }
    
    public function reduceColorV () : void
    {
        this._updateFlg = true;
        this.colorV -= 1;
        if ( this.colorV < 50 ) {
            this._updateFlg = false;
            this.colorV = 50;
        }
    }
    
    public function addColorV (count:int = 1) : void
    {
        this._updateFlg = true;
        this.colorV += (3 * count);
        if (this.colorV > 100) {
            this._updateFlg = false;
            this.colorV = 100;
        }
    }
    
    public function drawCanvas (canvas:BitmapData) : void
    {
        if (this._updateFlg) {
            canvas.copyPixels( Tile._sourceTiles["" + this.colorV], Tile._sourceTiles["" + this.colorV].rect, new Point(this.x, this.y), Tile._sourceTiles["" + this.colorV], new Point(), true);
        }
        this._updateFlg = false;
    }
}