/**
 * Copyright forresto ( http://wonderfl.net/user/forresto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ldpJ
 */

/*
 * Inspired by Britney Gallivan's math
 * http://www.pomonahistorical.org/12times.htm
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	
	import frocessing.display.*;
	
	[SWF(frameRate="3", backgroundColor="#FFFFFF")] 
	public class FoldingPaperInHalf extends F5MovieClip2D
	{
		
		private var _w:Number;
		private var _h:Number;
		private var _x:int;
		private var _y:int;
		private var current:int = 0;
		private var max:int = 6;

		private var thickness:int = 20;

		public function FoldingPaperInHalf() 
		{
			_w = stage.stageWidth;
			_h = stage.stageHeight;
			_x = 0;
			_y = _h/3;
			noFill();
		}

		public function draw():void
		{
			if( isMousePressed ) {
				current = 0;
				thickness = 20;
			}
			
			if (current < max)
				current++;
			
			fold(current);
		}
		
		public function fold(folds:int):void {
			var numArcs:int = Math.pow(2, folds-1);
			thickness = Math.floor(_w/numArcs/2);
			drawArcs(numArcs*thickness, _y, numArcs);
			_x = 0;
			for (var i:int=numArcs/2; i>=1; i=i/2) {
				_x += thickness*i;
				drawArcs(_x, _y, i, true);
				_x += thickness*i;
			}
		}
		
		public function drawArcs(centerX:Number, centerY:Number, numArcs:int, upper:Boolean=false):void {
			var updown:Number = upper ? -1 : 1;
			for (var i:int=numArcs; i>0; i--) {
				var radius:Number = thickness*i;
				arc(centerX, centerY, radius*2, radius*2, 0, PI*updown);
			}
		}
	}
}
