/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ldIW
 */

package {
  import com.actionscriptbible.Example;
  
  import flash.net.SharedObject;
  import flash.net.registerClassAlias;

  public class ch29ex4 extends Example {
    protected static const RED:uint = 0xff0000;
    protected var currentPage:int;
    protected var so:SharedObject;
    
    public function ch29ex4() {
      registerClassAlias("Bookmark", Bookmark);
      so = SharedObject.getLocal("storage");
      if (so.data.bookmark) {
        trace("Found bookmark...");
        trace(so.data.bookmark);
      } else {
        so.data.bookmark = new Bookmark(345, RED, "b");
        trace("Saving bookmark...");
      }
    }
  }
}

import flash.utils.IDataOutput;
import flash.utils.IDataInput;
import flash.utils.IExternalizable;
class Bookmark implements IExternalizable {
  protected var page:int;
  protected var color:uint;
  protected var name:String;
  
  public function Bookmark(page:int = 0, color:uint = 0, name:String = null) {
      this.page = page;
      this.color = color;
      this.name = name;
  }
  
  public function getPage():int {
    return this.page;
  }
  
  public function readExternal(input:IDataInput):void {
    var props:Object = input.readObject();
    page = props.page;
    color = props.color;
    name = props.name;
  }
  
  public function writeExternal(output:IDataOutput):void {
    var props:Object = {page: page, color: color, name: name};
    output.writeObject(props);
  }
  
  public function toString():String {
    return "[Bookmark at page " + page + " color: 0x" + color.toString(16) +
           " name: " + name + "]";
  }
}
